/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.datasource;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DatasourceHolder;
import org.anyline.data.mongodb.runtime.MongoRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.metadata.Database;
import org.anyline.proxy.DatasourceHolderProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.datasource.holder.mongo")
public class MongoDatasourceHolder
extends DatasourceHolder {
    private static Logger log = LoggerFactory.getLogger(MongoDatasourceHolder.class);

    public MongoDatasourceHolder() {
        DatasourceHolderProxy.reg(MongoClient.class, (DatasourceHolder)this);
        DatasourceHolderProxy.reg(MongoDatabase.class, (DatasourceHolder)this);
    }

    public static String reg(String key, String uri, String database, String user, String password) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uri", uri);
        param.put("database", database);
        param.put("user", user);
        param.put("password", password);
        return MongoDatasourceHolder.reg(key, param, true);
    }

    public static String reg(String key, Map param, boolean override) throws Exception {
        String ds_id = MongoDatasourceHolder.inject(key, param, override);
        return MongoDatasourceHolder.init(key, ds_id, override);
    }

    public static MongoDatabase reg(String key, MongoDatabase ds, boolean over) throws Exception {
        return MongoDatasourceHolder.init(key, ds, over);
    }

    public static MongoDatabase reg(String key, MongoDatabase ds) throws Exception {
        return MongoDatasourceHolder.init(key, ds, true);
    }

    public static String inject(String key, Map param, boolean override) throws Exception {
        return MongoDatasourceHolder.inject(key, null, param, null, override);
    }

    public static String parseDatabase(String uri) {
        String database = null;
        if (null != uri && uri.contains(":")) {
            String[] tmps = uri.split(":");
            if ((tmps = tmps[tmps.length - 1].split("/")).length > 1) {
                database = tmps[tmps.length - 1];
            }
        }
        return database;
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String uri;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (BasicUtil.isEmpty((Object)(uri = (String)MongoDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null)))) {
                return null;
            }
            if (!uri.startsWith("mongodb:")) {
                return null;
            }
            String database = (String)MongoDatasourceHolder.value((Environment)env, (String)prefix, (String)"database", String.class, null);
            if (BasicUtil.isEmpty((Object)database)) {
                database = MongoDatasourceHolder.parseDatabase(uri);
            }
            if (BasicUtil.isEmpty((Object)database)) {
                log.warn("\u7f3a\u5c11Mongo\u6570\u636e\u5e93\u540d");
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("database", database);
            String client = MongoDatasourceHolder.inject(key, prefix, map, env, true);
            if (null == client) {
                return null;
            }
            MongoDatasourceHolder.init(key, client, false);
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String inject(String key, String prefix, Map params, Environment env, boolean override) throws Exception {
        HashMap cache = (HashMap)DatasourceHolder.params.get(key);
        if (null == cache) {
            cache = new HashMap();
            DatasourceHolder.params.put(key, cache);
        }
        MongoDatasourceHolder.check((String)key, (boolean)override);
        String datasource_id = "anyline.datasource." + key;
        String database_id = "anyline.database." + key;
        MongoClient client = null;
        MongoDatabase db = null;
        try {
            String uri = (String)MongoDatasourceHolder.value((Map)params, (String)"url", String.class, null);
            if (BasicUtil.isEmpty((Object)uri)) {
                uri = (String)MongoDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null);
            }
            if (BasicUtil.isEmpty((Object)uri)) {
                return null;
            }
            if (!uri.startsWith("mongodb:")) {
                return null;
            }
            String database = (String)MongoDatasourceHolder.value((Map)params, (String)"database", String.class, null);
            if (BasicUtil.isEmpty((Object)database)) {
                database = MongoDatasourceHolder.parseDatabase(uri);
            }
            if (BasicUtil.isEmpty((Object)database)) {
                log.warn("\u7f3a\u5c11Mongo\u6570\u636e\u5e93\u540d");
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(params);
            map.put("database", database);
            client = MongoClients.create((String)uri);
            db = client.getDatabase(database);
            factory.registerSingleton(datasource_id, (Object)client);
            factory.registerSingleton(database_id, (Object)db);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)key, (Object)e.toString());
            e.printStackTrace();
            return null;
        }
        return datasource_id;
    }

    public static String inject(String key, Map params) throws Exception {
        return MongoDatasourceHolder.inject(key, params, true);
    }

    private static String init(String key, String datasource, boolean over) throws Exception {
        if (null != datasource) {
            MongoDatasourceHolder.check((String)key, (boolean)over);
            MongoRuntimeHolder.reg(key);
        }
        return datasource;
    }

    private static MongoDatabase init(String key, MongoDatabase database, boolean over) throws Exception {
        if (null != database) {
            MongoDatasourceHolder.check((String)key, (boolean)over);
            MongoRuntimeHolder.reg(key);
        }
        return database;
    }

    public DataRuntime callTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return MongoDatasourceHolder.exeTemporary(datasource, database, adapter);
    }

    private static DataRuntime exeTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return MongoRuntimeHolder.temporary(datasource, database, adapter);
    }

    public static boolean validate(String ds) {
        return MongoDatasourceHolder.validate(MongoRuntimeHolder.runtime((String)ds));
    }

    public static boolean validate() {
        return MongoDatasourceHolder.validate(MongoRuntimeHolder.runtime((String)"mongodb"));
    }

    public static boolean validate(DataRuntime runtime) {
        MongoDatabase database = (MongoDatabase)runtime.getProcessor();
        return MongoDatasourceHolder.validate(database);
    }

    public static boolean validate(MongoDatabase database) {
        try {
            return MongoDatasourceHolder.exeValidate(database);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean exeValidate(MongoDatabase database) throws Exception {
        database.getName();
        return true;
    }

    public boolean callValidate(DataRuntime runtime) {
        return MongoDatasourceHolder.validate(runtime);
    }

    public boolean callHit(DataRuntime runtime) throws Exception {
        return MongoDatasourceHolder.exeValidate((MongoDatabase)runtime.getProcessor());
    }

    public static void destroy(String datasource) {
        MongoDatasourceHolder.exeDestroy(datasource);
    }

    public void callDestroy(String datasource) {
        MongoDatasourceHolder.exeDestroy(datasource);
    }

    private static void exeDestroy(String datasource) {
        MongoRuntimeHolder.destroy(datasource);
    }

    public static List<String> copy() {
        return MongoDatasourceHolder.copy("default");
    }

    public static List<String> copy(String datasource) {
        DataRuntime runtime = RuntimeHolder.runtime((String)datasource);
        return MongoDatasourceHolder.copy((DataRuntime)runtime);
    }

    public List<String> callCopy(DataRuntime runtime) {
        return MongoDatasourceHolder.exeCopy(runtime);
    }

    private static List<String> exeCopy(DataRuntime runtime) {
        ArrayList<String> list = new ArrayList<String>();
        AnylineService service = ServiceProxy.service((String)runtime.datasource());
        LinkedHashMap databases = service.metadata().databases();
        Map map = (Map)params.get(runtime.datasource());
        if (null == map) {
            log.warn("\u4e0d\u662f\u4eceanyline\u521b\u5efa\u7684\u6570\u636e\u6e90\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u6e90\u53c2\u6570");
            return list;
        }
        for (String database : databases.keySet()) {
            HashMap<String, String> copy_params = new HashMap<String, String>();
            BeanUtil.copy(copy_params, (Map)map);
            copy_params.put("database", database);
            String key = runtime.datasource() + "_" + database.toLowerCase();
            if (RuntimeHolder.contains((String)key)) {
                list.add(key);
                continue;
            }
            try {
                String id = MongoDatasourceHolder.reg(key, copy_params, true);
                if (null == id) continue;
                RuntimeHolder.runtime((String)key).origin(runtime.getKey());
                list.add(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Database database(String key) {
        Database db = null;
        DataRuntime runtime = RuntimeHolder.runtime((String)key);
        if (null != runtime) {
            db = (Database)runtime.getProcessor();
        }
        return db;
    }
}

