/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import org.anyline.annotation.Component;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.init.DefaultBeanDefine;
import org.anyline.bean.init.DefaultValueReference;
import org.anyline.dao.init.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceMonitor;
import org.anyline.data.mongodb.adapter.MongoAdapter;
import org.anyline.data.mongodb.runtime.MongoRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.runtime.init.AbstractRuntimeHolder;
import org.anyline.service.init.DefaultService;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.runtime.holder.mongo")
public class MongoRuntimeHolder
extends AbstractRuntimeHolder
implements RuntimeHolder {
    private static final MongoRuntimeHolder instance = new MongoRuntimeHolder();

    public static MongoRuntimeHolder instance() {
        return instance;
    }

    public DataRuntime temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        MongoRuntime runtime = new MongoRuntime();
        if (!(datasource instanceof MongoDatabase) && !(datasource instanceof MongoClient)) {
            throw new Exception("\u8bf7\u63d0\u4f9b com.mongodb.client.MongoDatabase \u6216 com.mongodb.client.MongoClient \u517c\u5bb9\u7c7b\u578b");
        }
        String key = "temporary_mongo";
        MongoRuntimeHolder.close(key);
        temporary.remove(key);
        runtimes.remove(key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        runtime.setProcessor(datasource);
        temporary.put(key, datasource);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        runtimes.put(key, runtime);
        return runtime;
    }

    public DataRuntime reg(String key, String datasource) {
        return null;
    }

    public DataRuntime reg(String key, MongoClient client, MongoDatabase database) {
        String datasource_key = "anyline.datasource." + key;
        log.info("[\u6ce8\u5165\u6570\u636e\u6e90][type:mongo][key:{}][bean:{}]", (Object)key, (Object)datasource_key);
        ConfigTable.environment().regBean(datasource_key, (Object)database);
        return this.reg(key, client, database, null);
    }

    public MongoRuntime reg(String datasource, MongoClient client, MongoDatabase database, MongoAdapter adapter) {
        log.debug("[create Mongo runtime][key:{}]", (Object)datasource);
        MongoRuntime runtime = new MongoRuntime(datasource, client, database, adapter);
        if (runtimes.containsKey(datasource)) {
            this.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.debug("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        DefaultBeanDefine daoDefine = new DefaultBeanDefine(DefaultDao.class);
        daoDefine.addValue("runtime", (Object)runtime);
        daoDefine.setLazy(true);
        ConfigTable.environment().regBean(dao_key, (BeanDefine)daoDefine);
        DefaultBeanDefine serviceDefine = new DefaultBeanDefine(DefaultService.class);
        serviceDefine.addValue("dao", (Object)new DefaultValueReference(dao_key));
        serviceDefine.setLazy(true);
        ConfigTable.environment().regBean(service_key, (BeanDefine)serviceDefine);
        return runtime;
    }

    public boolean destroy(String key) {
        MongoRuntime runtime;
        int close = 0;
        DataSourceMonitor monitor = DriverAdapterHolder.getMonitor();
        if (null != monitor && null != (runtime = (MongoRuntime)((Object)runtimes.get(key)))) {
            close = monitor.destroy((DataRuntime)runtime, key, (Object)runtime.client());
        }
        try {
            runtimes.remove(key);
            ConfigTable.environment().destroyBean("anyline.service." + key);
            ConfigTable.environment().destroyBean("anyline.dao." + key);
            ConfigTable.environment().destroyBean("anyline.transaction." + key);
            if (close == 0) {
                MongoRuntimeHolder.close("anyline.datasource." + key);
            }
            ConfigTable.environment().destroyBean("anyline.datasource." + key);
            log.warn("[\u6ce8\u9500\u6570\u636e\u6e90\u53ca\u76f8\u5173\u8d44\u6e90][key:{}]", (Object)key);
            Map runtimes = RuntimeHolder.runtimes((String)key);
            for (String item : runtimes.keySet()) {
                this.destroy(item);
            }
        }
        catch (Exception e) {
            log.error("\u6ce8\u9500\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void close(String key) {
    }

    public static void closeConnection(Object datasource) throws Exception {
    }
}

