/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.mongodb.entity.MongoRow;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.init.AbstractRuntime;
import org.anyline.util.ConfigTable;

public class MongoRuntime
extends AbstractRuntime
implements DataRuntime {
    protected MongoClient client;
    protected MongoDatabase database;

    public MongoRuntime() {
        ConfigTable.DEFAULT_MONGO_ENTITY_CLASS = MongoRow.class;
    }

    public Object getProcessor() {
        return this.database;
    }

    public void setProcessor(Object processor) {
        if (processor instanceof MongoClient) {
            this.client = (MongoClient)processor;
        } else if (processor instanceof MongoDatabase) {
            this.database = (MongoDatabase)processor;
        }
    }

    public String datasource() {
        String datasource = this.key;
        return datasource;
    }

    public MongoRuntime(String key, MongoClient client, MongoDatabase database, DriverAdapter adapter) {
        this.setKey(key);
        this.setClient(client);
        this.setProcessor(database);
        this.setAdapter(adapter);
    }

    public MongoClient client() {
        return this.client;
    }

    public String getFeature(boolean connection) {
        if (null == this.feature && null != this.client) {
            this.feature = this.client.getClass().getName();
        }
        return this.feature;
    }

    public void setClient(MongoClient client) {
        this.client = client;
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(MongoDatabase database) {
        this.database = database;
    }
}

