/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.mongodb.adapter;

import com.mongodb.client.FindIterable;
import com.mongodb.client.ListCollectionNamesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.anyline.adapter.EntityAdapter;
import org.anyline.annotation.Component;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.AbstractDriverAdapter;
import org.anyline.data.mongodb.entity.MongoRow;
import org.anyline.data.mongodb.run.MongoRun;
import org.anyline.data.mongodb.runtime.MongoRuntime;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.CommandQueryException;
import org.anyline.exception.CommandUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Index;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Type;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

@Component(value="anyline.data.adapter.mongo")
public class MongoAdapter
extends AbstractDriverAdapter
implements DriverAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public DatabaseType type() {
        return DatabaseType.MongoDB;
    }

    public boolean supportCatalog() {
        return false;
    }

    public boolean supportSchema() {
        return false;
    }

    public String name(Type type) {
        return types.get(type);
    }

    public Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return null;
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.createInsertRun(runtime, dest, obj, configs, columns);
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Object pv;
        MongoRun run = new MongoRun(runtime, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null != generator && null == (pv = BeanUtil.getFieldValue((Object)obj, (String)"_id", (boolean)true))) {
            ArrayList<String> pk = new ArrayList<String>();
            pk.add("_id");
            generator.create(obj, DatabaseType.MongoDB, dest.getName(), pk, null);
        }
        run.setValue(obj);
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore confis, List<String> columns) {
        MongoRun run = new MongoRun(runtime, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null != generator) {
            Object item;
            Object pv;
            ArrayList<String> pk = new ArrayList<String>();
            pk.add("_id");
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && null == (pv = BeanUtil.getFieldValue(item = iterator.next(), (String)"_id", (boolean)true))) {
                generator.create(item, DatabaseType.MongoDB, dest.getName(), pk, null);
            }
        }
        run.setValue(list);
        return run;
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt;
        block18: {
            cnt = 0L;
            Object value = run.getValue();
            String collection = run.getTableName();
            if (null == value) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][action:insert][collection:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)run.getTableName());
                }
                return -1L;
            }
            MongoRuntime rt = (MongoRuntime)runtime;
            MongoDatabase database = rt.getDatabase();
            long fr = System.currentTimeMillis();
            try {
                MongoCollection cons = null;
                if (value instanceof List) {
                    List list = (List)value;
                    cons = database.getCollection(run.getTableName(), list.get(0).getClass());
                    cnt = list.size();
                    cons.insertMany(list);
                } else if (value instanceof DataSet) {
                    DataSet set = (DataSet)value;
                    cons = database.getCollection(run.getTableName(), ConfigTable.DEFAULT_MONGO_ENTITY_CLASS);
                    cons.insertMany(set.getRows());
                    cnt = set.size();
                } else if (value instanceof EntitySet) {
                    List datas = ((EntitySet)value).getDatas();
                    cons = database.getCollection(run.getTableName(), datas.get(0).getClass());
                    cons.insertMany(datas);
                    cnt = datas.size();
                } else if (value instanceof Collection) {
                    Collection items = (Collection)value;
                    ArrayList list = new ArrayList();
                    for (Object item : items) {
                        list.add(item);
                        ++cnt;
                    }
                    cons = database.getCollection(run.getTableName(), list.get(0).getClass());
                    cons.insertMany(list);
                } else {
                    cons = database.getCollection(run.getTableName(), value.getClass());
                    cons.insertOne(value);
                    cnt = 1L;
                }
                long millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:insert][collection:{}][\u6267\u884c\u8017\u65f6:{}][collection:{}]", new Object[]{random, run.getTableName(), DateUtil.format((long)millis), collection});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, null, null, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:insert][collection:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTableName(), DateUtil.format((long)millis), LogUtil.format((long)cnt, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("insert \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    CommandUpdateException ex = new CommandUpdateException("insert\u5f02\u5e38:" + e, e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block18;
                log.error("{}[{}][collection:{}][param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, run.getTableName(), BeanUtil.object2json((Object)data)});
            }
        }
        return cnt;
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return columns;
    }

    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        MongoRun run = null;
        if (!(prepare instanceof TablePrepare)) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u7c7b\u578b");
        }
        run = new MongoRun(runtime, prepare.getTableName());
        run.setRuntime(runtime);
        run.setPrepare(prepare);
        run.setConfigStore(configs);
        run.addCondition(conditions);
        if (run.checkValid()) {
            run.init();
            this.fillQueryContent(runtime, run);
        }
        return run;
    }

    public Object createConditionJsonContains(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder, boolean unicode) {
        return null;
    }

    protected Run fillQueryContent(DataRuntime runtime, TableRun run) {
        ConfigStore configs;
        List queryColumns;
        ConfigStore configs2;
        MongoRun r = (MongoRun)run;
        Bson bson = null;
        ConditionChain chain = r.getConditionChain();
        bson = this.parseCondition(bson, chain);
        r.setFilter(bson);
        List excludeColumns = r.getExcludeColumns();
        if ((null == excludeColumns || excludeColumns.isEmpty()) && null != (configs2 = r.getConfigs())) {
            excludeColumns = configs2.columns();
        }
        if (null != excludeColumns && !excludeColumns.isEmpty()) {
            r.setExcludeColumns(excludeColumns);
        }
        if ((null == (queryColumns = r.getQueryColumns()) || queryColumns.isEmpty()) && null != (configs = r.getConfigs())) {
            queryColumns = configs.columns();
        }
        if (null != queryColumns && !queryColumns.isEmpty()) {
            r.setQueryColumns(queryColumns);
        }
        return r;
    }

    private Bson parseCondition(Bson bson, Condition condition) {
        if (condition instanceof ConditionChain) {
            ConditionChain chain = (ConditionChain)condition;
            bson = this.parseCondition(bson, chain);
        } else if (condition instanceof AutoCondition) {
            AutoCondition auto = (AutoCondition)condition;
            List values = auto.getValues();
            String column = condition.getId();
            Condition.JOIN join = condition.getJoin();
            Bson create = this.bson(auto.getCompare(), column, values);
            if (null != create) {
                bson = Condition.JOIN.OR == join ? Filters.or((Bson[])new Bson[]{create}) : Filters.and((Bson[])new Bson[]{create});
            }
        }
        return bson;
    }

    private Bson parseCondition(Bson bson, ConditionChain chain) {
        Condition.JOIN join = chain.getJoin();
        Bson child = null;
        List conditions = chain.getConditions();
        for (Condition con : conditions) {
            child = this.parseCondition(null, con);
            if (null == bson) {
                bson = child;
                continue;
            }
            if (null == child) continue;
            if (Condition.JOIN.OR == join) {
                bson = Filters.or((Bson[])new Bson[]{bson, child});
                continue;
            }
            bson = Filters.and((Bson[])new Bson[]{bson, child});
        }
        return bson;
    }

    private Bson bson(Compare compare, String column, List<Object> values) {
        Bson bson = null;
        if (null != values && !values.isEmpty()) {
            ArrayList<Object> value = null;
            if (compare.valueCount() > 1) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll(values);
                value = list;
            } else {
                value = values.get(0);
            }
            int cc = compare.getCode();
            if (cc == 10) {
                bson = Filters.eq((String)column, value);
            } else if (cc == 50 || cc == 999) {
                bson = Filters.regex((String)column, (String)((Object)value).toString());
            } else if (cc == 51) {
                bson = Filters.regex((String)column, (String)("^" + value));
            } else if (cc == 52) {
                bson = Filters.regex((String)column, (String)(value + "$"));
            } else if (cc == 20) {
                bson = Filters.gt((String)column, value);
            } else if (cc == 21) {
                bson = Filters.gte((String)column, value);
            } else if (cc == 30) {
                bson = Filters.lt((String)column, value);
            } else if (cc == 31) {
                bson = Filters.lte((String)column, value);
            } else if (cc == 40) {
                bson = Filters.in((String)column, (Object[])BeanUtil.list2array(values));
            } else if (cc == 80) {
                if (values.size() > 1) {
                    bson = Filters.and((Bson[])new Bson[]{Filters.gte((String)column, (Object)values.get(0)), Filters.lte((String)column, (Object)values.get(1))});
                }
            } else if (cc == 110) {
                bson = Filters.ne((String)column, value);
            } else if (cc == 140) {
                bson = Filters.nin((String)column, (Object[])BeanUtil.list2array(values));
            } else if (cc == 150 || cc == 151 || cc == 152) {
                // empty if block
            }
        }
        return bson;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        DataSet set;
        block14: {
            MongoRun r = (MongoRun)run;
            long fr = System.currentTimeMillis();
            if (null == random) {
                random = this.random(runtime);
            }
            set = new DataSet();
            try {
                PageNavi navi;
                List excludeColumn;
                MongoRuntime rt = (MongoRuntime)runtime;
                MongoDatabase database = rt.getDatabase();
                Bson bson = r.getFilter();
                if (null == bson) {
                    bson = Filters.empty();
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[cmd:select][collection:{}][filter:{}]", new Object[]{random, run.getTableName(), bson});
                }
                FindIterable rows = database.getCollection(run.getTableName(), MongoRow.class).find(bson);
                ArrayList<Bson> fields = new ArrayList<Bson>();
                List queryColumns = run.getQueryColumns();
                if (null != queryColumns && !queryColumns.isEmpty()) {
                    fields.add(Projections.include((List)queryColumns));
                }
                if (null != (excludeColumn = run.getExcludeColumns()) && !excludeColumn.isEmpty()) {
                    fields.add(Projections.exclude((List)excludeColumn));
                }
                if (!fields.isEmpty()) {
                    rows.projection(Projections.fields(fields));
                }
                if (null != (navi = run.getPageNavi())) {
                    rows.skip((int)navi.getFirstRow()).limit(navi.getPageRows());
                }
                for (MongoRow row : rows) {
                    set.add((DataRow)row);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((long)(System.currentTimeMillis() - fr)), set.size()});
                }
                if ((!system || !ConfigStore.IS_LOG_QUERY_RESULT_EXCLUDE_METADATA((ConfigStore)configs)) && ConfigStore.IS_LOG_QUERY_RESULT((ConfigStore)configs) && log.isInfoEnabled()) {
                    log.info("{}[\u67e5\u8be2\u7ed3\u679c]{}", (Object)random, (Object)LogUtil.table((DataSet)set));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("select \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    CommandQueryException ex = new CommandQueryException("query\u5f02\u5e38:" + e, e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block14;
                log.error("{}[{}][cmd:select][collection:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.getTableName()});
            }
        }
        return set;
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Run run = this.buildQueryRun(runtime, prepare, configs, conditions);
        return this.count(runtime, random, run);
    }

    public long count(DataRuntime runtime, String random, Run run) {
        MongoRun r = (MongoRun)run;
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        Bson bson = r.getFilter();
        if (null == bson) {
            bson = Filters.empty();
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[cmd:select][collection:{}][filter:{}]", new Object[]{random, run.getTableName(), bson});
        }
        return database.getCollection(run.getTableName()).countDocuments(bson);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String column, Collection<T> values) {
        return 0L;
    }

    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) {
        MongoRun mr = (MongoRun)run;
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        log.info("{}[action:update][collection:{}][update:{}][filter:{}]", new Object[]{random, run.getTableName(), mr.getUpdate(), mr.getFilter()});
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(run.getTableName());
        UpdateResult dr = cons.updateMany(mr.getFilter(), mr.getUpdate());
        result = dr.getMatchedCount();
        long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
        if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:update][collection:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTableName(), DateUtil.format((long)millis), LogUtil.format((long)result, (int)34)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, null, null, null, true, (Object)result, millis);
            }
        }
        if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:update][collection:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTableName(), DateUtil.format((long)millis), LogUtil.format((long)result, (int)34)});
        }
        return result;
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String key, Collection<T> values) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.and(key, values);
        return this.delete(runtime, random, table, (ConfigStore)configs, new String[0]);
    }

    public long truncate(DataRuntime runtime, String random, Table table) {
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(table.getName());
        DeleteResult dr = cons.deleteMany(Filters.empty());
        result = dr.getDeletedCount();
        long millis = System.currentTimeMillis() - fr;
        if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:truncate][collection:][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table, DateUtil.format((long)millis)});
        }
        return result;
    }

    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        MongoRun run = new MongoRun(runtime, dest);
        run.setOriginType(2);
        LinkedHashMap<Object, Object> cols = new LinkedHashMap();
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        if (null != columns && !columns.isEmpty()) {
            cols = columns;
        } else {
            cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
        }
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        } else {
            primaryKeys = new ArrayList();
            primaryKeys.add("_id");
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey("_ID")) {
            cols.remove("_ID");
        }
        boolean isReplaceEmptyNull = ConfigTable.IS_REPLACE_EMPTY_NULL;
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<Bson> arrayList = new ArrayList<Bson>();
        if (!cols.isEmpty()) {
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
                }
                if (BasicUtil.checkEl((String)("" + value))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if (null == value) {
                    if (!ConfigTable.IS_UPDATE_NULL_FIELD) {
                        chk = false;
                    }
                } else if ("".equals(value) && !ConfigTable.IS_UPDATE_EMPTY_FIELD) {
                    chk = false;
                }
                if (!chk) continue;
                arrayList.add(Updates.set((String)key, (Object)value));
            }
            run.setUpdate(Updates.combine(arrayList));
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
                for (String string : primaryKeys) {
                    if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                        configs.and(string, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    configs.and(string, BeanUtil.getFieldValue((Object)obj, (String)string, (boolean)true));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
        }
        run.setFilter(this.parseCondition(null, run.getConditionChain()));
        return run;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        MongoRun run = new MongoRun(runtime, dest);
        run.setOriginType(1);
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, row, configs, Column.names(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey("_ID")) {
            cols.remove("_ID");
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<Bson> updates = new ArrayList<Bson>();
        if (!cols.isEmpty()) {
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (BasicUtil.checkEl((String)("" + value))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updates.add(Updates.set((String)key, (Object)value));
            }
            run.setUpdate(Updates.combine(updates));
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
                for (String pk : primaryKeys) {
                    configs.and(pk, row.get(pk));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
            run.setFilter(this.parseCondition(null, run.getConditionChain()));
        }
        return run;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs, String key, Object values) {
        if (null == key || null == values) {
            return null;
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            if (collection.isEmpty()) {
                return null;
            }
            configs.in(key, (Object)collection);
        } else {
            configs.and(key, values);
        }
        return this.buildDeleteRun(runtime, table, configs);
    }

    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        if (null == configs || configs.isEmptyCondition()) {
            if (null == columns || columns.length == 0) {
                columns = new String[]{"_id"};
            }
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            for (String column : columns) {
                configs.and(column, BeanUtil.getFieldValue((Object)obj, (String)column, (boolean)true));
            }
        }
        return this.buildDeleteRun(runtime, dest, configs);
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        ArrayList<Run> runs = new ArrayList();
        if (null == obj && (null == configs || configs.isEmptyCondition())) {
            return null;
        }
        MongoRun run = null;
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, (Object)obj, (ConfigStore)configs);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table;
            }
        }
        if (obj instanceof ConfigStore) {
            run = new MongoRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDest(dest);
            run.setPrepare((RunPrepare)prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, run);
            runs.add(run);
        } else {
            runs = this.buildDeleteRunFromEntity(runtime, dest, configs, obj, columns);
        }
        return runs;
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        return null;
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, Table table) {
        return null;
    }

    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        return null;
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, Table table, ConfigStore configs) {
        ArrayList<Run> runs = new ArrayList<Run>();
        MongoRun run = new MongoRun(runtime, table);
        run.setConfigs(configs);
        run.init();
        this.fillDeleteRunContent(runtime, run);
        runs.add(run);
        return runs;
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        MongoRun mr = (MongoRun)run;
        Bson bson = null;
        ConditionChain chain = run.getConditionChain();
        bson = this.parseCondition(bson, chain);
        mr.setFilter(bson);
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        MongoRun mr = (MongoRun)run;
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete((DataRuntime)runtime, (String)random, (Run)run, (ConfigStore)configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        log.info("{}[action:delete][collection:{}][filter:{}]", new Object[]{random, run.getTableName(), mr.getFilter()});
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        MongoCollection cons = database.getCollection(run.getTableName());
        DeleteResult dr = cons.deleteMany(mr.getFilter());
        result = dr.getDeletedCount();
        cmd_success = true;
        long millis = System.currentTimeMillis() - fr;
        if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:delete][collection:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, run.getTableName(), DateUtil.format((long)millis), LogUtil.format((long)result, (int)34)});
        }
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete((DataRuntime)runtime, (String)random, (Run)run, (ConfigStore)configs, (boolean)cmd_success, (long)result, (long)millis);
        return result;
    }

    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        return new ArrayList<Run>();
    }

    public MetadataFieldRefer initTableFieldRefer() {
        return super.initTableFieldRefer();
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        String pattern = query.getName();
        ArrayList<Table> tables = new ArrayList<Table>();
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        ListCollectionNamesIterable names = database.listCollectionNames();
        for (String name : names) {
            Table table = new Table(name);
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                String regex = pattern.replace("%", ".*").replace("_", ".");
                if (!RegularUtil.match((String)name.toUpperCase(), (String)regex.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH)) continue;
                tables.add(table);
                continue;
            }
            tables.add(table);
        }
        if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
            Column column_query = new Column();
            column_query.setCatalog(catalog);
            column_query.setSchema(schema);
            this.columns(runtime, random, greedy, tables, column_query);
        }
        if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
            Index index_query = new Index();
            index_query.setCatalog(catalog);
            index_query.setSchema(schema);
            this.indexes(runtime, random, greedy, tables, index_query);
        }
        return tables;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Column query, ConfigStore configs) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        ArrayList<Object> list = new ArrayList<Object>();
        MongoRuntime rt = (MongoRuntime)runtime;
        MongoDatabase database = rt.getDatabase();
        for (Table table : tables) {
            String cache_key = CacheProxy.key((DataRuntime)runtime, (String)"collection_column", (boolean)greedy, (Catalog)catalog, (Schema)schema, (String)table.getName());
            LinkedHashMap columns = CacheProxy.columns((String)cache_key);
            if (null == columns || columns.isEmpty()) {
                MongoCollection collection = database.getCollection(table.getName());
                if (null == collection || ConfigTable.CHECK_METADATA_SAMPLE <= 0) continue;
                for (Document doc : collection.find().limit(ConfigTable.CHECK_METADATA_SAMPLE)) {
                    Set fields = doc.keySet();
                    for (String field : fields) {
                        Object value;
                        String up = field.toUpperCase();
                        if (columns.containsKey(up) || null == (value = doc.get((Object)field))) continue;
                        String type = value.getClass().getSimpleName();
                        Column column = new Column(field, type);
                        columns.put(up, column);
                        list.add(column);
                    }
                }
                CacheProxy.cache((String)cache_key, (Object)columns);
                continue;
            }
            list.addAll(columns.values());
        }
        return list;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Column query) throws Exception {
        return null;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Tag query) throws Exception {
        return null;
    }

    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        return null;
    }

    public <T extends Metadata> void checkSchema(DataRuntime runtime, T meta) {
    }

    public LinkedHashMap<String, Column> metadata(DataRuntime runtime, RunPrepare prepare, boolean comment) {
        return null;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "collection");
        types.put((Type)Metadata.TYPE.TABLE, "collection");
    }
}

