/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring;

import java.util.Hashtable;
import java.util.Map;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.init.DefaultEntityAdapter;
import org.anyline.adapter.init.JavaTypeAdapter;
import org.anyline.bean.LoadListener;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.DataType;
import org.anyline.proxy.ConvertProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.configuration.spring")
public class SpringAutoConfiguration
implements InitializingBean {
    @Autowired(required=false)
    private Map<String, LoadListener> listeners;

    @Autowired(required=false)
    public void setConverts(Map<String, Convert> converts) {
        for (Convert convert : converts.values()) {
            Class origin = convert.getOrigin();
            Class target = convert.getTarget();
            Hashtable<Class, Convert> map = (Hashtable<Class, Convert>)ConvertProxy.converts.get(origin);
            if (null == map) {
                map = new Hashtable<Class, Convert>();
                ConvertProxy.converts.put(origin, map);
            }
            map.put(target, convert);
            DataType type = (DataType)JavaTypeAdapter.types.get(origin);
            if (null == type) continue;
            type.convert(convert);
        }
    }

    @Autowired(required=false)
    public void setEntityAdapter(Map<String, EntityAdapter> adapters) {
        if (ConfigTable.IS_DISABLED_DEFAULT_ENTITY_ADAPTER) {
            for (String key : adapters.keySet()) {
                EntityAdapter adapter = adapters.get(key);
                if (!(adapter instanceof DefaultEntityAdapter)) continue;
                adapters.remove(key);
            }
        }
        EntityAdapterProxy.setAdapters(adapters);
    }

    public void afterPropertiesSet() throws Exception {
        if (null != this.listeners) {
            for (LoadListener listener : this.listeners.values()) {
                listener.after();
            }
        }
    }
}

