/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.EnvironmentWorker;
import org.anyline.adapter.init.DefaultEnvironmentWorker;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.ValueReference;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.worker.spring")
public class SpringEnvironmentWorker
extends DefaultEnvironmentWorker
implements EnvironmentAware,
EnvironmentWorker,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(SpringEnvironmentWorker.class);
    private Environment environment;
    private static DefaultListableBeanFactory factory;
    public ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
        factory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        ConfigTable.setEnvironment((EnvironmentWorker)this);
    }

    public void setEnvironment(Environment environment) {
        Field[] fields;
        ConfigTable.setEnvironment((EnvironmentWorker)this);
        this.environment = environment;
        for (Field field : fields = ConfigTable.class.getDeclaredFields()) {
            String name = field.getName();
            String value = this.string("anyline", "." + name);
            if (!BasicUtil.isNotEmpty((Object)value) || Modifier.isFinal(field.getModifiers())) continue;
            BeanUtil.setFieldValue(null, (Field)field, (Object)value);
        }
    }

    public Object getBean(String name) {
        if (this.context.containsBean(name)) {
            return this.context.getBean(name);
        }
        return null;
    }

    public <T> Map<String, T> getBeans(Class<T> clazz) {
        return this.context.getBeansOfType(clazz);
    }

    private static BeanDefinition convert(BeanDefine define) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((Class)define.getType());
        LinkedHashMap values = define.getValues();
        for (String key : values.keySet()) {
            Object value = values.get(key);
            if (value instanceof ValueReference) {
                builder.addPropertyReference(key, ((ValueReference)value).getName());
                continue;
            }
            builder.addPropertyValue(key, value);
        }
        builder.setPrimary(define.isPrimary());
        builder.setLazyInit(define.isLazy());
        return builder.getBeanDefinition();
    }

    public boolean regBean(String name, BeanDefine bean) {
        return this.reg(name, bean);
    }

    public void regAlias(String name, String alias) {
        factory.registerAlias(name, alias);
    }

    public boolean regBean(String name, Object bean) {
        return this.reg(name, bean);
    }

    public boolean reg(String name, Object bean) {
        if (bean instanceof BeanDefine) {
            BeanDefine define = (BeanDefine)bean;
            if (name.endsWith("default")) {
                define.setPrimary(true);
            }
            factory.registerBeanDefinition(name, SpringEnvironmentWorker.convert(define));
        } else if (bean instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)bean;
            if (name.endsWith("default")) {
                definition.setPrimary(true);
            }
            factory.registerBeanDefinition(name, definition);
        } else if (bean instanceof Class) {
            Class clazz = (Class)bean;
            try {
                factory.registerSingleton(name, clazz.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            factory.registerSingleton(name, bean);
        }
        return true;
    }

    public boolean destroyBean(String bean) {
        if (factory.containsBean(bean)) {
            factory.destroySingleton(bean);
        }
        if (factory.containsBeanDefinition(bean)) {
            factory.removeBeanDefinition(bean);
        }
        return true;
    }

    public <T> T getBean(Class<T> clazz) {
        Map<String, T> beans = this.getBeans(clazz);
        if (null != beans && !beans.isEmpty()) {
            for (Map.Entry<String, T> set : beans.entrySet()) {
                T bean = set.getValue();
                if (null == bean) continue;
                return bean;
            }
        }
        return null;
    }

    public <T> T getBean(String name, Class<T> clazz) {
        return (T)factory.getBean(name, clazz);
    }

    public boolean containsBean(String name) {
        return factory.containsBean(name);
    }

    public Object getSingletonBean(String name) {
        return factory.getSingleton(name);
    }

    public boolean containsSingleton(String name) {
        return factory.containsSingleton(name);
    }

    public <T> T getSingletonBean(String name, Class<T> clazz) {
        return (T)factory.getSingleton(name);
    }

    public Object get(String key) {
        String val = this.environment.getProperty(key);
        if (null == val) {
            key = key.startsWith("anyline.") ? key.replace("anyline.", "") : "anyline." + key;
            val = this.environment.getProperty(key);
        }
        return val;
    }

    public String getString(String key) {
        return this.environment.getProperty(key);
    }

    public Map<String, Object> inject(String id, String prefix, Map params, Map<String, HashSet<String>> alias, Class clazz) throws Exception {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
        List methods = ClassUtil.getMethods((Class)clazz, (boolean)true);
        for (Method method : methods) {
            Class<?> paramType;
            String name;
            if (method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !(name = method.getName()).startsWith("set")) continue;
            Object value = BeanUtil.value((Map)params, (String)(name = name.substring(3, 4).toLowerCase() + name.substring(4)), alias, paramType = method.getParameters()[0].getType(), null);
            if (null == value) {
                value = this.value(prefix, name, alias, paramType, null);
            }
            if (null == value) continue;
            cache.put(name, value);
            ds_builder.addPropertyValue(name, value);
        }
        AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
        this.regBean(id, ds_definition);
        log.info("[inject bean][type:{}][bean:{}]", (Object)clazz, (Object)id);
        return cache;
    }

    public Map<String, Object> inject(String id, Map params, Class clazz) throws Exception {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        BeanDefinitionBuilder ds_builder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
        List methods = ClassUtil.getMethods((Class)clazz, (boolean)true);
        for (Method method : methods) {
            Class<?> tp;
            Object value;
            String name;
            if (method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !(name = method.getName()).startsWith("set") || null == (value = BeanUtil.value((Map)params, (String)(name = name.substring(3, 4).toLowerCase() + name.substring(4)), null, Object.class, null)) || null == (value = ConvertProxy.convert((Object)value, tp = method.getParameters()[0].getType(), (boolean)false))) continue;
            cache.put(name, value);
            ds_builder.addPropertyValue(name, value);
        }
        AbstractBeanDefinition ds_definition = ds_builder.getBeanDefinition();
        this.regBean(id, ds_definition);
        log.info("[inject bean][type:{}][bean:{}]", (Object)clazz, (Object)id);
        return cache;
    }
}

