/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.feishu.util;

import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.feishu.util.FeishuUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class FeishuConfig
extends AnylineConfig {
    public static String CONFIG_NAME = "anyline-feishu.xml";
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    public static String DEFAULT_APP_ID = "";
    public static String DEFAULT_APP_SECRET = "";
    public static String DEFAULT_OAUTH_REDIRECT_URL;
    protected static String[] compatibles;
    public String APP_ID = DEFAULT_APP_ID;
    public String APP_SECRET = DEFAULT_APP_SECRET;
    public String OAUTH_REDIRECT_URL = DEFAULT_OAUTH_REDIRECT_URL;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        FeishuConfig.parse(FeishuConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        FeishuConfig.load();
    }

    public static FeishuConfig getInstance() {
        return FeishuConfig.getInstance("default");
    }

    public static FeishuConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            FeishuConfig.load();
        }
        return (FeishuConfig)instances.get(key);
    }

    private static synchronized void load() {
        FeishuConfig.load(instances, FeishuConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static FeishuConfig register(String instance, DataRow row) {
        FeishuConfig config = (FeishuConfig)FeishuConfig.parse(FeishuConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        FeishuUtil.getInstance(instance);
        return config;
    }

    public static FeishuConfig register(DataRow row) {
        return FeishuConfig.register("default", row);
    }

    public static FeishuConfig register(String instance, String app, String secret, String redirect) {
        DataRow row = new DataRow();
        row.put("APP_ID", (Object)app);
        row.put("APP_SECRET", (Object)secret);
        row.put("OAUTH_REDIRECT_URL", (Object)redirect);
        return FeishuConfig.register(instance, row);
    }

    public static FeishuConfig register(String app, String secret, String redirect) {
        return FeishuConfig.register("default", app, secret, redirect);
    }

    public static FeishuConfig register(String app, String secret) {
        return FeishuConfig.register("default", app, secret, null);
    }

    static {
        compatibles = new String[]{"OAUTH_REDIRECT_URL:AUTH_REDIRECT_URL"};
        FeishuConfig.init();
        FeishuConfig.debug();
    }
}

