/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.feishu.util;

import com.lark.oapi.Client;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.anyline.adapter.KeyAdapter;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.feishu.entity.Department;
import org.anyline.feishu.entity.User;
import org.anyline.feishu.util.FeishuConfig;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeishuUtil {
    private static final Logger log = LoggerFactory.getLogger(FeishuUtil.class);
    private static Hashtable<String, FeishuUtil> instances = new Hashtable();
    private FeishuConfig config = null;
    private Client client;
    private String tenant_access_token = null;
    private Long tenant_access_token_time = null;

    public FeishuUtil() {
    }

    public FeishuUtil(FeishuConfig config) {
        this.config = config;
        this.client = Client.newBuilder((String)config.APP_ID, (String)config.APP_SECRET).build();
    }

    public static Hashtable<String, FeishuUtil> getInstances() {
        return instances;
    }

    public Client client() {
        return this.client;
    }

    public void client(Client client) {
        this.client = client;
    }

    public static FeishuUtil getInstance() {
        return FeishuUtil.getInstance("default");
    }

    public static FeishuUtil getInstance(String key) {
        FeishuConfig config;
        FeishuUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = FeishuConfig.getInstance(key))) {
            util = new FeishuUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public static FeishuUtil reg(String key, DataRow config) {
        FeishuConfig conf = FeishuConfig.register(key, config);
        FeishuUtil util = new FeishuUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static FeishuUtil reg(String key, String id, String secret) {
        FeishuConfig conf = FeishuConfig.register(key, id, secret);
        FeishuUtil util = new FeishuUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static FeishuUtil reg(String key, String id, String secret, String redirect) {
        FeishuConfig conf = FeishuConfig.register(key, id, secret, redirect);
        FeishuUtil util = new FeishuUtil(conf);
        instances.put(key, util);
        return util;
    }

    public FeishuConfig config() {
        return this.config;
    }

    public String tenant_access_token() {
        if (null == this.tenant_access_token || (System.currentTimeMillis() - this.tenant_access_token_time) / 1000L > 7000L) {
            this.flushToken();
        }
        return this.tenant_access_token;
    }

    public DataRow access_token(String code) {
        DataRow token = null;
        String url = "https://open.feishu.cn/open-apis/authen/v1/oidc/access_token";
        Hashtable<String, Object> header = new Hashtable<String, Object>();
        header.put("Content-Type", "application/json; charset=utf-8");
        header.put("Authorization", "Bearer " + this.tenant_access_token());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        String json = BeanUtil.map2json(params);
        String body = HttpUtil.post(header, (String)url, (HttpEntity)new StringEntity(json, "UTF-8")).getText();
        log.info("[get feishu access token][body:{}]", (Object)body);
        DataRow row = DataRow.parseJson((KeyAdapter.KEY_CASE)KeyAdapter.KEY_CASE.SRC, (String)body);
        token = row.getRow("data");
        return token;
    }

    public User user(String code) {
        User user = this.user(this.access_token(code));
        return user;
    }

    public User user(DataRow token) {
        User user = new User();
        String url = "https://open.feishu.cn/open-apis/authen/v1/user_info";
        Hashtable<String, Object> header = new Hashtable<String, Object>();
        header.put("Content-Type", "application/json; charset=utf-8");
        header.put("Authorization", "Bearer " + token.getString("access_token"));
        String body = HttpUtil.get(header, (String)url).getText();
        log.info("[get feishu user info][body:{}]", (Object)body);
        DataRow row = DataRow.parseJson((KeyAdapter.KEY_CASE)KeyAdapter.KEY_CASE.SRC, (String)body);
        DataRow data = row.getRow("data");
        user = FeishuUtil.info(data);
        return user;
    }

    public static User info(DataRow data) {
        Long joinTime;
        DataRow status;
        User user = new User();
        user.setName(data.getString("name"));
        user.setEnName(data.getString("en_name"));
        if (data.isNotEmpty("avatar")) {
            DataRow avators = data.getRow("avatar");
            if (null != avators) {
                user.setAvatarBig(data.getString("AVATAR_640"));
                user.setAvatarUrl(data.getString("AVATAR_ORIGIN"));
                user.setAvatarThumb(data.getString("AVATAR_72"));
                user.setAvatarMiddle(data.getString("AVATAR_240"));
            }
        } else {
            user.setAvatarBig(data.getString("avatar_big"));
            user.setAvatarUrl(data.getString("avatar_url"));
            user.setAvatarThumb(data.getString("avatar_thumb"));
            user.setAvatarMiddle(data.getString("avatar_middle"));
        }
        if (data.isNotEmpty("status") && null != (status = data.getRow("status"))) {
            user.setActivateStatus(status.getBoolean("is_activated", null));
            user.setFrozenStatus(status.getBoolean("is_frozen", null));
            user.setResignStatus(status.getBoolean("is_resigned", null));
        }
        if ((joinTime = data.getLong("join_time", Integer.valueOf(0))) > 0L) {
            Date date = DateUtil.parse((Long)(joinTime * 1000L));
            user.setJoinTime(date);
            user.setJoinYmd(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
        }
        user.setNickname(data.getString("nickname"));
        List depts = data.getList("department_ids");
        user.setDepartmentIds(depts);
        user.setLeaderId(data.getString("leader_user_id"));
        user.setJobTitle(data.getString("job_title"));
        user.setWorkStation(data.getString("work_station"));
        user.setOpenid(data.getString("open_id"));
        user.setUnionid(data.getString("union_id"));
        user.setEmail(data.getString("email"));
        user.setMobile(data.getString("mobile"));
        user.setEnterpriseEmail(data.getString("enterprise_email"));
        user.setEmployeeNo(data.getString("employee_no"));
        user.setId(data.getString("user_id"));
        user.setTenantKey(data.getString("tenant_key"));
        return user;
    }

    public List<User> users() {
        ArrayList<User> users = new ArrayList<User>();
        String url = "https://open.feishu.cn/open-apis/contact/v3/scopes";
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Bearer " + this.tenant_access_token())));
        String body = HttpUtil.get(header, (String)url).getText();
        DataRow row = DataRow.parseJson((String)body);
        List ids = row.getRow("data").getList("user_ids");
        if (null != ids) {
            List pages = BeanUtil.page((Collection)ids, (int)50);
            for (List page : pages) {
                users.addAll(this.users(page));
            }
        }
        return users;
    }

    public List<User> users(List<String> ids) {
        ArrayList<User> users = new ArrayList<User>();
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Bearer " + this.tenant_access_token())));
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("user_ids", ids);
        String url = "https://open.feishu.cn/open-apis/contact/v3/users/batch";
        String body = HttpUtil.get(header, (String)url, (String)"UTF-8", params).getText();
        DataRow row = DataRow.parseJson((String)body);
        DataSet items = row.getRow("data").getSet("items");
        if (null != items) {
            for (DataRow item : items) {
                users.add(FeishuUtil.info(item));
            }
        }
        return users;
    }

    public List<User> users(Department department) {
        String body;
        DataRow row;
        DataRow data;
        ArrayList<User> users = new ArrayList<User>();
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Bearer " + this.tenant_access_token())));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("department_id", "0");
        params.put("page_size", 50);
        if (null != department) {
            String id = department.getCode();
            String openid = department.getOpenid();
            if (BasicUtil.isNotEmpty((Object)id)) {
                params.put("department_id_type", "department_id");
                params.put("department_id", id);
            } else if (BasicUtil.isNotEmpty((Object)openid)) {
                params.put("department_id_type", "open_department_id");
                params.put("department_id", openid);
            }
        }
        String url = "https://open.feishu.cn/open-apis/contact/v3/users/find_by_department";
        while (null != (data = (row = DataRow.parseJson((String)(body = HttpUtil.get(header, (String)url, (String)"UTF-8", params).getText()))).getRow("data"))) {
            DataSet items = data.getSet("items");
            if (null != items) {
                for (DataRow item : items) {
                    users.add(FeishuUtil.info(item));
                }
            }
            params.put("page_token", data.getString("page_token"));
            if (data.getBoolean("has_more", Boolean.valueOf(false)).booleanValue()) continue;
            break;
        }
        return users;
    }

    public List<Department> departments() {
        return this.departments("0");
    }

    public List<Department> departments(String parent) {
        ArrayList<Department> departments;
        block6: {
            String body;
            DataRow row;
            departments = new ArrayList<Department>();
            String url = "https://open.feishu.cn/open-apis/contact/v3/departments/" + parent + "/children";
            HashMap<String, CallSite> header = new HashMap<String, CallSite>();
            header.put("Authorization", (CallSite)((Object)("Bearer " + this.tenant_access_token())));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("page_size", 50);
            while ((row = DataRow.parseJson((String)(body = HttpUtil.get(header, (String)url, (String)"UTF-8", params).getText()))).getInt("CODE", Integer.valueOf(-1)) == 0) {
                DataRow data = row.getRow("data");
                if (null == data) break block6;
                DataSet items = data.getItems();
                if (null != items) {
                    for (DataRow item : items) {
                        Department department = new Department();
                        department.setCode(item.getString("department_id"));
                        department.setName(item.getString("name"));
                        department.setOpenid(item.getString("open_department_id"));
                        department.setParentCode(item.getString("parent_department_id"));
                        DataSet leaders = item.getSet("leaders");
                        if (null != leaders) {
                            for (DataRow leader : leaders) {
                                if (leader.getInt("leaderType", Integer.valueOf(0)) != 1) continue;
                                department.setLeaderCode(leader.getString("leaderID"));
                            }
                        }
                        departments.add(department);
                    }
                }
                if (data.getBoolean("has_more").booleanValue()) {
                    params.put("page_token", data.getString("page_token"));
                    continue;
                }
                break block6;
            }
            log.warn("[departments][response:{}]", (Object)body);
        }
        return departments;
    }

    private void flushToken() {
        String url = "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal/";
        Hashtable<String, String> header = new Hashtable<String, String>();
        header.put("Content-Type", "application/json; charset=utf-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.config.APP_ID);
        params.put("app_secret", this.config.APP_SECRET);
        try {
            String json = BeanUtil.map2json(params);
            String body = HttpUtil.post(header, (String)url, (HttpEntity)new StringEntity(json, "UTF-8")).getText();
            DataRow row = DataRow.parseJson((String)body);
            if ("0".equals(row.getString("code"))) {
                this.tenant_access_token = row.getString("tenant_access_token");
                this.tenant_access_token_time = System.currentTimeMillis();
            } else {
                log.warn("[flush token][response:{}]", (Object)body);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String createAuthUrl(String callback, String scope, String state) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://open.feishu.cn/open-apis/authen/v1/authorize?app_id=").append(this.config.APP_ID);
        if (BasicUtil.isEmpty((Object)callback)) {
            callback = this.config.OAUTH_REDIRECT_URL;
        }
        builder.append("&redirect_uri=").append(HttpUtil.encode((String)callback, (boolean)false, (boolean)true));
        builder.append("&scope=").append(scope);
        if (BasicUtil.isNotEmpty((Object)state)) {
            builder.append("&state=").append(state);
        }
        return builder.toString();
    }

    public String createAuthUrl(String callback, String state) {
        return this.createAuthUrl(callback, "contact:contact.base:readonly", state);
    }

    public String createAuthUrl(String state) {
        return this.createAuthUrl(this.config.OAUTH_REDIRECT_URL, state);
    }

    static {
        Hashtable<String, AnylineConfig> configs = FeishuConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, FeishuUtil.getInstance(key));
        }
    }
}

