/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mail.util;

import java.io.File;
import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.mail.util.MailUtil;
import org.anyline.mail.util.Pop3Util;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class MailConfig
extends AnylineConfig {
    public static String CONFIG_NAME = "anyline-mail.xml";
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    private static File configDir;
    public static String DEFAULT_ACCOUNT;
    public static String DEFAULT_PASSWORD;
    public static String DEFAULT_USERNAME;
    public static String DEFAULT_PROTOCOL;
    public static String DEFAULT_HOST;
    public static String DEFAULT_PORT;
    public static String DEFAULT_ATTACHMENT_DIR;
    public static boolean DEFAULT_SSL;
    public static boolean DEFAULT_AUTO_DOWNLOAD_ATTACHMENT;
    public String ACCOUNT = DEFAULT_ACCOUNT;
    public String PASSWORD = DEFAULT_PASSWORD;
    public String USERNAME = DEFAULT_USERNAME;
    public String PROTOCOL = DEFAULT_PROTOCOL;
    public String HOST = DEFAULT_HOST;
    public String PORT = DEFAULT_PORT;
    public String ATTACHMENT_DIR = DEFAULT_ATTACHMENT_DIR;
    public boolean SSL = DEFAULT_SSL;
    public boolean AUTO_DOWNLOAD_ATTACHMENT = DEFAULT_AUTO_DOWNLOAD_ATTACHMENT;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        MailConfig.parse(MailConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        MailConfig.load();
    }

    public static void setConfigDir(File dir) {
        configDir = dir;
        MailConfig.init();
    }

    public static MailConfig getInstance() {
        return MailConfig.getInstance("default");
    }

    public static MailConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            MailConfig.load();
        }
        return (MailConfig)instances.get(key);
    }

    private static synchronized void load() {
        MailConfig.load(instances, MailConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static MailConfig register(String instance, DataRow row) {
        MailConfig config = (MailConfig)MailConfig.parse(MailConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        MailUtil.getInstance(instance);
        Pop3Util.getInstance(instance);
        return config;
    }

    public static MailConfig register(DataRow row) {
        return MailConfig.register("default", row);
    }

    static {
        DEFAULT_ACCOUNT = null;
        DEFAULT_PASSWORD = null;
        DEFAULT_USERNAME = null;
        DEFAULT_PROTOCOL = "smtp";
        DEFAULT_HOST = null;
        DEFAULT_PORT = null;
        DEFAULT_ATTACHMENT_DIR = "";
        DEFAULT_SSL = false;
        DEFAULT_AUTO_DOWNLOAD_ATTACHMENT = true;
        MailConfig.init();
        MailConfig.debug();
    }
}

