/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mail.util;

import org.anyline.entity.DataRow;
import org.anyline.mail.util.MailConfig;
import org.anyline.mail.util.MailUtil;
import org.anyline.mail.util.Pop3Util;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="anyline.mail.load.bean")
public class MailBean
implements InitializingBean {
    @Value(value="${anyline.mail.account:}")
    public String ACCOUNT;
    @Value(value="${anyline.mail.password:}")
    public String PASSWORD;
    @Value(value="${anyline.mail.user:}")
    public String USERNAME;
    @Value(value="${anyline.mail.protocol:}")
    public String PROTOCOL;
    @Value(value="${anyline.mail.host:}")
    public String HOST;
    @Value(value="${anyline.mail.port:}")
    public String PORT;
    @Value(value="${anyline.mail.attachment:}")
    public String ATTACHMENT_DIR;
    @Value(value="${anyline.mail.ssl:false}")
    public boolean SSL;
    @Value(value="${anyline.mail.download:true}")
    public boolean AUTO_DOWNLOAD_ATTACHMENT;

    public void afterPropertiesSet() {
        this.ACCOUNT = (String)BasicUtil.evl((Object[])new String[]{this.ACCOUNT, MailConfig.DEFAULT_ACCOUNT});
        if (BasicUtil.isEmpty((Object)this.ACCOUNT)) {
            return;
        }
        DataRow row = new DataRow();
        row.put("ACCOUNT", BasicUtil.evl((Object[])new String[]{this.ACCOUNT, MailConfig.DEFAULT_ACCOUNT}));
        row.put("PASSWORD", BasicUtil.evl((Object[])new String[]{this.PASSWORD, MailConfig.DEFAULT_PASSWORD}));
        row.put("USERNAME", BasicUtil.evl((Object[])new String[]{this.USERNAME, MailConfig.DEFAULT_USERNAME}));
        row.put("PROTOCOL", BasicUtil.evl((Object[])new String[]{this.PROTOCOL, MailConfig.DEFAULT_PROTOCOL}));
        row.put("HOST", BasicUtil.evl((Object[])new String[]{this.HOST, MailConfig.DEFAULT_HOST}));
        row.put("PORT", BasicUtil.evl((Object[])new String[]{this.PORT, MailConfig.DEFAULT_PORT}));
        row.put("ATTACHMENT_DIR", BasicUtil.evl((Object[])new String[]{this.ATTACHMENT_DIR, MailConfig.DEFAULT_ATTACHMENT_DIR}));
        row.put("SSL", (Object)this.SSL);
        row.put("AUTO_DOWNLOAD_ATTACHMENT", (Object)this.AUTO_DOWNLOAD_ATTACHMENT);
        MailConfig.register(row);
    }

    @Bean(value={"anyline.mail.init.mail.util"})
    public MailUtil mailInstance() {
        return MailUtil.getInstance();
    }

    @Bean(value={"anyline.mail.init.pop3.util"})
    public Pop3Util pop3Instance() {
        return Pop3Util.getInstance();
    }
}

