/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mail.util;

import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.anyline.mail.util.MailConfig;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    private MailConfig config = null;
    private Properties props = new Properties();
    private static Hashtable<String, MailUtil> instances = new Hashtable();

    public MailConfig getConfig() {
        return this.config;
    }

    public static Hashtable<String, MailUtil> getInstances() {
        return instances;
    }

    public static MailUtil getInstance() {
        return MailUtil.getInstance("default");
    }

    public static MailUtil getInstance(String key) {
        MailUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            util = new MailUtil();
            MailConfig config = MailConfig.getInstance(key);
            if (null != config) {
                util.config = config;
                util.props.put("username", config.ACCOUNT);
                util.props.put("password", config.PASSWORD);
                util.props.put("mail.transport.protocol", config.PROTOCOL);
                util.props.put("mail.smtp.host", config.HOST);
                util.props.put("mail.smtp.port", config.PORT);
                if (config.SSL) {
                    util.props.setProperty("mail.smtp.auth", "true");
                    util.props.setProperty("mail.smtp.ssl.enable", "true");
                    util.props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    util.props.setProperty("mail.smtp.socketFactory.fallback", "false");
                    util.props.setProperty("mail.smtp.socketFactory.port", config.PORT);
                }
                instances.put(key, util);
            }
        }
        return util;
    }

    public boolean send(String fr, String to, String title, String content) {
        log.warn("[send email][fr:{}][to:{}][title:{}][content:{}]", new Object[]{fr, to, title, content});
        try {
            Session mailSession = Session.getDefaultInstance((Properties)this.props);
            MimeMessage msg = new MimeMessage(mailSession);
            msg.setFrom((Address)new InternetAddress(this.config.ACCOUNT, fr));
            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            msg.setSubject(title);
            msg.setContent((Object)content, "text/html;charset=UTF-8");
            msg.saveChanges();
            Transport transport = mailSession.getTransport("smtp");
            transport.connect(this.config.HOST, this.config.ACCOUNT, this.config.PASSWORD);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean send(String to, String title, String content) {
        return this.send(this.config.USERNAME, to, title, content);
    }

    static {
        Hashtable<String, AnylineConfig> configs = MailConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, MailUtil.getInstance(key));
        }
    }
}

