/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.mail.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.anyline.mail.entity.Mail;
import org.anyline.mail.util.MailConfig;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3Util {
    private static final Logger log = LoggerFactory.getLogger(Pop3Util.class);
    private MailConfig config = null;
    private Properties props = new Properties();
    private static Hashtable<String, Pop3Util> instances = new Hashtable();

    public MailConfig getConfig() {
        return this.config;
    }

    public static Hashtable<String, Pop3Util> getInstances() {
        return instances;
    }

    public static Pop3Util getInstance() {
        return Pop3Util.getInstance("default");
    }

    public static Pop3Util getInstance(String key) {
        Pop3Util util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            util = new Pop3Util();
            MailConfig config = MailConfig.getInstance(key);
            if (null != config) {
                util.config = config;
                util.props.put("username", config.ACCOUNT);
                util.props.put("password", config.PASSWORD);
                util.props.put("mail.store.protocol", config.PROTOCOL);
                util.props.put("mail.pop3.host", config.HOST);
                util.props.put("mail.pop3.port", config.PORT);
                instances.put(key, util);
            }
        }
        return util;
    }

    public boolean send(String fr, String to, String title, String content) {
        log.warn("[send email][fr:{}][to:{}][title:{}][centent:{}]", new Object[]{fr, to, title, content});
        try {
            Session mailSession = Session.getDefaultInstance((Properties)this.props);
            MimeMessage msg = new MimeMessage(mailSession);
            msg.setFrom((Address)new InternetAddress(this.config.ACCOUNT, fr));
            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            msg.setSubject(title);
            msg.setContent((Object)content, "text/html;charset=UTF-8");
            msg.saveChanges();
            Transport transport = mailSession.getTransport("smtp");
            transport.connect(this.config.HOST, this.config.ACCOUNT, this.config.PASSWORD);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMailQty() {
        int qty = -1;
        Session session = Session.getInstance((Properties)this.props);
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore("pop3");
            store.connect(this.config.ACCOUNT, this.config.PASSWORD);
            folder = store.getFolder("INBOX");
            qty = folder.getMessageCount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != folder) {
                    folder.close(true);
                }
            }
            catch (MessagingException messagingException) {}
            try {
                if (null != store) {
                    store.close();
                }
            }
            catch (MessagingException messagingException) {}
        }
        return qty;
    }

    public boolean send(String to, String title, String content) {
        return this.send(this.config.USERNAME, to, title, content);
    }

    public List<Mail> receive(int qty) {
        return this.receive(false, false, qty);
    }

    public List<Mail> receive(boolean read, boolean delete) {
        return this.receive(read, delete, 1, -1);
    }

    public List<Mail> receive(boolean read, boolean delete, int qty) {
        return this.receive(read, delete, 1, qty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Mail> receive(boolean read, boolean delete, int fr, int to) {
        List<Mail> mails = new ArrayList<Mail>();
        Session session = Session.getInstance((Properties)this.props);
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore("pop3");
            store.connect(this.config.ACCOUNT, this.config.PASSWORD);
            folder = store.getFolder("INBOX");
            folder.open(2);
            int cnt = folder.getMessageCount();
            if (to == -1 || to > cnt) {
                to = cnt;
            }
            if (fr == 0) {
                fr = 1;
                ++to;
            }
            if (to > cnt) {
                to = cnt;
            }
            Message[] messages = folder.getMessages(fr, to);
            mails = this.parse(read, delete, messages);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != folder) {
                    folder.close(true);
                }
            }
            catch (MessagingException messagingException) {}
            try {
                if (null != store) {
                    store.close();
                }
            }
            catch (MessagingException messagingException) {}
        }
        return mails;
    }

    public List<Mail> parse(boolean setRead, boolean delete, Message ... messages) {
        ArrayList<Mail> mails = new ArrayList<Mail>();
        try {
            for (Message item : messages) {
                Mail mail = new Mail();
                MimeMessage msg = (MimeMessage)item;
                Date sendTime = msg.getSentDate();
                Date receiveTime = msg.getReceivedDate();
                String subject = msg.getSubject();
                boolean isSeen = Pop3Util.isSeen(msg);
                boolean isContainerAttachment = Pop3Util.isContainAttachment((Part)msg);
                log.info("[\u89e3\u6790\u90ae\u4ef6][subject:{}][\u53d1\u9001\u65f6\u95f4:{}][\u662f\u5426\u5df2\u8bfb:{}][\u662f\u5426\u5305\u542b\u9644\u4ef6:{}]", new Object[]{subject, DateUtil.format((Date)sendTime), isSeen, isContainerAttachment});
                mail.setSubject(subject);
                mail.setSendTime(sendTime);
                mail.setReceiveTime(receiveTime);
                if (this.config.AUTO_DOWNLOAD_ATTACHMENT && isContainerAttachment) {
                    String dir = this.config.ATTACHMENT_DIR.replace("${ymd}", DateUtil.format((Date)sendTime, (String)"yyyyMMdd"));
                    List<File> attachments = Pop3Util.downloadAttachment((Part)msg, dir, sendTime, null);
                    mail.setAttachments(attachments);
                }
                if (!isSeen && setRead) {
                    Pop3Util.seen(new Message[]{msg});
                }
                if (delete) {
                    Pop3Util.delete(new Message[]{msg});
                }
                mails.add(mail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mails;
    }

    public static void delete(Message ... messages) {
        for (Message message : messages) {
            try {
                String subject = message.getSubject();
                message.setFlag(Flags.Flag.DELETED, true);
                log.warn("[\u5220\u9664\u90ae\u4ef6][subject:{}]", (Object)subject);
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void seen(Message ... messages) {
        for (Message message : messages) {
            try {
                String subject = message.getSubject();
                message.setFlag(Flags.Flag.SEEN, true);
                log.warn("[\u6807\u8bb0\u4e3a\u5df2\u8bfb][subject:{}]", (Object)subject);
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSubject(MimeMessage msg) throws UnsupportedEncodingException, MessagingException {
        return MimeUtility.decodeText((String)msg.getSubject());
    }

    public static String getFrom(MimeMessage msg) {
        Object from = "";
        try {
            Address[] froms = msg.getFrom();
            InternetAddress address = (InternetAddress)froms[0];
            Object person = address.getPersonal();
            person = person != null ? MimeUtility.decodeText((String)person) + " " : "";
            from = (String)person + "<" + address.getAddress() + ">";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return from;
    }

    public static boolean isSeen(MimeMessage msg) {
        try {
            return msg.getFlags().contains(Flags.Flag.SEEN);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isContainAttachment(Part part) throws MessagingException, IOException {
        boolean flag = false;
        if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    flag = true;
                } else if (bodyPart.isMimeType("multipart/*")) {
                    flag = Pop3Util.isContainAttachment((Part)bodyPart);
                } else {
                    String contentType = bodyPart.getContentType();
                    if (contentType.indexOf("application") != -1) {
                        flag = true;
                    }
                    if (contentType.indexOf("name") != -1) {
                        flag = true;
                    }
                }
                if (!flag) {
                    continue;
                }
                break;
            }
        } else if (part.isMimeType("message/rfc822")) {
            flag = Pop3Util.isContainAttachment((Part)part.getContent());
        }
        return flag;
    }

    public static List<File> downloadAttachment(Part part, String dir, Date sendTime, List<File> files) throws UnsupportedEncodingException, MessagingException, FileNotFoundException, IOException {
        if (BasicUtil.isEmpty(files)) {
            files = new ArrayList<File>();
        }
        dir = dir.replace("${send_date}", DateUtil.format((Date)sendTime, (String)"yyyyMMdd"));
        dir = dir.replace("${send_time}", DateUtil.format((Date)sendTime, (String)"yyyyMMddhhmmss"));
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                String contentType;
                boolean result = false;
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                String name = Pop3Util.decode(bodyPart.getFileName());
                String path = null;
                path = dir.contains("${file}") ? dir.replace("${file}", name) : FileUtil.merge((String[])new String[]{dir, name});
                File file = new File(path);
                if (BasicUtil.isNotEmpty((Object)name) && disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    result = FileUtil.save((InputStream)bodyPart.getInputStream(), (File)file);
                } else if (bodyPart.isMimeType("multipart/*")) {
                    Pop3Util.downloadAttachment((Part)bodyPart, dir, sendTime, files);
                } else if (BasicUtil.isNotEmpty((Object)name) && ((contentType = bodyPart.getContentType()).indexOf("name") != -1 || contentType.indexOf("application") != -1)) {
                    result = FileUtil.save((InputStream)bodyPart.getInputStream(), (File)file);
                }
                if (!result) continue;
                files.add(file);
            }
        } else if (part.isMimeType("message/rfc822")) {
            Pop3Util.downloadAttachment((Part)part.getContent(), dir, sendTime, files);
        }
        return files;
    }

    public static String decode(String text) throws UnsupportedEncodingException {
        if (text == null || "".equals(text)) {
            return "";
        }
        return MimeUtility.decodeText((String)text);
    }

    static {
        Hashtable<String, AnylineConfig> configs = MailConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, Pop3Util.getInstance(key));
        }
    }
}

