/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.util.Cache;

public abstract class GenericPatternCache
implements PatternCache {
    PatternCompiler _compiler;
    Cache _cache;
    public static final int DEFAULT_CAPACITY = 20;

    GenericPatternCache(Cache cache, PatternCompiler compiler) {
        this._cache = cache;
        this._compiler = compiler;
    }

    @Override
    public final synchronized Pattern addPattern(String expression, int options) throws MalformedPatternException {
        Pattern pattern;
        Object obj = this._cache.getElement(expression);
        if (obj != null && (pattern = (Pattern)obj).getOptions() == options) {
            return pattern;
        }
        pattern = this._compiler.compile(expression, options);
        this._cache.addElement(expression, pattern);
        return pattern;
    }

    @Override
    public final synchronized Pattern addPattern(String expression) throws MalformedPatternException {
        return this.addPattern(expression, 0);
    }

    @Override
    public final synchronized Pattern getPattern(String expression, int options) throws MalformedCachePatternException {
        Pattern result = null;
        try {
            result = this.addPattern(expression, options);
        }
        catch (MalformedPatternException e) {
            throw new MalformedCachePatternException("Invalid expression: " + expression + "\n" + e.toString());
        }
        return result;
    }

    @Override
    public final synchronized Pattern getPattern(String expression) throws MalformedCachePatternException {
        return this.getPattern(expression, 0);
    }

    @Override
    public final int size() {
        return this._cache.size();
    }

    @Override
    public final int capacity() {
        return this._cache.capacity();
    }
}

