/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.pdf.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.DataSet;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFUtil {
    public static String read(File file) {
        String result = null;
        try {
            PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessFile(file, "rw"));
            parser.parse();
            PDDocument doc = parser.getPDDocument();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setSortByPosition(true);
            result = stripper.getText(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) {
        String result = null;
        try {
            PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessBuffer(in));
            parser.parse();
            PDDocument doc = parser.getPDDocument();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setSortByPosition(true);
            result = stripper.getText(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BufferedImage> images(File file) {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        PDDocument doc = null;
        try {
            doc = PDDocument.load((File)file);
            int pages = doc.getNumberOfPages();
            for (int i = 0; i < pages; ++i) {
                PDPage page = doc.getPage(i);
                PDResources resources = page.getResources();
                for (COSName cosName : resources.getXObjectNames()) {
                    PDXObject pdxObject = resources.getXObject(cosName);
                    if (!(pdxObject instanceof PDImageXObject)) continue;
                    BufferedImage image = ((PDImageXObject)pdxObject).getImage();
                    list.add(image);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                doc.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public static List<String> pages() {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    public static DataSet table() {
        DataSet set = new DataSet();
        return set;
    }

    public static List<DataSet> tables() {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        return list;
    }
}

