/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.spider;

import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderClient {
    private Logger log = LoggerFactory.getLogger(SpiderClient.class);
    private static final String JS_ENGINE_NAME = "JavaScript";
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ScriptEngine engine = this.manager.getEngineByName("JavaScript");
    private File home;

    public void script(Charset charset, List<File> files) {
        for (File file : files) {
            if (file.isDirectory()) {
                List items = FileUtil.getAllChildrenFile((File)file, (String[])new String[]{".js"});
                this.script(charset, (List<File>)items);
                continue;
            }
            try {
                this.log.warn("[script][file:{}]", (Object)file.getAbsolutePath());
                BufferedReader reader = Files.newBufferedReader(file.toPath(), charset);
                this.engine.eval(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void script(Charset charset, File ... files) {
        this.script(charset, (List<File>)BeanUtil.array2list((Object[][])new File[][]{files}));
    }

    public void script(Charset charset, String ... files) {
        for (String file : files) {
            File f = null;
            f = null == this.home ? new File(file) : new File(this.home, file);
            this.script(charset, f);
        }
    }

    public void script(File ... files) {
        this.script(Charset.defaultCharset(), files);
    }

    public void script(String ... files) {
        this.script(Charset.defaultCharset(), files);
    }

    public void script(String charset, List<File> files) {
        Charset c = null;
        c = null == charset ? Charset.defaultCharset() : Charset.forName(charset);
        this.script(c, files);
    }

    public void script(String charset, File ... files) {
        this.script(charset, (List<File>)BeanUtil.array2list((Object[][])new File[][]{files}));
    }

    public Object invoke(String function, Object ... params) throws Exception {
        Invocable jsInvoke = (Invocable)((Object)this.engine);
        Object obj = jsInvoke.invokeFunction(function, params);
        return obj;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }
}

