/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.struts.result;

import com.opensymphony.xwork2.ActionInvocation;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONResult
extends StrutsResultSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JSONResult.class);
    private boolean result = true;
    private Object data = null;
    private String message = null;
    private String url = null;
    private String code = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("text/json; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        try {
            this.data = invocation.getStack().findValue("data");
            this.result = BasicUtil.parseBoolean((Object)invocation.getStack().findValue("result"), (Boolean)true);
            this.message = invocation.getStack().findString("msg");
            this.url = invocation.getStack().findString("url");
            this.code = invocation.getStack().findString("code");
            String dataType = null;
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (null == this.data) {
                this.message = (String)BasicUtil.nvl((String[])new String[]{this.message, "\u6ca1\u6709\u8fd4\u56de\u6570\u636e"});
                this.data = false;
            } else if (this.data instanceof Iterable) {
                dataType = "list";
            } else if (this.data instanceof DataSet) {
                DataSet set = (DataSet)this.data;
                this.result = set.isSuccess();
                this.message = (String)BasicUtil.nvl((String[])new String[]{this.message, set.getMessage()});
                dataType = "list";
                this.data = set.getRows();
                map.put("navi", set.getNavi());
            } else if (this.data instanceof DataRow) {
                dataType = "map";
            } else if (this.data instanceof Map) {
                dataType = "map";
            } else if (this.data instanceof String) {
                dataType = "string";
                this.data = this.convertJSONChar(this.data.toString());
            } else if (this.data instanceof Number) {
                dataType = "number";
                this.data = this.convertJSONChar(this.data.toString());
            } else {
                dataType = "map";
            }
            map.put("type", dataType);
            map.put("result", this.result);
            map.put("message", this.message);
            map.put("data", this.data);
            map.put("url", this.url);
            map.put("success", this.result);
            map.put("code", this.code);
            map.put("request_time", request.getParameter("_anyline_request_time"));
            map.put("response_time_fr", request.getAttribute("_anyline_response_time_fr"));
            map.put("response_time_to", System.currentTimeMillis());
            String str = BeanUtil.map2json(map);
            writer.print(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private String convertJSONChar(String value) {
        if (null != value) {
            value = value.replace("\\", "\\\\").replace("\"", "\\\"");
        }
        return value;
    }
}

