/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.cron.pattern.parser.SimpleValueParser;

public class MonthValueParser
extends SimpleValueParser {
    private static final String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public MonthValueParser() {
        super(1, 12);
    }

    @Override
    public int parse(String value) throws CommonException {
        try {
            return super.parse(value);
        }
        catch (Exception e) {
            return this.parseAlias(value);
        }
    }

    private int parseAlias(String value) throws CommonException {
        for (int i = 0; i < ALIASES.length; ++i) {
            if (!ALIASES[i].equalsIgnoreCase(value)) continue;
            return i + 1;
        }
        throw new CommonException("Invalid month alias: {}", value);
    }
}

