/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.UUID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.aliyun.AliyunEmailProperty;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;

public class AliyunEmailProvider
extends AliyunProvider<AliyunEmailProperty, Context> {
    private static final String ALIYUN_DM_API = "dm.aliyuncs.com";

    public AliyunEmailProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(AliyunEmailProperty entity) throws InstrumentException {
        if (StringKit.isEmpty((CharSequence)entity.getContent())) {
            throw new InstrumentException("Email content cannot be empty");
        }
        if (StringKit.isEmpty((CharSequence)entity.getReceive())) {
            throw new InstrumentException("Email address cannot be empty");
        }
        if (StringKit.isEmpty((CharSequence)entity.getSubject())) {
            throw new InstrumentException("Email subject cannot be empty");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SignatureMethod", "HMAC-SHA1");
        params.put("SignatureNonce", UUID.randomUUID().toString());
        params.put("AccessKeyId", this.properties.getAppKey());
        params.put("SignatureVersion", "1.0");
        params.put("Timestamp", df.format(new Date()));
        params.put("Format", "JSON");
        params.put("Action", "SingleSendMail");
        params.put("Version", "2015-11-23");
        params.put("RegionId", "cn-hangzhou");
        params.put("Subject", entity.getSubject());
        params.put("FromAlias", entity.getSender());
        params.put("ToAddress", entity.getReceive());
        if (Property.Type.HTML.equals((Object)entity.getType())) {
            params.put("HtmlBody", entity.getContent());
        } else if (Property.Type.TEXT.equals((Object)entity.getType())) {
            params.put("TextBody", entity.getContent());
        }
        params.put("ReplyAddress", entity.getSender());
        params.put("ReplyToAddress", entity.getSender());
        params.put("ReplyAddressAlias", entity.getSender());
        params.put("ClickTrace", this.getSign(params));
        params.put("Signature", this.getSign(params));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String val : params.keySet()) {
            map.put(this.specialUrlEncode(val), this.specialUrlEncode((String)params.get(val)));
        }
        return this.checkResponse(Httpx.get((String)"https://dm.aliyuncs.com", map));
    }
}

