/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.filter;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.activemq.apollo.filter.FilterException;
import org.apache.activemq.apollo.filter.Filterable;
import org.apache.activemq.apollo.filter.XPathExpression;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XalanXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private final String xpath;

    public XalanXPathEvaluator(String xpath) {
        this.xpath = xpath;
    }

    public boolean evaluate(Filterable m) throws FilterException {
        String stringBody = m.getBodyAs(String.class);
        if (stringBody != null) {
            return this.evaluate(stringBody);
        }
        Buffer bufferBody = m.getBodyAs(Buffer.class);
        if (bufferBody != null) {
            return this.evaluate(bufferBody);
        }
        return false;
    }

    private boolean evaluate(Buffer data) {
        try {
            InputSource inputSource = new InputSource((InputStream)new BufferInputStream(data));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            Document doc = dbuilder.parse(inputSource);
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            XObject result = cachedXPathAPI.eval((Node)doc, this.xpath);
            if (result.bool()) {
                return true;
            }
            NodeIterator iterator = cachedXPathAPI.selectNodeIterator((Node)doc, this.xpath);
            return iterator.nextNode() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean evaluate(String text) {
        try {
            InputSource inputSource = new InputSource(new StringReader(text));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            Document doc = dbuilder.parse(inputSource);
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            XObject result = cachedXPathAPI.eval((Node)doc, this.xpath);
            if (result.bool()) {
                return true;
            }
            NodeIterator iterator = cachedXPathAPI.selectNodeIterator((Node)doc, this.xpath);
            return iterator.nextNode() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

