/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs.annotation.processor;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.activemq.artemis.logs.annotation.GetLogger;
import org.apache.activemq.artemis.logs.annotation.LogBundle;
import org.apache.activemq.artemis.logs.annotation.LogMessage;
import org.apache.activemq.artemis.logs.annotation.Message;

@SupportedAnnotationTypes(value={"org.apache.activemq.artemis.logs.annotation.LogBundle"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class LogAnnotationProcessor
extends AbstractProcessor {
    private static final boolean DEBUG;

    protected static void debug(String debugMessage) {
        if (DEBUG) {
            System.out.println(debugMessage);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<Integer, String> messages = new HashMap<Integer, String>();
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    TypeElement annotatedType = (TypeElement)element;
                    LogBundle bundleAnnotation = annotatedType.getAnnotation(LogBundle.class);
                    String fullClassName = annotatedType.getQualifiedName() + "_impl";
                    String interfaceName = annotatedType.getSimpleName().toString();
                    String simpleClassName = interfaceName + "_impl";
                    JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(fullClassName, new Element[0]);
                    if (DEBUG) {
                        LogAnnotationProcessor.debug("");
                        LogAnnotationProcessor.debug("*******************************************************************************************************************************");
                        LogAnnotationProcessor.debug("processing " + fullClassName + ", generating: " + fileObject.getName());
                    }
                    PrintWriter writerOutput = new PrintWriter(fileObject.openWriter());
                    writerOutput.println("/** This class is auto generated by " + LogAnnotationProcessor.class.getCanonicalName());
                    writerOutput.println("    and it inherits whatever license is declared at " + annotatedType + " */");
                    writerOutput.println();
                    writerOutput.println("package " + annotatedType.getEnclosingElement() + ";");
                    writerOutput.println();
                    writerOutput.println("import org.slf4j.Logger;");
                    writerOutput.println("import org.slf4j.LoggerFactory;");
                    writerOutput.println("import org.slf4j.helpers.FormattingTuple;");
                    writerOutput.println("import org.slf4j.helpers.MessageFormatter;");
                    writerOutput.println();
                    writerOutput.println("// " + bundleAnnotation.toString());
                    writerOutput.println("public class " + simpleClassName + " implements " + interfaceName);
                    writerOutput.println("{");
                    writerOutput.println("   private final Logger logger;");
                    writerOutput.println();
                    writerOutput.println("   private static void _copyStackTraceMinusOne(final Throwable e) {");
                    writerOutput.println("      final StackTraceElement[] st = e.getStackTrace();");
                    writerOutput.println("      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));");
                    writerOutput.println("   }");
                    writerOutput.println();
                    writerOutput.println("   public " + simpleClassName + "(Logger logger ) {");
                    writerOutput.println("      this.logger = logger;");
                    writerOutput.println("   }");
                    writerOutput.println();
                    for (Element element2 : annotatedType.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.METHOD) continue;
                        ExecutableElement executableMember = (ExecutableElement)element2;
                        Message messageAnnotation = element2.getAnnotation(Message.class);
                        LogMessage logAnnotation = element2.getAnnotation(LogMessage.class);
                        GetLogger getLogger = element2.getAnnotation(GetLogger.class);
                        if (DEBUG) {
                            LogAnnotationProcessor.debug("Generating " + executableMember);
                        }
                        int generatedPaths = 0;
                        if (messageAnnotation != null) {
                            this.validateRegexID(bundleAnnotation, messageAnnotation.id());
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + messageAnnotation);
                            }
                            LogAnnotationProcessor.generateMessage(bundleAnnotation, writerOutput, executableMember, messageAnnotation, messages);
                        }
                        if (logAnnotation != null) {
                            this.validateRegexID(bundleAnnotation, logAnnotation.id());
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + logAnnotation);
                            }
                            LogAnnotationProcessor.generateLogger(bundleAnnotation, writerOutput, executableMember, logAnnotation, messages);
                        }
                        if (getLogger != null) {
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + getLogger);
                            }
                            LogAnnotationProcessor.generateGetLogger(bundleAnnotation, writerOutput, executableMember, getLogger);
                        }
                        if (generatedPaths <= 1) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot use combined annotations  on " + executableMember);
                        return false;
                    }
                    writerOutput.println("}");
                    writerOutput.close();
                    if (!DEBUG) continue;
                    LogAnnotationProcessor.debug("done processing " + fullClassName);
                    LogAnnotationProcessor.debug("*******************************************************************************************************************************");
                    LogAnnotationProcessor.debug("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    void validateRegexID(LogBundle bundleAnnotation, long id) {
        String toStringID;
        if (bundleAnnotation.regexID() != null && !bundleAnnotation.regexID().isEmpty() && !(toStringID = Long.toString(id)).matches(bundleAnnotation.regexID())) {
            throw new IllegalArgumentException("Code " + id + " does not match regular expression " + bundleAnnotation.regexID() + " specified on the LogBundle");
        }
    }

    private static void generateMessage(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, Message messageAnnotation, HashMap<Integer, String> processedMessages) {
        LogAnnotationProcessor.verifyIdNotProcessedPreviously(messageAnnotation.id(), messageAnnotation.value(), processedMessages);
        LogAnnotationProcessor.verifyMessagePlaceholders(messageAnnotation.value(), executableMember);
        processedMessages.put(messageAnnotation.id(), messageAnnotation.value());
        writerOutput.println("   // " + LogAnnotationProcessor.encodeSpecialChars(messageAnnotation.toString()));
        writerOutput.println("   @Override");
        writerOutput.write("   public " + executableMember.getReturnType() + " " + executableMember.getSimpleName() + "(");
        Iterator<? extends VariableElement> parameters = executableMember.getParameters().iterator();
        boolean hasParameters = false;
        VariableElement exceptionParameter = null;
        StringBuffer callList = new StringBuffer();
        while (parameters.hasNext()) {
            hasParameters = true;
            VariableElement parameter = parameters.next();
            boolean isException = LogAnnotationProcessor.verifyIfExceptionArgument(executableMember, parameter, parameters.hasNext(), exceptionParameter != null);
            if (isException) {
                exceptionParameter = parameter;
            }
            writerOutput.write(parameter.asType() + " " + parameter.getSimpleName());
            callList.append(parameter.getSimpleName());
            if (!parameters.hasNext()) continue;
            writerOutput.write(", ");
            callList.append(", ");
        }
        writerOutput.println(") {");
        String formattingString = LogAnnotationProcessor.encodeSpecialChars(bundleAnnotation.projectCode() + messageAnnotation.id() + ": " + messageAnnotation.value());
        if (!hasParameters) {
            writerOutput.println("      String returnString = \"" + formattingString + "\";");
        } else {
            writerOutput.println("      String returnString = MessageFormatter.arrayFormat(\"" + formattingString + "\", new Object[]{" + callList + "}).getMessage();");
        }
        if (executableMember.getReturnType().toString().equals(String.class.getName())) {
            writerOutput.println("      return returnString;");
        } else {
            writerOutput.println();
            writerOutput.println("      {");
            String exceptionVariableName = "objReturn_" + executableMember.getSimpleName();
            writerOutput.println("         " + executableMember.getReturnType().toString() + " " + exceptionVariableName + " = new " + executableMember.getReturnType().toString() + "(returnString);");
            if (exceptionParameter != null) {
                writerOutput.println("         " + exceptionVariableName + ".initCause(" + exceptionParameter.getSimpleName() + ");");
            }
            writerOutput.println("         _copyStackTraceMinusOne(" + exceptionVariableName + ");");
            writerOutput.println("         return " + exceptionVariableName + ";");
            writerOutput.println("      }");
        }
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static boolean isException(TypeMirror parameterType, VariableElement methodParameter) {
        DeclaredType declaredType;
        String parameterClazz;
        if (parameterType == null) {
            return false;
        }
        if (DEBUG && methodParameter != null) {
            LogAnnotationProcessor.debug("... checking if parameter \"" + parameterType + " " + methodParameter + "\" is an exception");
        }
        if ((parameterClazz = parameterType.toString()).equals("java.lang.Throwable") || parameterClazz.endsWith("Exception")) {
            if (DEBUG) {
                LogAnnotationProcessor.debug("... Class " + parameterClazz + " was considered an exception");
            }
            return true;
        }
        switch (parameterClazz) {
            case "java.lang.String": 
            case "java.lang.Object": 
            case "java.lang.Long": 
            case "java.lang.Integer": 
            case "java.lang.Number": 
            case "java.lang.Thread": 
            case "java.lang.ThreadGroup": 
            case "org.apache.activemq.artemis.api.core.SimpleString": 
            case "none": {
                if (DEBUG) {
                    LogAnnotationProcessor.debug("... " + parameterClazz + " is a known type, not an exception!");
                }
                return false;
            }
        }
        if (parameterType instanceof DeclaredType && (declaredType = (DeclaredType)parameterType).asElement() instanceof TypeElement) {
            TypeElement theElement = (TypeElement)declaredType.asElement();
            if (DEBUG) {
                LogAnnotationProcessor.debug("... ... recursively inspecting super class for Exception on " + parameterClazz + ", looking at superClass " + theElement.getSuperclass());
            }
            return LogAnnotationProcessor.isException(theElement.getSuperclass(), null);
        }
        return false;
    }

    private static String encodeSpecialChars(String input) {
        return input.replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"");
    }

    private static void generateGetLogger(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, GetLogger loggerAnnotation) {
        writerOutput.println("   // " + loggerAnnotation.toString());
        writerOutput.println("   @Override");
        writerOutput.println("   public Logger " + executableMember.getSimpleName() + "() {");
        writerOutput.println("      return logger;");
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static void generateLogger(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, LogMessage messageAnnotation, HashMap<Integer, String> processedMessages) {
        LogAnnotationProcessor.verifyIdNotProcessedPreviously(messageAnnotation.id(), messageAnnotation.value(), processedMessages);
        LogAnnotationProcessor.verifyMessagePlaceholders(messageAnnotation.value(), executableMember);
        processedMessages.put(messageAnnotation.id(), messageAnnotation.value());
        writerOutput.println("   // " + LogAnnotationProcessor.encodeSpecialChars(messageAnnotation.toString()));
        writerOutput.println("   @Override");
        writerOutput.write("   public void " + executableMember.getSimpleName() + "(");
        List<? extends VariableElement> parametersList = executableMember.getParameters();
        boolean hasParameters = false;
        VariableElement exceptionParameter = null;
        Iterator<? extends VariableElement> parameters = parametersList.iterator();
        while (parameters.hasNext()) {
            hasParameters = true;
            VariableElement parameter = parameters.next();
            boolean isException = LogAnnotationProcessor.verifyIfExceptionArgument(executableMember, parameter, parameters.hasNext(), exceptionParameter != null);
            if (isException) {
                exceptionParameter = parameter;
            }
            writerOutput.write(parameter.asType() + " " + parameter.getSimpleName());
            if (!parameters.hasNext()) continue;
            writerOutput.write(", ");
        }
        writerOutput.println(") {");
        StringBuffer callList = null;
        if (hasParameters) {
            callList = new StringBuffer();
            parameters = parametersList.iterator();
            while (parameters.hasNext()) {
                VariableElement parameter = parameters.next();
                callList.append(parameter.getSimpleName());
                if (!parameters.hasNext()) continue;
                callList.append(", ");
            }
        }
        String isEnabledMethodName = LogAnnotationProcessor.getLoggerIsEnabledMethodName(messageAnnotation);
        String methodName = LogAnnotationProcessor.getLoggerOutputMethodName(messageAnnotation);
        String formattingString = LogAnnotationProcessor.encodeSpecialChars(bundleAnnotation.projectCode() + messageAnnotation.id() + ": " + messageAnnotation.value());
        writerOutput.println("      if (logger." + isEnabledMethodName + "()) {");
        if (hasParameters) {
            writerOutput.println("         logger." + methodName + "(\"" + formattingString + "\", " + callList + ");");
        } else {
            writerOutput.println("         logger." + methodName + "(\"" + formattingString + "\");");
        }
        writerOutput.println("      }");
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static String getLoggerOutputMethodName(LogMessage messageAnnotation) {
        switch (messageAnnotation.level()) {
            case WARN: {
                return "warn";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
            case DEBUG: {
                return "debug";
            }
            case TRACE: {
                return "trace";
            }
        }
        throw new IllegalStateException("Illegal log level: " + messageAnnotation.level());
    }

    private static String getLoggerIsEnabledMethodName(LogMessage messageAnnotation) {
        switch (messageAnnotation.level()) {
            case WARN: {
                return "isWarnEnabled";
            }
            case INFO: {
                return "isInfoEnabled";
            }
            case ERROR: {
                return "isErrorEnabled";
            }
            case DEBUG: {
                return "isDebugEnabled";
            }
            case TRACE: {
                return "isTraceEnabled";
            }
        }
        throw new IllegalStateException("Illegal log level: " + messageAnnotation.level());
    }

    private static void tupples(String arg, char open, char close, Consumer<String> stringConsumer) {
        int openAt = -1;
        for (int i = 0; i < arg.length(); ++i) {
            char charAt = arg.charAt(i);
            if (charAt == open) {
                openAt = i;
                continue;
            }
            if (charAt != close) continue;
            if (openAt >= 0) {
                stringConsumer.accept(arg.substring(openAt + 1, i));
            }
            openAt = -1;
        }
    }

    private static void verifyMessagePlaceholders(String message, ExecutableElement holder) {
        Objects.requireNonNull(message, "message must not be null");
        LogAnnotationProcessor.tupples(message, '{', '}', tupple -> {
            if (!tupple.equals("")) {
                throw new IllegalArgumentException("Invalid placeholder argument {" + tupple + "} on message '" + message + "' as part of " + holder + "\nreplace it by {}");
            }
        });
        if (message.contains("%s") || message.contains("%d")) {
            throw new IllegalArgumentException("Cannot use %s or %d in loggers. Please use {} on message '" + message + "'");
        }
    }

    private static void verifyIdNotProcessedPreviously(Integer id, String message, HashMap<Integer, String> processedMessages) {
        Objects.requireNonNull(id, "id must not be null");
        if (processedMessages.containsKey(id)) {
            String previousMessage = processedMessages.get(id);
            throw new IllegalStateException("message " + id + " with definition = " + message + " was previously defined as " + previousMessage);
        }
    }

    private static boolean verifyIfExceptionArgument(ExecutableElement executableMember, VariableElement parameter, boolean hasMoreParams, boolean hasExistingException) {
        boolean isException = LogAnnotationProcessor.isException(parameter.asType(), parameter);
        if (DEBUG) {
            LogAnnotationProcessor.debug("Parameter " + parameter + (isException ? "is" : "is not") + " an exception");
        }
        if (isException) {
            if (hasMoreParams) {
                throw new IllegalArgumentException("Exception argument " + parameter + " has to be the last argument on the list. Look at: " + executableMember);
            }
            if (hasExistingException) {
                throw new IllegalStateException("You can only have one exception argument defined per message/annotation, Look at: " + executableMember);
            }
        }
        return isException;
    }

    static {
        boolean debugResult = false;
        try {
            String debugEnvVariable = System.getenv("ARTEMIS_LOG_ANNOTATION_PROCESSOR_DEBUG");
            if (debugEnvVariable != null) {
                debugResult = Boolean.parseBoolean(debugEnvVariable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEBUG = debugResult;
    }
}

