/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import org.apache.activemq.artemis.core.server.MessageReference;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface MQTTLogger
extends BasicLogger {
    public static final MQTTLogger LOGGER = (MQTTLogger)Logger.getMessageLogger(MQTTLogger.class, (String)MQTTLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=832000, value="Unable to send message: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToSendMessage(MessageReference var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=832001, value="MQTT client({0}) attempted to ack already ack'd message: ", format=Message.Format.MESSAGE_FORMAT)
    public void failedToAckMessage(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834000, value="Error removing subscription.", format=Message.Format.MESSAGE_FORMAT)
    public void errorRemovingSubscription(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834001, value="Error disconnecting client.", format=Message.Format.MESSAGE_FORMAT)
    public void errorDisconnectingClient(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834002, value="Error processing control packet: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorProcessingControlPacket(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834003, value="Error sending will message.", format=Message.Format.MESSAGE_FORMAT)
    public void errorSendingWillMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834004, value="Error disconnecting consumer.", format=Message.Format.MESSAGE_FORMAT)
    public void errorDisconnectingConsumer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834005, value="Failed to cast property {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCastProperty(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=834006, value="Failed to publish MQTT message: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToPublishMqttMessage(String var1, @Cause Throwable var2);
}

