/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.UUID;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnectionManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTPublishManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTRetainMessageManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionCallback;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSubscriptionManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTVersion;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.jboss.logging.Logger;

public class MQTTSession {
    private static final Logger logger = Logger.getLogger(MQTTSession.class);
    private final String id = UUID.randomUUID().toString();
    private MQTTProtocolHandler protocolHandler;
    private MQTTSubscriptionManager subscriptionManager;
    private MQTTSessionCallback sessionCallback;
    private ServerSessionImpl serverSession;
    private ServerSessionImpl internalServerSession;
    private MQTTPublishManager mqttPublishManager;
    private MQTTConnectionManager mqttConnectionManager;
    private MQTTRetainMessageManager retainMessageManager;
    private MQTTConnection connection;
    protected MQTTSessionState state;
    private boolean stopped = false;
    private MQTTProtocolManager protocolManager;
    private boolean clean;
    private WildcardConfiguration wildcardConfiguration;
    private CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();
    private MQTTVersion version = null;
    private boolean usingServerKeepAlive = false;

    public MQTTSession(MQTTProtocolHandler protocolHandler, MQTTConnection connection, MQTTProtocolManager protocolManager, WildcardConfiguration wildcardConfiguration) throws Exception {
        this.protocolHandler = protocolHandler;
        this.protocolManager = protocolManager;
        this.wildcardConfiguration = wildcardConfiguration;
        this.connection = connection;
        this.mqttConnectionManager = new MQTTConnectionManager(this);
        this.mqttPublishManager = new MQTTPublishManager(this, protocolManager.isCloseMqttConnectionOnPublishAuthorizationFailure());
        this.sessionCallback = new MQTTSessionCallback(this, connection);
        this.subscriptionManager = new MQTTSubscriptionManager(this);
        this.retainMessageManager = new MQTTRetainMessageManager(this);
        this.state = MQTTSessionState.DEFAULT;
        logger.debugf("MQTT session created: %s", (Object)this.id);
    }

    synchronized void start() throws Exception {
        this.mqttPublishManager.start();
        this.subscriptionManager.start();
        this.stopped = false;
    }

    synchronized void stop(boolean failure) throws Exception {
        this.state.setFailed(failure);
        if (!this.stopped) {
            this.protocolHandler.stop();
            this.subscriptionManager.stop();
            this.mqttPublishManager.stop();
            if (this.serverSession != null) {
                this.serverSession.stop();
                this.serverSession.close(false);
            }
            if (this.internalServerSession != null) {
                this.internalServerSession.stop();
                this.internalServerSession.close(false);
            }
            if (this.state != null) {
                this.state.setAttached(false);
                this.state.setDisconnectedTime(System.currentTimeMillis());
                this.state.clearTopicAliases();
            }
            if (this.getVersion() == MQTTVersion.MQTT_5) {
                if (this.state.getClientSessionExpiryInterval() == 0) {
                    if (this.state.isWill() && failure) {
                        this.sendWillMessage();
                    }
                    this.clean();
                    this.protocolManager.removeSessionState(this.connection.getClientID());
                } else {
                    this.state.setDisconnectedTime(System.currentTimeMillis());
                }
            } else {
                if (this.state.isWill() && failure) {
                    this.sendWillMessage();
                }
                if (this.isClean()) {
                    this.clean();
                    this.protocolManager.removeSessionState(this.connection.getClientID());
                }
            }
        }
        this.stopped = true;
    }

    boolean getStopped() {
        return this.stopped;
    }

    boolean isClean() {
        return this.clean;
    }

    void setClean(boolean clean) {
        this.clean = clean;
    }

    MQTTPublishManager getMqttPublishManager() {
        return this.mqttPublishManager;
    }

    MQTTSessionState getState() {
        return this.state;
    }

    MQTTConnectionManager getConnectionManager() {
        return this.mqttConnectionManager;
    }

    ServerSessionImpl getServerSession() {
        return this.serverSession;
    }

    ServerSessionImpl getInternalServerSession() {
        return this.internalServerSession;
    }

    ActiveMQServer getServer() {
        return this.protocolHandler.getServer();
    }

    MQTTSubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    MQTTProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    SessionCallback getSessionCallback() {
        return this.sessionCallback;
    }

    void setServerSession(ServerSessionImpl serverSession, ServerSessionImpl internalServerSession) {
        this.serverSession = serverSession;
        this.internalServerSession = internalServerSession;
    }

    void setSessionState(MQTTSessionState state) {
        this.state = state;
        this.state.setAttached(true);
        this.state.setDisconnectedTime(0L);
        this.state.setSession(this);
    }

    MQTTRetainMessageManager getRetainMessageManager() {
        return this.retainMessageManager;
    }

    MQTTConnection getConnection() {
        return this.connection;
    }

    MQTTProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    void clean() throws Exception {
        this.subscriptionManager.clean();
        this.mqttPublishManager.clean();
        this.state.clear();
    }

    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    public void setWildcardConfiguration(WildcardConfiguration wildcardConfiguration) {
        this.wildcardConfiguration = wildcardConfiguration;
    }

    public CoreMessageObjectPools getCoreMessageObjectPools() {
        return this.coreMessageObjectPools;
    }

    public void setVersion(MQTTVersion version) {
        this.version = version;
    }

    public MQTTVersion getVersion() {
        return this.version;
    }

    public boolean isUsingServerKeepAlive() {
        return this.usingServerKeepAlive;
    }

    public void setUsingServerKeepAlive(boolean usingServerKeepAlive) {
        this.usingServerKeepAlive = usingServerKeepAlive;
    }

    public void sendWillMessage() {
        try {
            MqttProperties properties;
            if (this.state.getWillUserProperties() == null) {
                properties = MqttProperties.NO_PROPERTIES;
            } else {
                properties = new MqttProperties();
                for (MqttProperties.MqttProperty mqttProperty : this.state.getWillUserProperties()) {
                    properties.add(mqttProperty);
                }
            }
            MqttPublishMessage publishMessage = MqttMessageBuilders.publish().messageId(0).qos(MqttQoS.valueOf((int)this.state.getWillQoSLevel())).retained(this.state.isWillRetain()).topicName(this.state.getWillTopic()).payload((ByteBuf)(this.state.getWillMessage() == null ? new EmptyByteBuf((ByteBufAllocator)PooledByteBufAllocator.DEFAULT) : this.state.getWillMessage())).properties(properties).build();
            logger.debugf("%s sending will message: %s", (Object)this, (Object)publishMessage);
            this.getMqttPublishManager().sendToQueue(publishMessage, true);
            this.state.setWillSent(true);
            this.state.setWillMessage(null);
        }
        catch (Exception e) {
            MQTTLogger.LOGGER.errorSendingWillMessage(e);
        }
    }

    public String toString() {
        return "MQTTSession[coreSessionId: " + (this.serverSession != null ? this.serverSession.getName() : "null") + "]";
    }
}

