/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven.xsd2java;

import java.io.File;
import java.util.Map;
import org.apache.axis2.maven.shared.NamespaceMapping;
import org.apache.axis2.maven.shared.NamespaceMappingUtil;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.xml.sax.InputSource;

public abstract class AbstractXSD2JavaMojo
extends AbstractMojo {
    private MavenProject project;
    private File[] xsdFiles;
    private NamespaceMapping[] namespaceMappings;
    private String noNamespacePackageName;
    private String mapperClassPackage;
    private boolean helperMode;
    private String packageName;
    private boolean ignoreUnexpected;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outputDirectory = this.getOutputDirectory();
        outputDirectory.mkdirs();
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setOutputLocation(outputDirectory);
        compilerOptions.setGenerateAll(true);
        NamespaceMappingUtil.addToMap((NamespaceMapping[])this.namespaceMappings, (Map)compilerOptions.getNs2PackageMap());
        if (this.noNamespacePackageName != null) {
            compilerOptions.getNs2PackageMap().put("", this.noNamespacePackageName);
        }
        compilerOptions.setMapperClassPackage(this.mapperClassPackage);
        compilerOptions.setHelperMode(this.helperMode);
        if (this.packageName != null) {
            compilerOptions.setPackageName(this.packageName);
        }
        compilerOptions.setIgnoreUnexpected(this.ignoreUnexpected);
        compilerOptions.setWriteOutput(true);
        try {
            for (File xsdFile : this.xsdFiles) {
                XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
                SchemaCompiler compiler = new SchemaCompiler(compilerOptions);
                compiler.compile(schemaCollection.read(new InputSource(xsdFile.toURI().toString())));
            }
        }
        catch (SchemaCompilationException ex) {
            throw new MojoExecutionException("An error occurred during 'xsd2java' processing: " + ex.getMessage(), (Exception)((Object)ex));
        }
        this.addSourceRoot(this.project);
    }

    protected abstract File getOutputDirectory();

    protected abstract void addSourceRoot(MavenProject var1);
}

