/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.OSGiServiceBuilder;

public class OSGiServiceGroupBuilder
extends ServiceGroupBuilder {
    private OMElement serviceElement;
    private Map wsdlServices;

    public OSGiServiceGroupBuilder(OMElement serviceElement, HashMap wsdlServices, ConfigurationContext configCtx) {
        super(serviceElement, wsdlServices, configCtx);
        this.serviceElement = serviceElement;
        this.wsdlServices = wsdlServices;
    }

    public ArrayList populateServiceGroup(AxisServiceGroup axisServiceGroup) throws DeploymentException {
        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
        try {
            Iterator itr = this.serviceElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, axisServiceGroup, axisServiceGroup.getParent());
            Iterator moduleConfigs = this.serviceElement.getChildrenWithName(new QName("moduleConfig"));
            this.processServiceModuleConfig(moduleConfigs, axisServiceGroup.getParent(), axisServiceGroup);
            Iterator moduleRefs = this.serviceElement.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleRefs, axisServiceGroup);
            Iterator serviceitr = this.serviceElement.getChildrenWithName(new QName("service"));
            while (serviceitr.hasNext()) {
                OMElement service = (OMElement)serviceitr.next();
                OMAttribute serviceNameatt = service.getAttribute(new QName("name"));
                if (serviceNameatt == null) {
                    throw new DeploymentException(Messages.getMessage("servicenameeror"));
                }
                String serviceName = serviceNameatt.getAttributeValue();
                if (serviceName == null || "".equals(serviceName)) {
                    throw new DeploymentException(Messages.getMessage("servicenameeror"));
                }
                AxisService axisService = (AxisService)this.wsdlServices.get(serviceName);
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                } else {
                    axisService.setWsdlFound(true);
                    axisService.setCustomWsdl(true);
                }
                axisService.setParent(axisServiceGroup);
                axisService.setClassLoader(axisServiceGroup.getServiceGroupClassLoader());
                OSGiServiceBuilder serviceBuilder = new OSGiServiceBuilder(this.configCtx, axisService);
                AxisService as = serviceBuilder.populateService(service);
                serviceList.add(as);
            }
        }
        catch (AxisFault e) {
            throw new DeploymentException(e);
        }
        return serviceList;
    }

    protected void processModuleRefs(Iterator moduleRefs, AxisServiceGroup axisServiceGroup) throws DeploymentException {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            if (moduleRefAttribute == null) continue;
            String refName = moduleRefAttribute.getAttributeValue();
            if (this.axisConfig.getModule(refName) == null) {
                throw new DeploymentException(OSGiAxis2Constants.MODULE_NOT_FOUND_ERROR + refName);
            }
            axisServiceGroup.addModuleref(refName);
        }
    }
}

