/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.HTTPAuthenticator;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPSender;
import org.apache.axis2.transport.http.impl.httpclient4.AxisRequestEntityImpl;
import org.apache.axis2.transport.http.impl.httpclient4.HTTPProxyConfigurator;
import org.apache.axis2.transport.http.impl.httpclient4.HTTPTransportHeaders;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.params.AuthPolicy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HTTPSenderImpl
extends HTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSenderImpl.class);

    protected void sendViaGet(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        HttpGet httpGet = new HttpGet();
        AbstractHttpClient httpClient = this.getHttpClient(msgContext);
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpRequestBase)httpGet, httpClient, soapActionString);
        String soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString);
        if (soapAction != null && !msgContext.isDoingREST()) {
            httpGet.setHeader("SOAPAction", soapAction);
        }
        HttpResponse response = null;
        try {
            response = this.executeMethod(httpClient, msgContext, url, (HttpRequestBase)httpGet);
            this.handleResponse(msgContext, response);
            this.cleanup(msgContext, response);
        }
        catch (IOException e) {
            try {
                log.info((Object)("Unable to sendViaGet to url[" + url + "]"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            catch (Throwable throwable) {
                this.cleanup(msgContext, response);
                throw throwable;
            }
        }
    }

    protected void cleanup(MessageContext msgContext, Object httpResponse) {
        if (!(httpResponse instanceof HttpResponse)) {
            log.trace((Object)("HttpResponse expected, but found - " + httpResponse));
            return;
        }
        HttpResponse response = (HttpResponse)httpResponse;
        if (msgContext.isPropertyTrue("CleanupResponse")) {
            log.trace((Object)("Cleaning response : " + response));
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (IOException e) {
                    log.error((Object)("Error while cleaning response : " + response), (Throwable)e);
                }
            }
        }
    }

    protected void sendViaDelete(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        HttpDelete deleteMethod = new HttpDelete();
        AbstractHttpClient httpClient = this.getHttpClient(msgContext);
        this.populateCommonProperties(msgContext, url, (HttpRequestBase)deleteMethod, httpClient, soapActionString);
        HttpResponse response = null;
        try {
            response = this.executeMethod(httpClient, msgContext, url, (HttpRequestBase)deleteMethod);
            this.handleResponse(msgContext, response);
            this.cleanup(msgContext, response);
        }
        catch (IOException e) {
            try {
                log.info((Object)("Unable to sendViaDelete to url[" + url + "]"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            catch (Throwable throwable) {
                this.cleanup(msgContext, response);
                throw throwable;
            }
        }
    }

    protected void sendViaPost(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        AbstractHttpClient httpClient = this.getHttpClient(msgContext);
        HttpPost postMethod = new HttpPost();
        if (log.isTraceEnabled()) {
            log.trace((Object)(Thread.currentThread() + " PostMethod " + postMethod + " / " + httpClient));
        }
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpRequestBase)postMethod, httpClient, soapActionString);
        AxisRequestEntityImpl requestEntity = new AxisRequestEntityImpl(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry);
        postMethod.setEntity((HttpEntity)requestEntity);
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            requestEntity.setChunked(this.chunked);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null && !msgContext.isDoingREST()) {
            postMethod.setHeader("SOAPAction", soapAction);
        }
        HttpResponse response = null;
        try {
            response = this.executeMethod(httpClient, msgContext, url, (HttpRequestBase)postMethod);
            this.handleResponse(msgContext, response);
            this.cleanup(msgContext, response);
        }
        catch (IOException e) {
            try {
                log.info((Object)("Unable to sendViaPost to url[" + url + "]"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            catch (Throwable throwable) {
                this.cleanup(msgContext, response);
                throw throwable;
            }
        }
    }

    protected void sendViaPut(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        AbstractHttpClient httpClient = this.getHttpClient(msgContext);
        HttpPut putMethod = new HttpPut();
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, (HttpRequestBase)putMethod, httpClient, soapActionString);
        AxisRequestEntityImpl requestEntity = new AxisRequestEntityImpl(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry);
        putMethod.setEntity((HttpEntity)requestEntity);
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            requestEntity.setChunked(this.chunked);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null && !msgContext.isDoingREST()) {
            putMethod.setHeader("SOAPAction", soapAction);
        }
        HttpResponse response = null;
        try {
            response = this.executeMethod(httpClient, msgContext, url, (HttpRequestBase)putMethod);
            this.handleResponse(msgContext, response);
            this.cleanup(msgContext, response);
        }
        catch (IOException e) {
            try {
                log.info((Object)("Unable to sendViaPut to url[" + url + "]"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            catch (Throwable throwable) {
                this.cleanup(msgContext, response);
                throw throwable;
            }
        }
    }

    protected void handleResponse(MessageContext msgContext, Object httpResponse) throws IOException {
        if (!(httpResponse instanceof HttpResponse)) {
            log.trace((Object)("HttpResponse expected, but found - " + httpResponse));
            return;
        }
        HttpResponse response = (HttpResponse)httpResponse;
        int statusCode = response.getStatusLine().getStatusCode();
        HTTPSender.HTTPStatusCodeFamily family = this.getHTTPStatusCodeFamily(statusCode);
        log.trace((Object)("Handling response - " + statusCode));
        if (statusCode == 202) {
            msgContext.setProperty("CleanupResponse", Boolean.TRUE);
            this.obtainHTTPHeaderInformation(response, msgContext);
        } else if (HTTPSender.HTTPStatusCodeFamily.SUCCESSFUL.equals((Object)family)) {
            msgContext.setProperty("CleanupResponse", Boolean.FALSE);
            this.processResponse(response, msgContext);
        } else if (statusCode == 500 || statusCode == 400) {
            MessageContext inMessageContext;
            OperationContext opContext;
            msgContext.setProperty("CleanupResponse", Boolean.TRUE);
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            String value = null;
            if (contentTypeHeader != null) {
                value = contentTypeHeader.getValue();
            }
            if ((opContext = msgContext.getOperationContext()) != null && (inMessageContext = opContext.getMessageContext("In")) != null) {
                inMessageContext.setProcessingFault(true);
            }
            if (value != null) {
                msgContext.setProperty("CleanupResponse", Boolean.FALSE);
                this.processResponse(response, msgContext);
            }
            if (Utils.isClientThreadNonBlockingPropertySet(msgContext)) {
                throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), response.getStatusLine().toString()));
            }
        } else {
            msgContext.setProperty("CleanupResponse", Boolean.TRUE);
            throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), response.getStatusLine().toString()));
        }
    }

    protected void obtainHTTPHeaderInformation(Object httpResponse, MessageContext msgContext) throws AxisFault {
        if (!(httpResponse instanceof HttpResponse)) {
            return;
        }
        HttpResponse response = (HttpResponse)httpResponse;
        HTTPTransportHeaders transportHeaders = new HTTPTransportHeaders(response.getAllHeaders());
        msgContext.setProperty("TRANSPORT_HEADERS", transportHeaders);
        msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(response.getStatusLine().getStatusCode()));
        Header header = response.getFirstHeader("Content-Type");
        if (header != null) {
            HeaderElement[] headers = header.getElements();
            MessageContext inMessageContext = msgContext.getOperationContext().getMessageContext("In");
            String contentType = header.getValue();
            String charSetEnc = null;
            for (int i = 0; i < headers.length; ++i) {
                NameValuePair charsetEnc = headers[i].getParameterByName(HTTPConstants.CHAR_SET_ENCODING);
                if (charsetEnc == null) continue;
                charSetEnc = charsetEnc.getValue();
            }
            if (inMessageContext != null) {
                inMessageContext.setProperty("ContentType", contentType);
                inMessageContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            } else {
                HashMap<String, String> transportInfoMap = new HashMap<String, String>();
                transportInfoMap.put("ContentType", contentType);
                transportInfoMap.put("CHARACTER_SET_ENCODING", charSetEnc);
                msgContext.setProperty("TransportInfoMap", transportInfoMap);
            }
        }
        String sessionCookie = null;
        Header[] cookieHeaders = response.getHeaders("Set-Cookie");
        String customCoookiId = (String)msgContext.getProperty("customCookieID");
        sessionCookie = this.processSetCookieHeaders(cookieHeaders);
        cookieHeaders = response.getHeaders("Set-Cookie2");
        for (int i = 0; i < cookieHeaders.length; ++i) {
            HeaderElement[] elements = cookieHeaders[i].getElements();
            for (int e = 0; e < elements.length; ++e) {
                HeaderElement element = elements[e];
                if ("axis_session".equalsIgnoreCase(element.getName()) || "JSESSIONID".equalsIgnoreCase(element.getName())) {
                    sessionCookie = this.processCookieHeader(element);
                }
                if (customCoookiId == null || !customCoookiId.equalsIgnoreCase(element.getName())) continue;
                sessionCookie = this.processCookieHeader(element);
            }
        }
        if (sessionCookie != null && !sessionCookie.equals("")) {
            msgContext.getServiceContext().setProperty("Cookie", sessionCookie);
        }
    }

    private String processCookieHeader(HeaderElement element) {
        String cookie = element.getName() + "=" + element.getValue();
        NameValuePair[] parameters = element.getParameters();
        for (int j = 0; parameters != null && j < parameters.length; ++j) {
            NameValuePair parameter = parameters[j];
            cookie = cookie + "; " + parameter.getName() + "=" + parameter.getValue();
        }
        return cookie;
    }

    private String processSetCookieHeaders(Header[] headers) {
        String cookie = "";
        for (Header header : headers) {
            HeaderElement[] elements;
            if (!cookie.equals("")) {
                cookie = cookie + ";";
            }
            for (HeaderElement element : elements = header.getElements()) {
                NameValuePair[] parameters;
                cookie = cookie + element.getName() + "=" + element.getValue();
                for (NameValuePair parameter : parameters = element.getParameters()) {
                    cookie = cookie + "; " + parameter.getName() + "=" + parameter.getValue();
                }
            }
        }
        return cookie;
    }

    protected void processResponse(HttpResponse response, MessageContext msgContext) throws IOException {
        OperationContext opContext;
        this.obtainHTTPHeaderInformation(response, msgContext);
        HttpEntity httpEntity = response.getEntity();
        InputStream in = httpEntity.getContent();
        if (in == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "InputStream"));
        }
        Header contentEncoding = httpEntity.getContentEncoding();
        if (contentEncoding != null) {
            if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                in = new GZIPInputStream(in);
            } else if (!"identity".equalsIgnoreCase(contentEncoding.getValue())) {
                throw new AxisFault("HTTP :unsupported content-encoding of '" + contentEncoding.getValue() + "' found");
            }
        }
        if ((opContext = msgContext.getOperationContext()) != null) {
            opContext.setProperty("TRANSPORT_IN", in);
        }
    }

    protected HttpHost getHostConfiguration(AbstractHttpClient client, MessageContext msgCtx, URL targetURL) throws AxisFault {
        boolean isAuthenticationEnabled = this.isAuthenticationEnabled(msgCtx);
        int port = targetURL.getPort();
        String protocol = targetURL.getProtocol();
        if (port == -1) {
            if ("http".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol)) {
                port = 443;
            }
        }
        HttpHost hostConfig = new HttpHost(targetURL.getHost(), port, targetURL.getProtocol());
        if (isAuthenticationEnabled) {
            this.setAuthenticationInfo(client, msgCtx);
        }
        if (HTTPProxyConfigurator.isProxyEnabled(msgCtx, targetURL)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring HTTP proxy.");
            }
            HTTPProxyConfigurator.configure(msgCtx, client);
        }
        return hostConfig;
    }

    protected boolean isAuthenticationEnabled(MessageContext msgCtx) {
        return msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_") != null;
    }

    protected void setAuthenticationInfo(AbstractHttpClient agent, MessageContext msgCtx) throws AxisFault {
        Object obj = msgCtx.getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_");
        if (obj != null) {
            if (obj instanceof HTTPAuthenticator) {
                UsernamePasswordCredentials creds;
                HTTPAuthenticator authenticator = (HTTPAuthenticator)obj;
                String username = authenticator.getUsername();
                String password = authenticator.getPassword();
                String host = authenticator.getHost();
                String domain = authenticator.getDomain();
                int port = authenticator.getPort();
                String realm = authenticator.getRealm();
                this.isAllowedRetry = authenticator.isAllowedRetry();
                if (host != null) {
                    if (domain != null) {
                        agent.getAuthSchemes().register("ntlm", (AuthSchemeFactory)new NTLMSchemeFactory());
                        creds = new NTCredentials(username, password, host, domain);
                    } else {
                        creds = new UsernamePasswordCredentials(username, password);
                    }
                    agent.getCredentialsProvider().setCredentials(new AuthScope(host, port, realm), (Credentials)creds);
                } else if (domain != null) {
                    agent.getAuthSchemes().register("ntlm", (AuthSchemeFactory)new NTLMSchemeFactory());
                    creds = new NTCredentials(username, password, AuthScope.ANY_HOST, domain);
                    agent.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, port, realm), (Credentials)creds);
                } else {
                    creds = new UsernamePasswordCredentials(username, password);
                    agent.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)creds);
                }
                List schemes = authenticator.getAuthSchemes();
                if (schemes != null && schemes.size() > 0) {
                    ArrayList<Object> authPrefs = new ArrayList<Object>(3);
                    for (int i = 0; i < schemes.size(); ++i) {
                        if (schemes.get(i) instanceof AuthPolicy) {
                            authPrefs.add(schemes.get(i));
                            continue;
                        }
                        String scheme = (String)schemes.get(i);
                        authPrefs.add(authenticator.getAuthPolicyPref(scheme));
                    }
                    agent.getParams().setParameter("http.auth.target-scheme-pref", authPrefs);
                }
            } else {
                throw new AxisFault("HttpTransportProperties.Authenticator class cast exception");
            }
        }
    }

    protected MessageFormatter populateCommonProperties(MessageContext msgContext, URL url, HttpRequestBase httpMethod, AbstractHttpClient httpClient, String soapActionString) throws AxisFault {
        Object cookieString;
        if (this.isAuthenticationEnabled(msgContext)) {
            httpMethod.getParams().setBooleanParameter("http.protocol.handle-authentication", true);
        }
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter(msgContext);
        url = messageFormatter.getTargetAddress(msgContext, this.format, url);
        try {
            httpMethod.setURI(url.toURI());
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error in URI : " + url), (Throwable)e);
        }
        httpMethod.setHeader("Content-Type", messageFormatter.getContentType(msgContext, this.format, soapActionString));
        httpMethod.setHeader("Host", url.getHost());
        if (msgContext.getOptions() != null && msgContext.getOptions().isManageSession() && (cookieString = msgContext.getProperty("Cookie")) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(cookieString);
            httpMethod.setHeader("Cookie", buffer.toString());
        }
        if (this.httpVersion.equals("HTTP/1.0")) {
            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
        return messageFormatter;
    }

    protected void initializeTimeouts(MessageContext msgContext, AbstractHttpClient httpClient) {
        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
        if (tempConnTimeoutProperty != null) {
            int connectionTimeout = tempConnTimeoutProperty;
            httpClient.getParams().setParameter("http.connection.timeout", (Object)connectionTimeout);
        } else if (timeout > 0L) {
            httpClient.getParams().setParameter("http.connection.timeout", (Object)((int)timeout));
        }
        if (tempSoTimeoutProperty != null) {
            int soTimeout = tempSoTimeoutProperty;
            httpClient.getParams().setParameter("http.socket.timeout", (Object)soTimeout);
        } else if (timeout > 0L) {
            httpClient.getParams().setParameter("http.socket.timeout", (Object)((int)timeout));
        }
    }

    protected void setTimeouts(MessageContext msgContext, HttpRequestBase httpMethod) {
        Integer tempSoTimeoutProperty = (Integer)msgContext.getProperty("SO_TIMEOUT");
        Integer tempConnTimeoutProperty = (Integer)msgContext.getProperty("CONNECTION_TIMEOUT");
        long timeout = msgContext.getOptions().getTimeOutInMilliSeconds();
        if (tempConnTimeoutProperty != null) {
            httpMethod.getParams().setParameter("http.connection.timeout", (Object)tempConnTimeoutProperty);
        }
        if (tempSoTimeoutProperty != null) {
            httpMethod.getParams().setParameter("http.socket.timeout", (Object)tempSoTimeoutProperty);
        } else if (timeout > 0L) {
            httpMethod.getParams().setParameter("http.socket.timeout", (Object)((int)timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractHttpClient getHttpClient(MessageContext msgContext) {
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        AbstractHttpClient httpClient = (AbstractHttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
        if (httpClient == null) {
            httpClient = (AbstractHttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
        }
        if (httpClient != null) {
            return httpClient;
        }
        HTTPSenderImpl hTTPSenderImpl = this;
        synchronized (hTTPSenderImpl) {
            httpClient = (AbstractHttpClient)msgContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                httpClient = (AbstractHttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
            }
            if (httpClient != null) {
                return httpClient;
            }
            ClientConnectionManager connManager = (ClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            if (connManager == null) {
                connManager = (ClientConnectionManager)msgContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
            }
            if (connManager == null) {
                ConfigurationContext configurationContext = configContext;
                synchronized (configurationContext) {
                    connManager = (ClientConnectionManager)configContext.getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER");
                    if (connManager == null) {
                        log.trace((Object)"Making new ConnectionManager");
                        SchemeRegistry schemeRegistry = new SchemeRegistry();
                        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
                        connManager = new PoolingClientConnectionManager(schemeRegistry);
                        ((PoolingClientConnectionManager)connManager).setMaxTotal(200);
                        ((PoolingClientConnectionManager)connManager).setDefaultMaxPerRoute(200);
                        configContext.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", connManager);
                    }
                }
            }
            BasicHttpParams clientParams = new BasicHttpParams();
            clientParams.setParameter("http.protocol.element-charset", (Object)"UTF-8");
            httpClient = new DefaultHttpClient(connManager, (HttpParams)clientParams);
            this.initializeTimeouts(msgContext, httpClient);
            return httpClient;
        }
    }

    protected HttpResponse executeMethod(AbstractHttpClient httpClient, MessageContext msgContext, URL url, HttpRequestBase method) throws IOException {
        String cookiePolicy;
        HttpHost httpHost = this.getHostConfiguration(httpClient, msgContext, url);
        this.addCustomHeaders(method, msgContext);
        if (msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            method.addHeader("Accept-Encoding", "gzip");
        }
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            method.addHeader("Content-Encoding", "gzip");
        }
        if (msgContext.getProperty("HTTP_METHOD_PARAMS") != null) {
            HttpParams params = (HttpParams)msgContext.getProperty("HTTP_METHOD_PARAMS");
            method.setParams(params);
        }
        if ((cookiePolicy = (String)msgContext.getProperty("COOKIE_POLICY")) != null) {
            method.getParams().setParameter("http.protocol.cookie-policy", (Object)cookiePolicy);
        }
        this.setTimeouts(msgContext, method);
        BasicHttpContext localContext = new BasicHttpContext();
        return httpClient.execute(httpHost, (HttpRequest)method, (HttpContext)localContext);
    }

    public void addCustomHeaders(HttpRequestBase method, MessageContext msgContext) {
        Map transportHeaders;
        boolean isCustomUserAgentSet = false;
        Object httpHeadersObj = msgContext.getProperty("HTTP_HEADERS");
        if (httpHeadersObj != null) {
            Object httpHeaders;
            if (httpHeadersObj instanceof List) {
                httpHeaders = (List)httpHeadersObj;
                for (int i = 0; i < httpHeaders.size(); ++i) {
                    NamedValue nv = (NamedValue)httpHeaders.get(i);
                    if (nv == null) continue;
                    BasicHeader header = new BasicHeader(nv.getName(), nv.getValue());
                    if ("User-Agent".equals(header.getName())) {
                        isCustomUserAgentSet = true;
                    }
                    method.addHeader((Header)header);
                }
            }
            if (httpHeadersObj instanceof Map) {
                httpHeaders = (Map)httpHeadersObj;
                for (Map.Entry entry : httpHeaders.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("User-Agent".equals(key)) {
                        isCustomUserAgentSet = true;
                    }
                    method.addHeader(key, value);
                }
            }
        }
        if ((transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null) {
            this.removeUnwantedHeaders(msgContext);
            Set headerEntries = transportHeaders.entrySet();
            for (Map.Entry headerEntry : headerEntries) {
                if (!(headerEntry instanceof Map.Entry)) continue;
                Header[] headers = method.getAllHeaders();
                boolean headerAdded = false;
                for (Header header : headers) {
                    if (header.getName() == null || !header.getName().equals(headerEntry.getKey())) continue;
                    headerAdded = true;
                    break;
                }
                if (headerAdded) continue;
                method.addHeader(headerEntry.getKey().toString(), headerEntry.getValue().toString());
            }
        }
        if (!isCustomUserAgentSet) {
            String userAgentString = this.getUserAgent(msgContext);
            method.setHeader("User-Agent", userAgentString);
        }
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if (!"Connection".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Date".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Length".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    private String getUserAgent(MessageContext messageContext) {
        String userAgentString = "Axis2";
        boolean locked = false;
        if (messageContext.getParameter("userAgent") != null) {
            OMElement userAgentElement = messageContext.getParameter("userAgent").getParameterElement();
            userAgentString = userAgentElement.getText().trim();
            OMAttribute lockedAttribute = userAgentElement.getAttribute(new QName("locked"));
            if (lockedAttribute != null && lockedAttribute.getAttributeValue().equalsIgnoreCase("true")) {
                locked = true;
            }
        }
        if (!locked && messageContext.getProperty("userAgent") != null) {
            userAgentString = (String)messageContext.getProperty("userAgent");
        }
        return userAgentString;
    }
}

