/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.engine.DependencyManager;

public class SessionManager {
    private final Map<String, SessionContext> sessionmap = new HashMap<String, SessionContext>();

    public synchronized SessionContext getSessionContext(String sessionKey) {
        SessionContext sessionContext = null;
        if (sessionKey != null && sessionKey.length() != 0) {
            sessionContext = this.sessionmap.get(sessionKey);
        }
        if (sessionContext == null) {
            sessionKey = UIDGenerator.generateUID();
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(sessionKey);
            this.sessionmap.put(sessionKey, sessionContext);
        }
        sessionContext.touch();
        this.cleanupServiceGroupContexts();
        return sessionContext;
    }

    private void cleanupServiceGroupContexts() {
        long currentTime = System.currentTimeMillis();
        Iterator<String> it = this.sessionmap.keySet().iterator();
        while (it.hasNext()) {
            String cookieID = it.next();
            SessionContext sessionContext = this.sessionmap.get(cookieID);
            if (currentTime - sessionContext.getLastTouchedTime() <= sessionContext.sessionContextTimeoutInterval) continue;
            it.remove();
            Iterator<ServiceGroupContext> serviceGroupContext = sessionContext.getServiceGroupContext();
            if (serviceGroupContext == null) continue;
            while (serviceGroupContext.hasNext()) {
                ServiceGroupContext groupContext = serviceGroupContext.next();
                this.cleanupServiceContexts(groupContext);
            }
        }
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        Iterator<ServiceContext> it = serviceGroupContext.getServiceContexts();
        while (it.hasNext()) {
            ServiceContext serviceContext = it.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }
}

