/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils.reader;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBDataHandlerStreamReader;
import org.apache.axis2.databinding.utils.reader.ADBNamespaceContext;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReader;
import org.apache.axis2.databinding.utils.reader.NameValuePairStreamReader;
import org.apache.axis2.databinding.utils.reader.NullXMLStreamReader;
import org.apache.axis2.databinding.utils.reader.OMAttribKey;
import org.apache.axis2.databinding.utils.reader.OMElementKey;
import org.apache.axis2.databinding.utils.reader.WrappingXMLStreamReader;
import org.apache.axis2.description.java2wsdl.TypeTable;

public class ADBXMLStreamReaderImpl
implements ADBXMLStreamReader,
DataHandlerReader {
    private static final AtomicInteger nsPrefix = new AtomicInteger();
    private Object[] properties;
    private Object[] attributes;
    private QName elementQName;
    private HashMap qnameMap = new HashMap();
    private ADBNamespaceContext namespaceContext = new ADBNamespaceContext();
    private Map declaredNamespaceMap = new HashMap();
    private static final int START_ELEMENT_STATE = 0;
    private static final int END_ELEMENT_STATE = 1;
    private static final int DELEGATED_STATE = 2;
    private static final int TEXT_STATE = 3;
    private int state = 0;
    private ADBXMLStreamReader childReader;
    private int currentPropertyIndex = 0;
    private boolean qualified = false;
    private TypeTable typeTable = null;

    public ADBXMLStreamReaderImpl(QName adbBeansQName, Object[] properties, Object[] attributes) {
        this.properties = properties;
        this.elementQName = adbBeansQName;
        this.attributes = attributes;
    }

    public ADBXMLStreamReaderImpl(QName adbBeansQName, Object[] properties, Object[] attributes, TypeTable typeTable, boolean qualified) {
        this(adbBeansQName, properties, attributes);
        Map<String, QName> complexTypeMap;
        this.qualified = qualified;
        this.typeTable = typeTable;
        if (this.typeTable != null && (complexTypeMap = this.typeTable.getComplexSchemaMap()) != null) {
            for (String key : complexTypeMap.keySet()) {
                QName qname = complexTypeMap.get(key);
                if (qname == null) continue;
                String prefix = qname.getPrefix();
                if (prefix == null || "".equals(prefix)) {
                    prefix = ADBXMLStreamReaderImpl.getNextNSPrefix();
                }
                qname = new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
                this.typeTable.getComplexSchemaMap().put(key, qname);
                this.qnameMap.put(qname.getNamespaceURI(), prefix);
                this.addToNsMap(prefix, qname.getNamespaceURI());
            }
        }
    }

    private static String getNextNSPrefix() {
        return "ns" + nsPrefix.incrementAndGet();
    }

    @Override
    public void addNamespaceContext(NamespaceContext nsContext) {
        this.namespaceContext.setParentNsContext(nsContext);
    }

    @Override
    public void init() {
        this.populateNamespaceContext();
    }

    @Override
    public Object getProperty(String key) throws IllegalArgumentException {
        return XMLStreamReaderUtils.processGetProperty((DataHandlerReader)this, (String)key);
    }

    public boolean isBinary() {
        return this.state == 2 && this.childReader instanceof DataHandlerReader && ((DataHandlerReader)this.childReader).isBinary();
    }

    public boolean isOptimized() {
        return ((DataHandlerReader)this.childReader).isOptimized();
    }

    public boolean isDeferred() {
        return ((DataHandlerReader)this.childReader).isDeferred();
    }

    public String getContentID() {
        return ((DataHandlerReader)this.childReader).getContentID();
    }

    public DataHandler getDataHandler() throws XMLStreamException {
        return ((DataHandlerReader)this.childReader).getDataHandler();
    }

    public DataHandlerProvider getDataHandlerProvider() {
        return ((DataHandlerReader)this.childReader).getDataHandlerProvider();
    }

    @Override
    public void require(int i, String string, String string1) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getElementText();
        }
        return null;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return 0;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.state == 2) {
            if (this.childReader.isDone()) {
                return true;
            }
            return this.childReader.hasNext();
        }
        return this.state == 0 || this.state == 3;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        if (this.state == 0) {
            return true;
        }
        if (this.state == 1) {
            return false;
        }
        return this.childReader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        if (this.state == 0) {
            return false;
        }
        if (this.state == 1) {
            return true;
        }
        return this.childReader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String nsUri, String localName) {
        int attribCount = this.getAttributeCount();
        String returnValue = null;
        for (int i = 0; i < attribCount; ++i) {
            QName attribQualifiedName = this.getAttributeName(i);
            if (nsUri == null) {
                if (!localName.equals(attribQualifiedName.getLocalPart())) continue;
                returnValue = this.getAttributeValue(i);
                break;
            }
            if (!localName.equals(attribQualifiedName.getLocalPart()) || !nsUri.equals(attribQualifiedName.getNamespaceURI())) continue;
            returnValue = this.getAttributeValue(i);
            break;
        }
        return returnValue;
    }

    @Override
    public int getAttributeCount() {
        return this.state == 2 ? this.childReader.getAttributeCount() : (this.attributes != null && this.state == 0 ? this.attributes.length / 2 : 0);
    }

    @Override
    public QName getAttributeName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeName(i);
        }
        if (this.state == 0) {
            if (this.attributes == null) {
                return null;
            }
            if (i >= this.attributes.length / 2 || i < 0) {
                return null;
            }
            Object attribPointer = this.attributes[i * 2];
            if (attribPointer == null) {
                Object omAttribObj = this.attributes[i * 2 + 1];
                if (omAttribObj == null || !(omAttribObj instanceof OMAttribute)) {
                    throw new UnsupportedOperationException();
                }
                OMAttribute att = (OMAttribute)omAttribObj;
                return att.getQName();
            }
            if (attribPointer instanceof OMAttribKey) {
                Object omAttribObj = this.attributes[i * 2 + 1];
                if (omAttribObj == null || !(omAttribObj instanceof OMAttribute)) {
                    throw new UnsupportedOperationException();
                }
                OMAttribute att = (OMAttribute)omAttribObj;
                return att.getQName();
            }
            if (attribPointer instanceof String) {
                return new QName((String)attribPointer);
            }
            if (attribPointer instanceof QName) {
                return (QName)attribPointer;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeNamespace(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeNamespace(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getNamespaceURI();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeLocalName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeLocalName(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getLocalPart();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributePrefix(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getPrefix();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeType(int i) {
        return null;
    }

    @Override
    public String getAttributeValue(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeValue(i);
        }
        if (this.state == 0) {
            if (this.attributes == null) {
                return null;
            }
            if (i >= this.attributes.length / 2 || i < 0) {
                return null;
            }
            Object attribPointer = this.attributes[i * 2];
            Object omAttribObj = this.attributes[i * 2 + 1];
            if (attribPointer == null) {
                if (omAttribObj == null || !(omAttribObj instanceof OMAttribute)) {
                    throw new UnsupportedOperationException();
                }
                OMAttribute att = (OMAttribute)omAttribObj;
                return att.getAttributeValue();
            }
            if (attribPointer instanceof OMAttribKey) {
                if (omAttribObj == null || !(omAttribObj instanceof OMAttribute)) {
                    throw new UnsupportedOperationException();
                }
                OMAttribute att = (OMAttribute)omAttribObj;
                return att.getAttributeValue();
            }
            if (attribPointer instanceof String) {
                return (String)omAttribObj;
            }
            if (attribPointer instanceof QName) {
                if (omAttribObj instanceof QName) {
                    QName attributeQName = (QName)omAttribObj;
                    String prefix = this.namespaceContext.getPrefix(attributeQName.getNamespaceURI());
                    if (prefix == null) {
                        prefix = ADBXMLStreamReaderImpl.getNextNSPrefix();
                        this.addToNsMap(prefix, attributeQName.getNamespaceURI());
                    }
                    String attributeValue = null;
                    attributeValue = prefix.equals("") ? attributeQName.getLocalPart() : prefix + ":" + attributeQName.getLocalPart();
                    return attributeValue;
                }
                return (String)omAttribObj;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        if (this.state == 2) {
            return this.childReader.getNamespaceCount();
        }
        return this.declaredNamespaceMap.size();
    }

    @Override
    public String getNamespacePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespacePrefix(i);
        }
        if (this.state != 3) {
            String[] prefixes = this.makePrefixArray();
            if (i >= prefixes.length || i < 0) {
                return null;
            }
            return prefixes[i];
        }
        throw new IllegalStateException();
    }

    private String[] makePrefixArray() {
        Object[] prefixes = this.declaredNamespaceMap.keySet().toArray(new String[this.declaredNamespaceMap.size()]);
        Arrays.sort(prefixes);
        return prefixes;
    }

    @Override
    public String getNamespaceURI(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI(i);
        }
        if (this.state != 3) {
            String namespacePrefix = this.getNamespacePrefix(i);
            return namespacePrefix == null ? null : (String)this.declaredNamespaceMap.get(namespacePrefix);
        }
        throw new IllegalStateException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.state == 2) {
            return this.childReader.getNamespaceContext();
        }
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        if (this.state == 0) {
            return 1;
        }
        if (this.state == 1) {
            return 2;
        }
        return this.childReader.getEventType();
    }

    @Override
    public String getText() {
        if (this.state == 2) {
            return this.childReader.getText();
        }
        if (this.state == 3) {
            Object property = this.properties[this.currentPropertyIndex - 1];
            if (property instanceof DataHandler) {
                return ConverterUtil.getStringFromDatahandler((DataHandler)property);
            }
            return (String)this.properties[this.currentPropertyIndex - 1];
        }
        throw new IllegalStateException();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.state == 2) {
            return this.childReader.getTextCharacters();
        }
        if (this.state == 3) {
            return this.properties[this.currentPropertyIndex - 1] == null ? new char[]{} : ((String)this.properties[this.currentPropertyIndex - 1]).toCharArray();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getTextCharacters(i, chars, i1, i2);
        }
        if (this.state == 3) {
            return 0;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextStart() {
        if (this.state == 2) {
            return this.childReader.getTextStart();
        }
        if (this.state == 3) {
            return 0;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextLength() {
        if (this.state == 2) {
            return this.childReader.getTextLength();
        }
        if (this.state == 3) {
            return 0;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getEncoding() {
        if (this.state == 2) {
            return this.childReader.getEncoding();
        }
        return null;
    }

    @Override
    public boolean hasText() {
        if (this.state == 2) {
            return this.childReader.hasText();
        }
        return this.state == 3;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getLineNumber() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        if (this.state == 2) {
            return this.childReader.getName();
        }
        if (this.state != 3) {
            return this.elementQName;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getLocalName() {
        if (this.state == 2) {
            return this.childReader.getLocalName();
        }
        if (this.state != 3) {
            return this.elementQName.getLocalPart();
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasName() {
        if (this.state == 2) {
            return this.childReader.hasName();
        }
        return this.state != 3;
    }

    @Override
    public String getNamespaceURI() {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI();
        }
        if (this.state == 3) {
            return null;
        }
        return this.elementQName.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        if (this.state == 2) {
            return this.childReader.getPrefix();
        }
        if (this.state == 3) {
            return null;
        }
        String prefix = this.elementQName.getPrefix();
        return "".equals(prefix) ? null : prefix;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean standaloneSet() {
        return true;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    private void populateNamespaceContext() {
        this.addToNsMap(this.elementQName.getPrefix(), this.elementQName.getNamespaceURI());
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; i += 2) {
                OMNamespace namespace;
                OMAttribute OMAttrib;
                Object attribName = this.attributes[i];
                if (attribName == null) {
                    OMAttrib = (OMAttribute)this.attributes[i + 1];
                    namespace = OMAttrib.getNamespace();
                    if (namespace == null) continue;
                    this.addToNsMap(namespace.getPrefix(), namespace.getNamespaceURI());
                    continue;
                }
                if (attribName instanceof OMAttribKey) {
                    OMAttrib = (OMAttribute)this.attributes[i + 1];
                    namespace = OMAttrib.getNamespace();
                    if (namespace == null) continue;
                    this.addToNsMap(namespace.getPrefix(), namespace.getNamespaceURI());
                    continue;
                }
                if (attribName instanceof String || !(attribName instanceof QName)) continue;
                QName attribQName = (QName)attribName;
                this.addToNsMap(attribQName.getPrefix(), attribQName.getNamespaceURI());
            }
        }
    }

    private void addToNsMap(String prefix, String uri) {
        if (!uri.equals(this.namespaceContext.getNamespaceURI(prefix))) {
            this.namespaceContext.pushNamespace(prefix, uri);
            this.declaredNamespaceMap.put(prefix, uri);
        }
    }

    @Override
    public int next() throws XMLStreamException {
        int returnEvent = -1;
        switch (this.state) {
            case 0: {
                if (this.properties == null || this.properties.length == 0) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
                break;
            }
            case 1: {
                throw new XMLStreamException("Trying to go beyond the end of the pullparser");
            }
            case 2: {
                if (this.childReader.isDone()) {
                    if (this.currentPropertyIndex > this.properties.length - 1) {
                        this.state = 1;
                        returnEvent = 2;
                        break;
                    }
                    returnEvent = this.processProperties();
                    break;
                }
                returnEvent = this.childReader.next();
                break;
            }
            case 3: {
                if (this.currentPropertyIndex > this.properties.length - 1) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
            }
        }
        return returnEvent;
    }

    private int processProperties() throws XMLStreamException {
        String prefix;
        Object propPointer = this.properties[this.currentPropertyIndex];
        QName propertyQName = null;
        boolean textFound = false;
        if (propPointer == null) {
            throw new XMLStreamException("property key cannot be null!");
        }
        if (propPointer instanceof String) {
            if ("Element Text".equals(propPointer)) {
                textFound = true;
            } else {
                propertyQName = new QName((String)propPointer);
            }
        } else if (propPointer instanceof QName) {
            propertyQName = (QName)propPointer;
        } else if (!(propPointer instanceof OMElementKey)) {
            throw new XMLStreamException("unidentified property key!!!" + propPointer);
        }
        if (propertyQName != null && (prefix = (String)this.qnameMap.get(propertyQName.getNamespaceURI())) != null) {
            propertyQName = new QName(propertyQName.getNamespaceURI(), propertyQName.getLocalPart(), prefix);
        }
        Object propertyValue = this.properties[this.currentPropertyIndex + 1];
        if (textFound) {
            this.childReader = null;
            this.state = 3;
            this.currentPropertyIndex += 2;
            return 4;
        }
        if (propertyValue == null) {
            this.childReader = new NullXMLStreamReader(propertyQName);
            this.childReader.addNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof DataHandler) {
            this.childReader = new ADBDataHandlerStreamReader(propertyQName, (DataHandler)propertyValue);
            this.childReader.addNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof String) {
            this.childReader = new NameValuePairStreamReader(propertyQName, (String)propertyValue);
            this.childReader.addNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof Integer || propertyValue instanceof Long || propertyValue instanceof Double || propertyValue instanceof Float || propertyValue instanceof Character || propertyValue instanceof Short) {
            this.childReader = new NameValuePairStreamReader(propertyQName, String.valueOf(propertyValue));
            this.childReader.addNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            if (length == 0) {
                this.currentPropertyIndex += 2;
                return this.processProperties();
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            Object valueObject = null;
            for (int i = 0; i < length; ++i) {
                objects.add(new QName(propertyQName.getNamespaceURI(), "array"));
                valueObject = Array.get(propertyValue, i);
                if (valueObject != null && SimpleTypeMapper.isSimpleType(valueObject)) {
                    objects.add(SimpleTypeMapper.getStringValue(valueObject));
                    continue;
                }
                objects.add(valueObject);
            }
            this.childReader = new ADBXMLStreamReaderImpl(propertyQName, objects.toArray(), new ArrayList().toArray(), this.typeTable, this.qualified);
        } else {
            this.childReader = propertyValue instanceof OMElement ? new WrappingXMLStreamReader(((OMElement)propertyValue).getXMLStreamReader()) : (ADBXMLStreamReader)BeanUtil.getPullParser(propertyValue, propertyQName, this.typeTable, this.qualified, false);
        }
        this.state = 2;
        this.currentPropertyIndex += 2;
        int eventType = this.childReader.getEventType();
        return eventType == 7 ? this.childReader.next() : eventType;
    }

    @Override
    public boolean isDone() {
        return this.state == 1;
    }
}

