/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.http.servlet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bookkeeper.http.AbstractHttpHandlerFactory;
import org.apache.bookkeeper.http.HttpRouter;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.http.service.ErrorHttpService;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.http.servlet.BookieServletHttpServer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieHttpServiceServlet
extends HttpServlet {
    static final Logger LOG = LoggerFactory.getLogger(BookieHttpServiceServlet.class);
    private final Map<String, HttpServer.ApiType> mappings = new ConcurrentHashMap<String, HttpServer.ApiType>();

    public BookieHttpServiceServlet() {
        HttpRouter<HttpServer.ApiType> router = new HttpRouter<HttpServer.ApiType>((AbstractHttpHandlerFactory)new AbstractHttpHandlerFactory<HttpServer.ApiType>(BookieServletHttpServer.getBookieHttpServiceProvider()){

            public HttpServer.ApiType newHandler(HttpServer.ApiType apiType) {
                return apiType;
            }
        }){

            public void bindHandler(String endpoint, HttpServer.ApiType mapping) {
                BookieHttpServiceServlet.this.mappings.put(endpoint, mapping);
            }
        };
        router.bindAll();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        HttpServiceResponse response;
        HttpServiceRequest request = new HttpServiceRequest().setMethod(this.httpServerMethod(httpRequest)).setParams(this.httpServletParams(httpRequest)).setBody(IOUtils.toString((InputStream)httpRequest.getInputStream(), (String)"UTF-8"));
        String uri = httpRequest.getRequestURI();
        try {
            HttpServer.ApiType apiType = this.mappings.get(uri);
            HttpServiceProvider bookie = BookieServletHttpServer.getBookieHttpServiceProvider();
            if (bookie == null) {
                httpResponse.sendError(500);
                return;
            }
            HttpEndpointService httpEndpointService = bookie.provideHttpEndpointService(apiType);
            if (httpEndpointService == null) {
                httpResponse.sendError(404);
                return;
            }
            response = httpEndpointService.handle(request);
        }
        catch (Throwable e) {
            LOG.error("Error while service Bookie API request " + uri, e);
            response = new ErrorHttpService().handle(request);
        }
        if (response != null) {
            httpResponse.setStatus(response.getStatusCode());
            try (PrintWriter out = httpResponse.getWriter();){
                ((Writer)out).write(response.getBody());
            }
        } else {
            httpResponse.sendError(500);
        }
    }

    Map<String, String> httpServletParams(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration param = request.getParameterNames();
        while (param.hasMoreElements()) {
            String pName = (String)param.nextElement();
            map.put(pName, request.getParameter(pName));
        }
        return map;
    }

    HttpServer.Method httpServerMethod(HttpServletRequest request) {
        switch (request.getMethod()) {
            case "POST": {
                return HttpServer.Method.POST;
            }
            case "DELETE": {
                return HttpServer.Method.DELETE;
            }
            case "PUT": {
                return HttpServer.Method.PUT;
            }
            case "GET": {
                return HttpServer.Method.GET;
            }
        }
        throw new UnsupportedOperationException("Unsupported http method");
    }
}

