/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.http.servlet;

import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServletHttpServer
implements HttpServer {
    static final Logger LOG = LoggerFactory.getLogger(BookieServletHttpServer.class);
    private static HttpServiceProvider bookieHttpServiceProvider;
    private static int listenPort;

    public static HttpServiceProvider getBookieHttpServiceProvider() {
        return bookieHttpServiceProvider;
    }

    public static int getListenPort() {
        return listenPort;
    }

    public void initialize(HttpServiceProvider httpServiceProvider) {
        BookieServletHttpServer.setHttpServiceProvider(httpServiceProvider);
        LOG.info("Bookie HTTP Server initialized: {}", (Object)httpServiceProvider);
    }

    public static synchronized void setHttpServiceProvider(HttpServiceProvider httpServiceProvider) {
        bookieHttpServiceProvider = httpServiceProvider;
    }

    public static synchronized void setPort(int port) {
        listenPort = port;
    }

    public boolean startServer(int port) {
        BookieServletHttpServer.setPort(port);
        return true;
    }

    public void stopServer() {
    }

    public boolean isRunning() {
        return true;
    }

    static {
        listenPort = -1;
    }
}

