/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.AllowAllAuthority;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.RawColumnDefinition;
import org.apache.cassandra.config.RawColumnFamily;
import org.apache.cassandra.config.RawKeyspace;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.scheduler.NoScheduler;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class DatabaseDescriptor {
    private static Logger logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress rpcAddress;
    private static Set<InetAddress> seeds;
    private static int currentIndex;
    static Map<String, KSMetaData> tables;
    private static IPartitioner partitioner;
    private static Config.DiskAccessMode indexAccessMode;
    private static Config conf;
    private static IAuthenticator authenticator;
    private static IAuthority authority;
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";
    private static IRequestScheduler requestScheduler;
    private static Config.RequestSchedulerId requestSchedulerId;
    private static RequestSchedulerOptions requestSchedulerOptions;
    public static final UUID INITIAL_VERSION;
    private static volatile UUID defsVersion;

    static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block3: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block3;
                throw new ConfigurationException("Cannot locate " + configUrl);
            }
        }
        return url;
    }

    private static IEndpointSnitch createEndpointSnitch(String endpointSnitchClassName) throws ConfigurationException {
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct(endpointSnitchClassName, "snitch");
        return DatabaseDescriptor.conf.dynamic_snitch != false ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    public static void loadSchemas() throws IOException {
        UUID uuid = Migration.getLastMigrationId();
        if (uuid == null) {
            logger.info("Couldn't detect any schema definitions in local storage.");
            boolean hasExistingTables = false;
            for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
                int dirCount;
                File dataPath = new File(dataDir);
                if (dataPath.exists() && dataPath.isDirectory() && (dirCount = dataPath.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                }).length) > 0) {
                    hasExistingTables = true;
                }
                if (hasExistingTables) break;
            }
            if (hasExistingTables) {
                logger.info("Found table data in data directories. Consider using JMX to call org.apache.cassandra.service.StorageService.loadSchemaFromYaml().");
            } else {
                logger.info("Consider using JMX to org.apache.cassandra.service.StorageService.loadSchemaFromYaml() or set up a schema using the system_* calls provided via thrift.");
            }
        } else {
            logger.info("Loading schema version " + uuid.toString());
            Collection<KSMetaData> tableDefs = DefsTable.loadFromStorage(uuid);
            for (KSMetaData def : tableDefs) {
                if (!def.name.matches("\\w+")) {
                    throw new RuntimeException("invalid keyspace name: " + def.name);
                }
                for (CFMetaData cfm : def.cfMetaData().values()) {
                    if (!cfm.cfName.matches("\\w+")) {
                        throw new RuntimeException("invalid column family name: " + cfm.cfName);
                    }
                    try {
                        CFMetaData.map(cfm);
                    }
                    catch (ConfigurationException ex) {
                        throw new IOError(ex);
                    }
                }
                DatabaseDescriptor.setTableDefinition(def, uuid);
            }
            if (tableDefs.size() == 0) {
                logger.warn("No schema definitions were found in local storage.");
                defsVersion = uuid;
            }
            if (DatabaseDescriptor.conf.keyspaces != null && DatabaseDescriptor.conf.keyspaces.size() > 0) {
                logger.warn("Schema definitions were defined both locally and in cassandra.yaml. Definitions in cassandra.yaml were ignored.");
            }
        }
        CFMetaData.fixMaxId();
    }

    public static Collection<KSMetaData> readTablesFromYaml() throws ConfigurationException {
        ArrayList<KSMetaData> defs = new ArrayList<KSMetaData>();
        if (DatabaseDescriptor.conf.keyspaces == null) {
            return defs;
        }
        for (RawKeyspace keyspace : DatabaseDescriptor.conf.keyspaces) {
            if (keyspace.name == null) {
                throw new ConfigurationException("Keyspace name attribute is required");
            }
            if (keyspace.name.equalsIgnoreCase("system")) {
                throw new ConfigurationException("'system' is a reserved table name for Cassandra internals");
            }
            if (keyspace.replica_placement_strategy == null) {
                throw new ConfigurationException("Missing replica_placement_strategy directive for " + keyspace.name);
            }
            String strategyClassName = KSMetaData.convertOldStrategyName(keyspace.replica_placement_strategy);
            Class strategyClass = FBUtilities.classForName(strategyClassName, "replication-strategy");
            if (keyspace.replication_factor == null) {
                throw new ConfigurationException("Missing replication_factor directory for keyspace " + keyspace.name);
            }
            int size2 = keyspace.column_families.length;
            CFMetaData[] cfDefs = new CFMetaData[size2];
            int j = 0;
            for (RawColumnFamily cf : keyspace.column_families) {
                ColumnFamilyType cfType;
                if (cf.name == null) {
                    throw new ConfigurationException("ColumnFamily name attribute is required");
                }
                if (!cf.name.matches("\\w+")) {
                    throw new ConfigurationException("ColumnFamily name contains invalid characters.");
                }
                AbstractType comparator = DatabaseDescriptor.getComparator(cf.compare_with);
                AbstractType subcolumnComparator = null;
                AbstractType default_validator = DatabaseDescriptor.getComparator(cf.default_validation_class);
                ColumnFamilyType columnFamilyType = cfType = cf.column_type == null ? ColumnFamilyType.Standard : cf.column_type;
                if (cfType == ColumnFamilyType.Super) {
                    subcolumnComparator = DatabaseDescriptor.getComparator(cf.compare_subcolumns_with);
                } else if (cf.compare_subcolumns_with != null) {
                    throw new ConfigurationException("compare_subcolumns_with is only a valid attribute on super columnfamilies (not regular columnfamily " + cf.name + ")");
                }
                if (cf.read_repair_chance < 0.0 || cf.read_repair_chance > 1.0) {
                    throw new ConfigurationException("read_repair_chance must be between 0.0 and 1.0 (0% and 100%)");
                }
                if (DatabaseDescriptor.conf.dynamic_snitch_badness_threshold < 0.0 || DatabaseDescriptor.conf.dynamic_snitch_badness_threshold > 1.0) {
                    throw new ConfigurationException("dynamic_snitch_badness_threshold must be between 0.0 and 1.0 (0% and 100%)");
                }
                if (cf.min_compaction_threshold < 0 || cf.max_compaction_threshold < 0) {
                    throw new ConfigurationException("min/max_compaction_thresholds must be positive integers.");
                }
                if (cf.min_compaction_threshold > cf.max_compaction_threshold && cf.max_compaction_threshold != 0) {
                    throw new ConfigurationException("min_compaction_threshold must be smaller than max_compaction_threshold, or either must be 0 (disabled)");
                }
                if (cf.memtable_throughput_in_mb == null) {
                    cf.memtable_throughput_in_mb = CFMetaData.sizeMemtableThroughput();
                    logger.info("memtable_throughput_in_mb not configured for " + cf.name + ", using " + cf.memtable_throughput_in_mb);
                }
                if (cf.memtable_operations_in_millions == null) {
                    cf.memtable_operations_in_millions = CFMetaData.sizeMemtableOperations(cf.memtable_throughput_in_mb);
                    logger.info("memtable_operations_in_millions not configured for " + cf.name + ", using " + cf.memtable_operations_in_millions);
                }
                if (cf.memtable_operations_in_millions != null && cf.memtable_operations_in_millions <= 0.0) {
                    throw new ConfigurationException("memtable_operations_in_millions must be a positive double");
                }
                TreeMap<ByteBuffer, ColumnDefinition> metadata = new TreeMap<ByteBuffer, ColumnDefinition>();
                for (RawColumnDefinition rcd : cf.column_metadata) {
                    if (rcd.name == null) {
                        throw new ConfigurationException("name is required for column definitions.");
                    }
                    if (rcd.validator_class == null) {
                        throw new ConfigurationException("validator is required for column definitions");
                    }
                    if (rcd.index_type == null && rcd.index_name != null) {
                        throw new ConfigurationException("index_name cannot be set if index_type is not also set");
                    }
                    ByteBuffer columnName = ByteBufferUtil.bytes(rcd.name);
                    metadata.put(columnName, new ColumnDefinition(columnName, rcd.validator_class, rcd.index_type, rcd.index_name));
                }
                cfDefs[j++] = new CFMetaData(keyspace.name, cf.name, cfType, comparator, subcolumnComparator, cf.comment, cf.rows_cached, cf.keys_cached, cf.read_repair_chance, cf.gc_grace_seconds, default_validator, cf.min_compaction_threshold, cf.max_compaction_threshold, cf.row_cache_save_period_in_seconds, cf.key_cache_save_period_in_seconds, cf.memtable_flush_after_mins, cf.memtable_throughput_in_mb, cf.memtable_operations_in_millions, metadata);
            }
            defs.add(new KSMetaData(keyspace.name, strategyClass, keyspace.strategy_options, keyspace.replication_factor, cfDefs));
        }
        return defs;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static IAuthority getAuthority() {
        return authority;
    }

    public static boolean isThriftFramed() {
        return DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb > 0;
    }

    public static int getThriftMaxMessageLength() {
        return DatabaseDescriptor.conf.thrift_max_message_length_in_mb * 1024 * 1024;
    }

    public static int getThriftFramedTransportSize() {
        return DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb * 1024 * 1024;
    }

    public static AbstractType getComparator(CharSequence compareWith) throws ConfigurationException {
        if (compareWith == null) {
            compareWith = "BytesType";
        }
        return FBUtilities.getComparator(((Object)compareWith).toString());
    }

    public static void createAllDirectories() throws IOException {
        try {
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified");
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
        }
        catch (ConfigurationException ex) {
            logger.error("Fatal error: " + ex.getMessage());
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static IRequestScheduler getRequestScheduler() {
        return requestScheduler;
    }

    public static RequestSchedulerOptions getRequestSchedulerOptions() {
        return requestSchedulerOptions;
    }

    public static Config.RequestSchedulerId getRequestSchedulerId() {
        return requestSchedulerId;
    }

    public static KSMetaData getKSMetaData(String table) {
        assert (table != null);
        return tables.get(table);
    }

    public static String getJobTrackerAddress() {
        return DatabaseDescriptor.conf.job_tracker_host;
    }

    public static int getColumnIndexSize() {
        return DatabaseDescriptor.conf.column_index_size_in_kb * 1024;
    }

    public static String getInitialToken() {
        return System.getProperty("cassandra.initial_token", DatabaseDescriptor.conf.initial_token);
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static String getJobJarLocation() {
        return DatabaseDescriptor.conf.job_jar_file_location;
    }

    public static Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        KSMetaData ksm = tables.get(tableName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public static CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        KSMetaData ksm = tables.get(tableName);
        if (ksm == null) {
            return null;
        }
        return ksm.cfMetaData().get(cfName);
    }

    public static CFMetaData getCFMetaData(Integer cfId) {
        Pair<String, String> cf = CFMetaData.getCF(cfId);
        if (cf == null) {
            return null;
        }
        return DatabaseDescriptor.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public static ColumnFamilyType getColumnFamilyType(String tableName, String cfName) {
        assert (tableName != null && cfName != null);
        CFMetaData cfMetaData = DatabaseDescriptor.getCFMetaData(tableName, cfName);
        if (cfMetaData == null) {
            return null;
        }
        return cfMetaData.cfType;
    }

    public static Set<String> getTables() {
        return tables.keySet();
    }

    public static List<String> getNonSystemTables() {
        ArrayList<String> tableslist = new ArrayList<String>(tables.keySet());
        tableslist.remove("system");
        return Collections.unmodifiableList(tableslist);
    }

    public static int getStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.storage_port", DatabaseDescriptor.conf.storage_port.toString()));
    }

    public static int getRpcPort() {
        return Integer.parseInt(System.getProperty("cassandra.rpc_port", DatabaseDescriptor.conf.rpc_port.toString()));
    }

    public static long getRpcTimeout() {
        return DatabaseDescriptor.conf.rpc_timeout_in_ms;
    }

    public static int getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getInMemoryCompactionLimit() {
        return DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb * 1024 * 1024;
    }

    public static String[] getAllDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String[] getAllDataFileLocationsForTable(String table) {
        String[] tableLocations = new String[DatabaseDescriptor.conf.data_file_directories.length];
        for (int i = 0; i < DatabaseDescriptor.conf.data_file_directories.length; ++i) {
            tableLocations[i] = DatabaseDescriptor.conf.data_file_directories[i] + File.separator + table;
        }
        return tableLocations;
    }

    public static synchronized String getNextAvailableDataLocation() {
        String dataFileDirectory = DatabaseDescriptor.conf.data_file_directories[currentIndex];
        currentIndex = (currentIndex + 1) % DatabaseDescriptor.conf.data_file_directories.length;
        return dataFileDirectory;
    }

    public static int getCommitLogSegmentSize() {
        return DatabaseDescriptor.conf.commitlog_rotation_threshold_in_mb != null ? DatabaseDescriptor.conf.commitlog_rotation_threshold_in_mb * 1024 * 1024 : 0x8000000;
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddress> getSeeds() {
        return seeds;
    }

    public static String getDataFileLocationForTable(String table, long expectedCompactedFileSize) {
        long maxFreeDisk = 0L;
        int maxDiskIndex = 0;
        String dataFileDirectory = null;
        String[] dataDirectoryForTable = DatabaseDescriptor.getAllDataFileLocationsForTable(table);
        for (int i = 0; i < dataDirectoryForTable.length; ++i) {
            File f = new File(dataDirectoryForTable[i]);
            if (maxFreeDisk >= f.getUsableSpace()) continue;
            maxFreeDisk = f.getUsableSpace();
            maxDiskIndex = i;
        }
        if (expectedCompactedFileSize < (maxFreeDisk = (long)(0.9 * (double)maxFreeDisk))) {
            dataFileDirectory = dataDirectoryForTable[maxDiskIndex];
            currentIndex = (maxDiskIndex + 1) % dataDirectoryForTable.length;
        } else {
            currentIndex = maxDiskIndex;
        }
        return dataFileDirectory;
    }

    public static AbstractType getComparator(String tableName, String cfName) {
        assert (tableName != null);
        CFMetaData cfmd = DatabaseDescriptor.getCFMetaData(tableName, cfName);
        if (cfmd == null) {
            throw new IllegalArgumentException("Unknown ColumnFamily " + cfName + " in keyspace " + tableName);
        }
        return cfmd.comparator;
    }

    public static AbstractType getSubComparator(String tableName, String cfName) {
        assert (tableName != null);
        return DatabaseDescriptor.getCFMetaData((String)tableName, (String)cfName).subcolumnComparator;
    }

    public static int getKeysCachedFor(String tableName, String columnFamilyName, long expectedKeys) {
        CFMetaData cfm = DatabaseDescriptor.getCFMetaData(tableName, columnFamilyName);
        double v = cfm == null ? 200000.0 : cfm.getKeyCacheSize();
        return (int)Math.min(FBUtilities.absoluteFromFraction(v, expectedKeys), Integer.MAX_VALUE);
    }

    public static int getRowsCachedFor(String tableName, String columnFamilyName, long expectedRows) {
        CFMetaData cfm = DatabaseDescriptor.getCFMetaData(tableName, columnFamilyName);
        double v = cfm == null ? 0.0 : cfm.getRowCacheSize();
        return (int)Math.min(FBUtilities.absoluteFromFraction(v, expectedRows), Integer.MAX_VALUE);
    }

    public static KSMetaData getTableDefinition(String table) {
        return tables.get(table);
    }

    public static void setTableDefinition(KSMetaData ksm, UUID newVersion) {
        if (ksm != null) {
            tables.put(ksm.name, ksm);
        }
        defsVersion = newVersion;
    }

    public static void clearTableDefinition(KSMetaData ksm, UUID newVersion) {
        tables.remove(ksm.name);
        defsVersion = newVersion;
    }

    public static UUID getDefsVersion() {
        return defsVersion;
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static Integer getRpcMinThreads() {
        return DatabaseDescriptor.conf.rpc_min_threads;
    }

    public static Integer getRpcMaxThreads() {
        return DatabaseDescriptor.conf.rpc_max_threads;
    }

    public static Integer getRpcSendBufferSize() {
        return DatabaseDescriptor.conf.rpc_send_buff_size_in_bytes;
    }

    public static Integer getRpcRecvBufferSize() {
        return DatabaseDescriptor.conf.rpc_recv_buff_size_in_bytes;
    }

    public static double getCommitLogSyncBatchWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period_in_ms;
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    public static int getIndexedReadBufferSizeInKB() {
        return DatabaseDescriptor.conf.column_index_size_in_kb;
    }

    public static int getSlicedReadBufferSizeInKB() {
        return DatabaseDescriptor.conf.sliced_buffer_size_in_kb;
    }

    public static int getBMTThreshold() {
        return DatabaseDescriptor.conf.binary_memtable_throughput_in_mb;
    }

    public static int getCompactionThreadPriority() {
        return DatabaseDescriptor.conf.compaction_thread_priority;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoBootstrap() {
        return DatabaseDescriptor.conf.auto_bootstrap;
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled;
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window_in_ms;
    }

    public static AbstractType getValueValidator(String keyspace, String cf, ByteBuffer column) {
        return DatabaseDescriptor.getCFMetaData(keyspace, cf).getValueValidator(column);
    }

    public static CFMetaData getCFMetaData(Descriptor desc) {
        return DatabaseDescriptor.getCFMetaData(desc.ksname, desc.cfname);
    }

    public static Integer getIndexInterval() {
        return DatabaseDescriptor.conf.index_interval;
    }

    public static File getSerializedRowCachePath(String ksName, String cfName) {
        return new File(DatabaseDescriptor.conf.saved_caches_directory + File.separator + ksName + "-" + cfName + "-RowCache");
    }

    public static File getSerializedKeyCachePath(String ksName, String cfName) {
        return new File(DatabaseDescriptor.conf.saved_caches_directory + File.separator + ksName + "-" + cfName + "-KeyCache");
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms;
    }

    public static void setDynamicUpdateInterval(Integer dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms = dynamicUpdateInterval;
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms;
    }

    public static void setDynamicResetInterval(Integer dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms = dynamicResetInterval;
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(Double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static double getFlushLargestMemtablesAt() {
        return DatabaseDescriptor.conf.flush_largest_memtables_at;
    }

    public static double getReduceCacheSizesAt() {
        return DatabaseDescriptor.conf.reduce_cache_sizes_at;
    }

    public static double getReduceCacheCapacityTo() {
        return DatabaseDescriptor.conf.reduce_cache_capacity_to;
    }

    public static int getHintedHandoffThrottleDelay() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle_delay_in_ms;
    }

    public static boolean getPreheatKeyCache() {
        return DatabaseDescriptor.conf.compaction_preheat_key_cache;
    }

    public static void validateMemtableThroughput(int sizeInMB) throws ConfigurationException {
        if (sizeInMB <= 0) {
            throw new ConfigurationException("memtable_throughput_in_mb must be greater than 0.");
        }
    }

    public static void validateMemtableOperations(double operationsInMillions) throws ConfigurationException {
        if (operationsInMillions <= 0.0) {
            throw new ConfigurationException("memtable_operations_in_millions must be greater than 0.0.");
        }
        if (operationsInMillions > 9.223372036854775E18) {
            throw new ConfigurationException("memtable_operations_in_millions must be less than 9223372036854774784");
        }
    }

    public static void validateMemtableFlushPeriod(int minutes) throws ConfigurationException {
        if (minutes <= 0) {
            throw new ConfigurationException("memtable_flush_after_mins must be greater than 0.");
        }
    }

    public static boolean incrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static int getFlushQueueSize() {
        return DatabaseDescriptor.conf.memtable_flush_queue_size;
    }

    static {
        seeds = new HashSet<InetAddress>();
        currentIndex = 0;
        tables = new HashMap<String, KSMetaData>();
        authenticator = new AllowAllAuthenticator();
        authority = new AllowAllAuthority();
        defsVersion = INITIAL_VERSION = new UUID(4096L, 0L);
        try {
            URL url = DatabaseDescriptor.getStorageConfigURL();
            logger.info("Loading settings from " + url);
            InputStream input = null;
            try {
                input = url.openStream();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Constructor constructor = new Constructor(Config.class);
            TypeDescription desc = new TypeDescription(Config.class);
            desc.putListPropertyType("keyspaces", RawKeyspace.class);
            TypeDescription ksDesc = new TypeDescription(RawKeyspace.class);
            ksDesc.putListPropertyType("column_families", RawColumnFamily.class);
            TypeDescription cfDesc = new TypeDescription(RawColumnFamily.class);
            cfDesc.putListPropertyType("column_metadata", RawColumnDefinition.class);
            constructor.addTypeDescription(desc);
            constructor.addTypeDescription(ksDesc);
            constructor.addTypeDescription(cfDesc);
            Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
            conf = (Config)yaml.load(input);
            if (DatabaseDescriptor.conf.commitlog_sync == null) {
                throw new ConfigurationException("Missing required directive CommitLogSync");
            }
            if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
                if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms == null) {
                    throw new ConfigurationException("Missing value for commitlog_sync_batch_window_in_ms: Double expected.");
                }
                if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != null) {
                    throw new ConfigurationException("Batch sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_batch_window_in_ms when using batch sync");
                }
                logger.debug("Syncing log with a batch window of " + DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms);
            } else {
                if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms == null) {
                    throw new ConfigurationException("Missing value for commitlog_sync_period_in_ms: Integer expected");
                }
                if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms != null) {
                    throw new ConfigurationException("commitlog_sync_period_in_ms specified, but commitlog_sync_batch_window_in_ms found.  Only specify commitlog_sync_period_in_ms when using periodic sync.");
                }
                logger.debug("Syncing log with a period of " + DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
            }
            if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
                indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = System.getProperty("os.arch").contains("64") ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
                logger.info("DiskAccessMode 'auto' determined to be " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
                DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
                indexAccessMode = Config.DiskAccessMode.mmap;
                logger.info("DiskAccessMode is " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            } else {
                indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
                logger.info("DiskAccessMode is " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            }
            if (DatabaseDescriptor.conf.authenticator != null) {
                authenticator = (IAuthenticator)FBUtilities.construct(DatabaseDescriptor.conf.authenticator, "authenticator");
            }
            if (DatabaseDescriptor.conf.authority != null) {
                authority = (IAuthority)FBUtilities.construct(DatabaseDescriptor.conf.authority, "authority");
            }
            authenticator.validateConfiguration();
            authority.validateConfiguration();
            if (DatabaseDescriptor.conf.partitioner == null) {
                throw new ConfigurationException("Missing directive: partitioner");
            }
            try {
                partitioner = FBUtilities.newPartitioner(DatabaseDescriptor.conf.partitioner);
            }
            catch (Exception e) {
                throw new ConfigurationException("Invalid partitioner class " + DatabaseDescriptor.conf.partitioner);
            }
            if (DatabaseDescriptor.conf.phi_convict_threshold < 5 || DatabaseDescriptor.conf.phi_convict_threshold > 16) {
                throw new ConfigurationException("phi_convict_threshold must be between 5 and 16");
            }
            if (DatabaseDescriptor.conf.concurrent_reads != null && DatabaseDescriptor.conf.concurrent_reads < 2) {
                throw new ConfigurationException("concurrent_reads must be at least 2");
            }
            if (DatabaseDescriptor.conf.concurrent_writes != null && DatabaseDescriptor.conf.concurrent_writes < 2) {
                throw new ConfigurationException("concurrent_writes must be at least 2");
            }
            if (DatabaseDescriptor.conf.memtable_flush_writers != null && DatabaseDescriptor.conf.memtable_flush_writers < 1) {
                throw new ConfigurationException("memtable_flush_writers must be at least 1");
            }
            if (DatabaseDescriptor.conf.memtable_flush_writers == null) {
                DatabaseDescriptor.conf.memtable_flush_writers = DatabaseDescriptor.conf.data_file_directories.length;
            }
            if (DatabaseDescriptor.conf.listen_address != null) {
                if (DatabaseDescriptor.conf.listen_address.equals("0.0.0.0")) {
                    throw new ConfigurationException("listen_address must be a single interface.  See http://wiki.apache.org/cassandra/FAQ#cant_listen_on_ip_any");
                }
                try {
                    listenAddress = InetAddress.getByName(DatabaseDescriptor.conf.listen_address);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown listen_address '" + DatabaseDescriptor.conf.listen_address + "'");
                }
            }
            if (DatabaseDescriptor.conf.rpc_address != null) {
                try {
                    rpcAddress = InetAddress.getByName(DatabaseDescriptor.conf.rpc_address);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown host in rpc_address " + DatabaseDescriptor.conf.rpc_address);
                }
            }
            if (DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb > 0 && DatabaseDescriptor.conf.thrift_max_message_length_in_mb < DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb) {
                throw new ConfigurationException("thrift_max_message_length_in_mb must be greater than thrift_framed_transport_size_in_mb when using TFramedTransport");
            }
            if (DatabaseDescriptor.conf.compaction_thread_priority < 1 || DatabaseDescriptor.conf.compaction_thread_priority > 5) {
                throw new ConfigurationException("compaction_thread_priority must be between 1 and 5");
            }
            if (DatabaseDescriptor.conf.endpoint_snitch == null) {
                throw new ConfigurationException("Missing endpoint_snitch directive");
            }
            snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.endpoint_snitch);
            EndpointSnitchInfo.create();
            requestSchedulerOptions = DatabaseDescriptor.conf.request_scheduler_options;
            if (DatabaseDescriptor.conf.request_scheduler != null) {
                try {
                    if (requestSchedulerOptions == null) {
                        requestSchedulerOptions = new RequestSchedulerOptions();
                    }
                    Class<?> cls = Class.forName(DatabaseDescriptor.conf.request_scheduler);
                    requestScheduler = (IRequestScheduler)cls.getConstructor(RequestSchedulerOptions.class).newInstance(requestSchedulerOptions);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Invalid Request Scheduler class " + DatabaseDescriptor.conf.request_scheduler);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to instantiate request scheduler", e);
                }
            } else {
                requestScheduler = new NoScheduler();
            }
            requestSchedulerId = DatabaseDescriptor.conf.request_scheduler_id == Config.RequestSchedulerId.keyspace ? DatabaseDescriptor.conf.request_scheduler_id : Config.RequestSchedulerId.keyspace;
            if (logger.isDebugEnabled() && DatabaseDescriptor.conf.auto_bootstrap != null) {
                logger.debug("setting auto_bootstrap to " + DatabaseDescriptor.conf.auto_bootstrap);
            }
            if (DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb != null && DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb <= 0) {
                throw new ConfigurationException("in_memory_compaction_limit_in_mb must be a positive integer");
            }
            if (DatabaseDescriptor.conf.commitlog_directory != null && DatabaseDescriptor.conf.data_file_directories != null && DatabaseDescriptor.conf.saved_caches_directory != null) {
                for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
                    if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                        throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories");
                    }
                    if (!datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) continue;
                    throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories");
                }
                if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                    throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory");
                }
            } else {
                if (DatabaseDescriptor.conf.commitlog_directory == null) {
                    throw new ConfigurationException("commitlog_directory missing");
                }
                if (DatabaseDescriptor.conf.data_file_directories == null) {
                    throw new ConfigurationException("data_file_directories missing; at least one data directory must be specified");
                }
                if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                    throw new ConfigurationException("saved_caches_directory missing");
                }
            }
            if (DatabaseDescriptor.conf.initial_token != null) {
                partitioner.getTokenFactory().validate(DatabaseDescriptor.conf.initial_token);
            }
            KSMetaData systemMeta = new KSMetaData("system", LocalStrategy.class, null, 1, CFMetaData.StatusCf, CFMetaData.HintsCf, CFMetaData.MigrationsCf, CFMetaData.SchemaCf, CFMetaData.IndexCf);
            CFMetaData.map(CFMetaData.StatusCf);
            CFMetaData.map(CFMetaData.HintsCf);
            CFMetaData.map(CFMetaData.MigrationsCf);
            CFMetaData.map(CFMetaData.SchemaCf);
            CFMetaData.map(CFMetaData.IndexCf);
            tables.put("system", systemMeta);
            if (DatabaseDescriptor.conf.seeds == null || DatabaseDescriptor.conf.seeds.length <= 0) {
                throw new ConfigurationException("seeds missing; a minimum of one seed is required.");
            }
            for (String seedString : DatabaseDescriptor.conf.seeds) {
                try {
                    seeds.add(InetAddress.getByName(seedString));
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown seed " + seedString + ".  Consider using IP addresses instead of host names");
                }
            }
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        catch (YAMLException e) {
            logger.error("Fatal configuration error error", (Throwable)e);
            System.err.println(e.getMessage() + "\nInvalid yaml; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
    }
}

