/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class AddColumnFamily
extends Migration {
    private CFMetaData cfm;

    protected AddColumnFamily() {
    }

    public AddColumnFamily(CFMetaData cfm) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.cfm = cfm;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(cfm.tableName);
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not already exist.");
        }
        if (ksm.cfMetaData().containsKey(cfm.cfName)) {
            throw new ConfigurationException("CF is already defined in that keyspace.");
        }
        if (!Migration.isLegalName(cfm.cfName)) {
            throw new ConfigurationException("Invalid column family name: " + cfm.cfName);
        }
        for (Map.Entry<ByteBuffer, ColumnDefinition> entry : cfm.getColumn_metadata().entrySet()) {
            String indexName = entry.getValue().getIndexName();
            if (indexName == null || Migration.isLegalName(indexName)) continue;
            throw new ConfigurationException("Invalid index name: " + indexName);
        }
        KSMetaData newKsm = this.makeNewKeyspaceDefinition(ksm);
        this.rm = Migration.makeDefinitionMutation(newKsm, null, this.newVersion);
    }

    private KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm) {
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.add(this.cfm);
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.replicationFactor, newCfs.toArray(new CFMetaData[newCfs.size()]));
    }

    @Override
    public void applyModels() throws IOException {
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(this.cfm.tableName);
        ksm = this.makeNewKeyspaceDefinition(ksm);
        try {
            CFMetaData.map(this.cfm);
        }
        catch (ConfigurationException ex) {
            throw new IOException(ex);
        }
        Table.open(this.cfm.tableName);
        DatabaseDescriptor.setTableDefinition(ksm, this.newVersion);
        CFMetaData.fixMaxId();
        if (!this.clientMode) {
            Table.open(ksm.name).initCf(this.cfm.cfId, this.cfm.cfName);
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddColumnFamily acf = new org.apache.cassandra.db.migration.avro.AddColumnFamily();
        acf.cf = this.cfm.deflate();
        mi.migration = acf;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddColumnFamily acf = (org.apache.cassandra.db.migration.avro.AddColumnFamily)((Object)mi.migration);
        this.cfm = CFMetaData.inflate(acf.cf);
    }

    public String toString() {
        return "Add column family: " + this.cfm.toString();
    }
}

