/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.GuidGenerator;
import org.apache.cassandra.utils.Pair;

public class RandomPartitioner
implements IPartitioner<BigIntegerToken> {
    public static final BigInteger ZERO = new BigInteger("0");
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("-1");
    private static final byte DELIMITER_BYTE = ":".getBytes()[0];
    private final Token.TokenFactory<BigInteger> tokenFactory = new Token.TokenFactory<BigInteger>(){

        @Override
        public ByteBuffer toByteArray(Token<BigInteger> bigIntegerToken) {
            return ByteBuffer.wrap(((BigInteger)bigIntegerToken.token).toByteArray());
        }

        @Override
        public Token<BigInteger> fromByteArray(ByteBuffer bytes) {
            return new BigIntegerToken(new BigInteger(ByteBufferUtil.getArray(bytes)));
        }

        @Override
        public String toString(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                new BigInteger(token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token<BigInteger> fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public DecoratedKey<BigIntegerToken> decorateKey(ByteBuffer key) {
        return new DecoratedKey<BigIntegerToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<BigIntegerToken> convertFromDiskFormat(ByteBuffer fromdisk) {
        int splitPoint = -1;
        for (int i = fromdisk.position(); i < fromdisk.limit(); ++i) {
            if (fromdisk.get(i) != DELIMITER_BYTE) continue;
            splitPoint = i;
            break;
        }
        assert (splitPoint != -1);
        String token = null;
        try {
            token = ByteBufferUtil.string(fromdisk, fromdisk.position(), splitPoint - fromdisk.position());
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer key = fromdisk.duplicate();
        key.position(splitPoint + 1);
        return new DecoratedKey<BigIntegerToken>(new BigIntegerToken(token), key);
    }

    @Override
    public Token midpoint(Token ltoken, Token rtoken) {
        BigInteger left = ltoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)ltoken).token;
        BigInteger right = rtoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)rtoken).token;
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 127);
        return new BigIntegerToken((BigInteger)midpair.left);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getRandomToken() {
        BigInteger token = FBUtilities.hashToBigInteger(GuidGenerator.guidAsBytes());
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public Token.TokenFactory<BigInteger> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BigIntegerToken(FBUtilities.hashToBigInteger(key));
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. How did you call this?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            float x;
            BigInteger ti;
            BigInteger ri = new BigInteger("2").pow(127);
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = (BigInteger)((BigIntegerToken)start).token;
            while (i.hasNext()) {
                Token t = i.next();
                ti = (BigInteger)((BigIntegerToken)t).token;
                x = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r).floatValue();
                ownerships.put(t, Float.valueOf(x));
                tim1 = ti;
            }
            x = new BigDecimal(((BigInteger)((BigIntegerToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }
}

