/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;

public class SimpleAuthority
implements IAuthority {
    public static final String ACCESS_FILENAME_PROPERTY = "access.properties";
    public static final String KEYSPACES_WRITE_PROPERTY = "<modify-keyspaces>";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EnumSet<Permission> authorize(AuthenticatedUser user, List<Object> resource) {
        BufferedInputStream in;
        EnumSet<Permission> authorized;
        block20: {
            String keyspace;
            if (resource.size() < 2) return Permission.NONE;
            if (!"cassandra".equals(resource.get(0))) return Permission.NONE;
            if (!"keyspaces".equals(resource.get(1))) {
                return Permission.NONE;
            }
            String columnFamily = null;
            authorized = Permission.NONE;
            if (resource.size() == 2) {
                keyspace = KEYSPACES_WRITE_PROPERTY;
                authorized = EnumSet.of(Permission.READ);
            } else if (resource.size() == 3) {
                keyspace = (String)resource.get(2);
            } else {
                if (resource.size() != 4) throw new UnsupportedOperationException();
                keyspace = (String)resource.get(2);
                columnFamily = (String)resource.get(3);
            }
            String accessFilename = System.getProperty(ACCESS_FILENAME_PROPERTY);
            in = null;
            try {
                String writers;
                boolean canWrite;
                boolean canRead;
                block21: {
                    int len$;
                    String[] arr$;
                    block22: {
                        block19: {
                            in = new BufferedInputStream(new FileInputStream(accessFilename));
                            Properties accessProperties = new Properties();
                            accessProperties.load(in);
                            if (keyspace == KEYSPACES_WRITE_PROPERTY) {
                                String kspAdmins = accessProperties.getProperty(KEYSPACES_WRITE_PROPERTY);
                                for (String admin : kspAdmins.split(",")) {
                                    if (!admin.equals(user.username)) {
                                        continue;
                                    }
                                    break block19;
                                }
                            }
                            canRead = false;
                            canWrite = false;
                            String readers = null;
                            writers = null;
                            if (columnFamily == null) {
                                readers = accessProperties.getProperty(keyspace + ".<ro>");
                                writers = accessProperties.getProperty(keyspace + ".<rw>");
                            } else {
                                readers = accessProperties.getProperty(keyspace + "." + columnFamily + ".<ro>");
                                writers = accessProperties.getProperty(keyspace + "." + columnFamily + ".<rw>");
                            }
                            if (readers == null) break block21;
                            arr$ = readers.split(",");
                            len$ = arr$.length;
                            break block22;
                        }
                        EnumSet<Permission> enumSet = Permission.ALL;
                        FileUtils.closeQuietly(in);
                        return enumSet;
                    }
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String reader = arr$[i$];
                        if (!reader.equals(user.username)) continue;
                        canRead = true;
                        break;
                    }
                }
                if (writers != null) {
                    for (String writer : writers.split(",")) {
                        if (!writer.equals(user.username)) continue;
                        canWrite = true;
                        break;
                    }
                }
                if (canWrite) {
                    authorized = Permission.ALL;
                    break block20;
                }
                if (!canRead) break block20;
                authorized = EnumSet.of(Permission.READ);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(String.format("Authorization table file '%s' could not be opened: %s", accessFilename, e.getMessage()));
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    throw throwable;
                }
            }
        }
        FileUtils.closeQuietly(in);
        return authorized;
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        String afilename = System.getProperty(ACCESS_FILENAME_PROPERTY);
        if (afilename == null) {
            throw new ConfigurationException(String.format("When using %s, '%s' property must be defined.", this.getClass().getCanonicalName(), ACCESS_FILENAME_PROPERTY));
        }
    }
}

