/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql.jdbc.AbstractJdbcUUID;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.UUIDGen;

public class JdbcTimeUUID
extends AbstractJdbcUUID {
    public static final JdbcTimeUUID instance = new JdbcTimeUUID();

    JdbcTimeUUID() {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        UUID uuid = UUIDGen.getUUID(bytes);
        if (uuid.version() != 1) {
            throw new MarshalException("TimeUUID only makes sense with version 1 UUIDs");
        }
        return uuid.toString();
    }

    @Override
    public UUID compose(ByteBuffer bytes) {
        return UUIDGen.getUUID(bytes);
    }
}

