/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.ArrivalWindow;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureDetector
implements IFailureDetector,
FailureDetectorMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=FailureDetector";
    public static final IFailureDetector instance = new FailureDetector();
    private static Logger logger_ = LoggerFactory.getLogger(FailureDetector.class);
    private static final int sampleSize_ = 1000;
    private static int phiConvictThreshold_;
    private Map<InetAddress, ArrivalWindow> arrivalSamples_ = new Hashtable<InetAddress, ArrivalWindow>();
    private List<IFailureDetectionEventListener> fdEvntListeners_ = new ArrayList<IFailureDetectionEventListener>();

    public FailureDetector() {
        phiConvictThreshold_ = DatabaseDescriptor.getPhiConvictThreshold();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAllEndpointStates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<InetAddress, EndpointState> entry : Gossiper.instance.endpointStateMap.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            this.appendEndpointState(sb, entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getSimpleStates() {
        HashMap<String, String> nodesStatus = new HashMap<String, String>(Gossiper.instance.endpointStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (entry.getValue().isAlive()) {
                nodesStatus.put(entry.getKey().toString(), "UP");
                continue;
            }
            nodesStatus.put(entry.getKey().toString(), "DOWN");
        }
        return nodesStatus;
    }

    @Override
    public String getEndpointState(String address) throws UnknownHostException {
        StringBuilder sb = new StringBuilder();
        EndpointState endpointState = Gossiper.instance.getEndpointStateForEndpoint(InetAddress.getByName(address));
        this.appendEndpointState(sb, endpointState);
        return sb.toString();
    }

    private void appendEndpointState(StringBuilder sb, EndpointState endpointState) {
        for (Map.Entry<ApplicationState, VersionedValue> state : endpointState.applicationState.entrySet()) {
            sb.append("  ").append((Object)state.getKey()).append(":").append(state.getValue().value).append("\n");
        }
    }

    @Override
    public void dumpInterArrivalTimes() {
        BufferedOutputStream os = null;
        try {
            File file = File.createTempFile("failuredetector-", ".dat");
            os = new BufferedOutputStream(new FileOutputStream(file, true));
            ((OutputStream)os).write(this.toString().getBytes());
        }
        catch (IOException e) {
            try {
                throw new IOError(e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(os);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(os);
    }

    @Override
    public void setPhiConvictThreshold(int phi) {
        phiConvictThreshold_ = phi;
    }

    @Override
    public int getPhiConvictThreshold() {
        return phiConvictThreshold_;
    }

    @Override
    public boolean isAlive(InetAddress ep) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            return true;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
        if (epState == null) {
            logger_.error("unknown endpoint " + ep);
        }
        return epState != null && epState.isAlive();
    }

    @Override
    public void report(InetAddress ep) {
        if (logger_.isTraceEnabled()) {
            logger_.trace("reporting {}", (Object)ep);
        }
        long now = System.currentTimeMillis();
        ArrivalWindow heartbeatWindow = this.arrivalSamples_.get(ep);
        if (heartbeatWindow == null) {
            heartbeatWindow = new ArrivalWindow(1000);
            this.arrivalSamples_.put(ep, heartbeatWindow);
        }
        heartbeatWindow.add(now);
    }

    @Override
    public void interpret(InetAddress ep) {
        ArrivalWindow hbWnd = this.arrivalSamples_.get(ep);
        if (hbWnd == null) {
            return;
        }
        long now = System.currentTimeMillis();
        double phi = hbWnd.phi(now);
        if (logger_.isTraceEnabled()) {
            logger_.trace("PHI for " + ep + " : " + phi);
        }
        if (phi > (double)phiConvictThreshold_) {
            for (IFailureDetectionEventListener listener : this.fdEvntListeners_) {
                listener.convict(ep, phi);
            }
        }
    }

    @Override
    public void remove(InetAddress ep) {
        this.arrivalSamples_.remove(ep);
    }

    @Override
    public void registerFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.add(listener);
    }

    @Override
    public void unregisterFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.remove(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<InetAddress> eps = this.arrivalSamples_.keySet();
        sb.append("-----------------------------------------------------------------------");
        for (InetAddress ep : eps) {
            ArrivalWindow hWnd = this.arrivalSamples_.get(ep);
            sb.append(ep + " : ");
            sb.append(hWnd.toString());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("-----------------------------------------------------------------------");
        return sb.toString();
    }

    public static void main(String[] args) throws Throwable {
    }
}

