/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.StressAction;
import org.apache.commons.cli.Option;

public final class Stress {
    public static Session session;
    public static Random randomizer;
    private static volatile boolean stopped;

    public static void main(String[] arguments) throws Exception {
        try {
            session = new Session(arguments);
        }
        catch (IllegalArgumentException e) {
            Stress.printHelpMessage();
            return;
        }
        PrintStream outStream = session.getOutputStream();
        if (Stress.session.sendToDaemon != null) {
            BufferedReader inp;
            ObjectOutputStream out;
            Socket socket;
            block8: {
                socket = new Socket(Stress.session.sendToDaemon, 2159);
                out = new ObjectOutputStream(socket.getOutputStream());
                inp = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                Runtime.getRuntime().addShutdownHook(new ShutDown(socket, out));
                out.writeObject(session);
                try {
                    String line;
                    while (!socket.isClosed() && (line = inp.readLine()) != null) {
                        if (line.equals("END") || line.equals("FAILURE")) {
                            out.writeInt(1);
                            break;
                        }
                        outStream.println(line);
                    }
                }
                catch (SocketException e) {
                    if (stopped) break block8;
                    e.printStackTrace();
                }
            }
            out.close();
            inp.close();
            socket.close();
        } else {
            StressAction stressAction = new StressAction(session, outStream);
            stressAction.start();
            stressAction.join();
            System.exit(stressAction.getReturnCode());
        }
    }

    public static void printHelpMessage() {
        System.out.println("Usage: ./bin/cassandra-stress [options]\n\nOptions:");
        for (Object o : Session.availableOptions.getOptions()) {
            Option option = (Option)o;
            String upperCaseName = option.getLongOpt().toUpperCase();
            System.out.println(String.format("-%s%s, --%s%s%n\t\t%s%n", option.getOpt(), option.hasArg() ? " " + upperCaseName : "", option.getLongOpt(), option.hasArg() ? "=" + upperCaseName : "", option.getDescription()));
        }
    }

    static {
        randomizer = new Random();
        stopped = false;
    }

    private static class ShutDown
    extends Thread {
        private final Socket socket;
        private final ObjectOutputStream out;

        public ShutDown(Socket socket, ObjectOutputStream out) {
            this.out = out;
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                if (!this.socket.isClosed()) {
                    System.out.println("Control-C caught. Canceling running action and shutting down...");
                    this.out.writeInt(1);
                    this.out.close();
                    stopped = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Operations {
        INSERT,
        READ,
        RANGE_SLICE,
        INDEXED_RANGE_SLICE,
        MULTI_GET,
        COUNTER_ADD,
        COUNTER_GET;

    }
}

