/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.yammer.metrics.stats.Snapshot;
import java.io.PrintStream;
import org.apache.cassandra.stress.Session;
import org.apache.commons.lang.time.DurationFormatUtils;

public class StressStatistics {
    private Session client;
    private PrintStream output;
    private long durationInSeconds;
    private int tallyOpRateSum;
    private int tallyOpRateCount;
    private int tallyKeyRateSum;
    private int tallyKeyRateCount;
    private double tallyLatencySum;
    private int tallyLatencyCount;
    private double tally95thLatencySum;
    private int tally95thLatencyCount;
    private double tally999thLatencySum;
    private int tally999thLatencyCount;

    public StressStatistics(Session client, PrintStream out) {
        this.client = client;
        this.output = out;
        this.tallyOpRateSum = 0;
        this.tallyOpRateCount = 0;
    }

    public void addIntervalStats(int totalOperations, int intervalOpRate, int intervalKeyRate, Snapshot latency, long currentTimeInSeconds) {
        this.tallyAverages(totalOperations, intervalKeyRate, intervalKeyRate, latency, currentTimeInSeconds);
    }

    private void tallyAverages(int totalOperations, int intervalOpRate, int intervalKeyRate, Snapshot latency, long currentTimeInSeconds) {
        if ((double)totalOperations > 0.1 * (double)this.client.getNumKeys() && (double)totalOperations < 0.9 * (double)this.client.getNumKeys()) {
            this.tallyOpRateSum += intervalOpRate;
            ++this.tallyOpRateCount;
            this.tallyKeyRateSum += intervalKeyRate;
            ++this.tallyKeyRateCount;
            this.tallyLatencySum += latency.getMedian();
            ++this.tallyLatencyCount;
            this.tally95thLatencySum += latency.get95thPercentile();
            ++this.tally95thLatencyCount;
            this.tally999thLatencySum += latency.get999thPercentile();
            ++this.tally999thLatencyCount;
        }
        this.durationInSeconds = currentTimeInSeconds;
    }

    public void printStats() {
        this.output.println("\n");
        if (this.tallyOpRateCount > 0) {
            this.output.println("Averages from the middle 80% of values:");
            this.output.println(String.format("interval_op_rate          : %d", this.tallyOpRateSum / this.tallyOpRateCount));
            this.output.println(String.format("interval_key_rate         : %d", this.tallyKeyRateSum / this.tallyKeyRateCount));
            this.output.println(String.format("latency median            : %.1f", this.tallyLatencySum / (double)this.tallyLatencyCount));
            this.output.println(String.format("latency 95th percentile   : %.1f", this.tally95thLatencySum / (double)this.tally95thLatencyCount));
            this.output.println(String.format("latency 99.9th percentile : %.1f", this.tally999thLatencySum / (double)this.tally999thLatencyCount));
        }
        this.output.println("Total operation time      : " + DurationFormatUtils.formatDuration((long)(this.durationInSeconds * 1000L), (String)"HH:mm:ss", (boolean)true));
    }
}

