/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.ByteBufferUtil;

public class RangeSlicer
extends Operation {
    public RangeSlicer(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        int count = this.session.getColumnsPerKey();
        SlicePredicate predicate = new SlicePredicate().setSlice_range(new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, count));
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            ByteBuffer start = ByteBufferUtil.bytes((String)String.format(format, this.index));
            List slices = new ArrayList();
            KeyRange range = new KeyRange(count).setStart_key(start).setEnd_key(ByteBufferUtil.EMPTY_BYTE_BUFFER);
            for (int i = 0; i < this.session.getSuperColumns(); ++i) {
                String superColumnName = "S" + Integer.toString(i);
                ColumnParent parent = new ColumnParent("Super1").setSuper_column(ByteBufferUtil.bytes((String)superColumnName));
                TimerContext context = this.session.latency.time();
                boolean success = false;
                String exceptionMessage = null;
                for (int t = 0; t < this.session.getRetryTimes(); ++t) {
                    try {
                        slices = client.get_range_slices(parent, predicate, range, this.session.getConsistencyLevel());
                        success = slices.size() != 0;
                        continue;
                    }
                    catch (Exception e) {
                        exceptionMessage = this.getExceptionMessage(e);
                        success = false;
                    }
                }
                if (!success) {
                    this.error(String.format("Operation [%d] retried %d times - error on calling get_range_slices for range offset %s %s%n", this.index, this.session.getRetryTimes(), ByteBufferUtil.string((ByteBuffer)start), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
                }
                this.session.operations.getAndIncrement();
                context.stop();
            }
            this.session.keys.getAndAdd(slices.size());
        } else {
            ColumnParent parent = new ColumnParent("Standard1");
            ByteBuffer start = ByteBufferUtil.bytes((String)String.format(format, this.index));
            List slices = new ArrayList();
            KeyRange range = new KeyRange(count).setStart_key(start).setEnd_key(ByteBufferUtil.EMPTY_BYTE_BUFFER);
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    slices = client.get_range_slices(parent, predicate, range, this.session.getConsistencyLevel());
                    success = slices.size() != 0;
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error on calling get_indexed_slices for range offset %s %s%n", this.index, this.session.getRetryTimes(), ByteBufferUtil.string((ByteBuffer)start), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            this.session.operations.getAndIncrement();
            this.session.keys.getAndAdd(slices.size());
            context.stop();
        }
    }
}

