/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.Stress;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.transport.SimpleClient;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.UUIDGen;

public abstract class Operation {
    public final int index;
    protected final Session session;
    protected static volatile Double nextGaussian = null;
    private static final Map<Integer, byte[]> preparedStatementsNative = new HashMap<Integer, byte[]>();

    public Operation(int idx) {
        this.index = idx;
        this.session = Stress.session;
    }

    public Operation(Session client, int idx) {
        this.index = idx;
        this.session = client;
    }

    public abstract void run(CassandraClient var1) throws IOException;

    public void run(SimpleClient client) throws IOException {
    }

    protected List<ByteBuffer> generateValues() {
        if (this.session.averageSizeValues) {
            return this.generateRandomizedValues();
        }
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
        for (int i = 0; i < this.session.getCardinality(); ++i) {
            String hash = this.getMD5(Integer.toString(i));
            int times = this.session.getColumnSize() / hash.length();
            int sumReminder = this.session.getColumnSize() % hash.length();
            String value = this.multiplyString(hash, times) + hash.substring(0, sumReminder);
            values.add(ByteBuffer.wrap(value.getBytes()));
        }
        return values;
    }

    protected List<ByteBuffer> generateRandomizedValues() {
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
        int limit = 2 * this.session.getColumnSize();
        for (int i = 0; i < this.session.getCardinality(); ++i) {
            byte[] value = new byte[Stress.randomizer.nextInt(limit)];
            Stress.randomizer.nextBytes(value);
            values.add(ByteBuffer.wrap(value));
        }
        return values;
    }

    protected byte[] generateKey() {
        return this.session.useRandomGenerator() ? this.generateRandomKey() : this.generateGaussKey();
    }

    private byte[] generateRandomKey() {
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        return String.format(format, Stress.randomizer.nextInt(Stress.session.getNumDifferentKeys() - 1)).getBytes(Charsets.UTF_8);
    }

    private byte[] generateGaussKey() {
        double token;
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        while (!(0.0 <= (token = Operation.nextGaussian(this.session.getMean(), this.session.getSigma()))) || !(token < (double)this.session.getNumDifferentKeys())) {
        }
        return String.format(format, (int)token).getBytes(Charsets.UTF_8);
    }

    private static double nextGaussian(int mu, float sigma) {
        Random random = Stress.randomizer;
        Double currentState = nextGaussian;
        nextGaussian = null;
        if (currentState == null) {
            double x2pi = random.nextDouble() * 2.0 * Math.PI;
            double g2rad = Math.sqrt(-2.0 * Math.log(1.0 - random.nextDouble()));
            currentState = Math.cos(x2pi) * g2rad;
            nextGaussian = Math.sin(x2pi) * g2rad;
        }
        return (double)mu + currentState * (double)sigma;
    }

    private String getMD5(String input) {
        MessageDigest md = FBUtilities.threadLocalMD5Digest();
        byte[] messageDigest = md.digest(input.getBytes(Charsets.UTF_8));
        StringBuilder hash = new StringBuilder(new BigInteger(1, messageDigest).toString(16));
        while (hash.length() < 32) {
            hash.append("0").append((CharSequence)hash);
        }
        return hash.toString();
    }

    private String multiplyString(String str, int times) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    protected ByteBuffer columnName(int index, boolean timeUUIDComparator) {
        return timeUUIDComparator ? TimeUUIDType.instance.decompose((Object)UUIDGen.getTimeUUID()) : ByteBufferUtil.bytes((String)String.format("C%d", index));
    }

    protected String getExceptionMessage(Exception e) {
        String className = e.getClass().getSimpleName();
        String message = e instanceof InvalidRequestException ? ((InvalidRequestException)((Object)e)).getWhy() : e.getMessage();
        return message == null ? "(" + className + ")" : String.format("(%s): %s", className, message);
    }

    protected void error(String message) throws IOException {
        if (!this.session.ignoreErrors()) {
            throw new IOException(message);
        }
        System.err.println(message);
    }

    protected String getUnQuotedCqlBlob(String term, boolean isCQL3) {
        return this.getUnQuotedCqlBlob(term.getBytes(), isCQL3);
    }

    protected String getUnQuotedCqlBlob(byte[] term, boolean isCQL3) {
        return isCQL3 ? "0x" + Hex.bytesToHex((byte[])term) : Hex.bytesToHex((byte[])term);
    }

    protected List<ByteBuffer> queryParamsAsByteBuffer(List<String> queryParams) {
        return Lists.transform(queryParams, (Function)new Function<String, ByteBuffer>(){

            public ByteBuffer apply(String param) {
                if (param.startsWith("0x")) {
                    param = param.substring(2);
                }
                return ByteBufferUtil.hexToBytes((String)param);
            }
        });
    }

    protected static String formatCqlQuery(String query, List<String> parms) {
        int position = 0;
        StringBuilder result = new StringBuilder();
        int marker = query.indexOf(63);
        if (-1 == marker || parms.size() == 0) {
            return query;
        }
        for (String parm : parms) {
            result.append(query.substring(position, marker));
            result.append(parm);
            position = marker + 1;
            if (-1 != (marker = query.indexOf(63, position + 1))) continue;
            break;
        }
        if (position < query.length()) {
            result.append(query.substring(position));
        }
        return result.toString();
    }

    protected Integer getPreparedStatement(CassandraClient client, String cqlQuery) throws Exception {
        Integer statementId = client.preparedStatements.get(cqlQuery.hashCode());
        if (statementId == null) {
            CqlPreparedResult response = this.session.cqlVersion.startsWith("3") ? client.prepare_cql3_query(ByteBufferUtil.bytes((String)cqlQuery), Compression.NONE) : client.prepare_cql_query(ByteBufferUtil.bytes((String)cqlQuery), Compression.NONE);
            statementId = response.itemId;
            client.preparedStatements.put(cqlQuery.hashCode(), statementId);
        }
        return statementId;
    }

    protected static byte[] getPreparedStatement(SimpleClient client, String cqlQuery) throws Exception {
        byte[] statementId = preparedStatementsNative.get(cqlQuery.hashCode());
        if (statementId == null) {
            statementId = client.prepare((String)cqlQuery).statementId.bytes;
            preparedStatementsNative.put(cqlQuery.hashCode(), statementId);
        }
        return statementId;
    }

    protected String wrapInQuotesIfRequired(String string) {
        return this.session.cqlVersion.startsWith("3") ? "\"" + string + "\"" : string;
    }

    public static interface CQLQueryExecutor {
        public boolean execute(String var1, List<String> var2) throws Exception;
    }
}

