/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.Pair;

public class BatchStatement
implements CQLStatement {
    private final int boundTerms;
    public final Type type;
    private final List<ModificationStatement> statements;
    private final Attributes attrs;

    public BatchStatement(int boundTerms, Type type, List<ModificationStatement> statements, Attributes attrs) {
        this.boundTerms = boundTerms;
        this.type = type;
        this.statements = statements;
        this.attrs = attrs;
    }

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.checkAccess(state);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        for (ModificationStatement statement : this.statements) {
            if (!this.attrs.isTimestampSet() || !statement.isTimestampSet()) continue;
            throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
        }
    }

    private Collection<? extends IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        HashMap<Pair<String, ByteBuffer>, IMutation> mutations = new HashMap<Pair<String, ByteBuffer>, IMutation>();
        for (ModificationStatement statement : this.statements) {
            this.addStatementMutations(statement, variables, local, cl, now, mutations);
        }
        return mutations.values();
    }

    private Collection<? extends IMutation> getMutations(List<List<ByteBuffer>> variables, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        HashMap<Pair<String, ByteBuffer>, IMutation> mutations = new HashMap<Pair<String, ByteBuffer>, IMutation>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            List<ByteBuffer> statementVariables = variables.get(i);
            this.addStatementMutations(statement, statementVariables, false, cl, now, mutations);
        }
        return mutations.values();
    }

    private void addStatementMutations(ModificationStatement statement, List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now, Map<Pair<String, ByteBuffer>, IMutation> mutations) throws RequestExecutionException, RequestValidationException {
        for (IMutation iMutation : statement.getMutations(variables, local, cl, this.attrs.getTimestamp(now, variables), true)) {
            Pair<String, ByteBuffer> key = Pair.create(iMutation.getKeyspaceName(), iMutation.key());
            IMutation existing = mutations.get(key);
            if (existing == null) {
                mutations.put(key, iMutation);
                continue;
            }
            existing.addAll(iMutation);
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        this.execute(this.getMutations(options.getValues(), false, options.getConsistency(), queryState.getTimestamp()), options.getConsistency());
        return null;
    }

    public void executeWithPerStatementVariables(ConsistencyLevel cl, QueryState queryState, List<List<ByteBuffer>> variables) throws RequestExecutionException, RequestValidationException {
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        this.execute(this.getMutations(variables, cl, queryState.getTimestamp()), cl);
    }

    private void execute(Collection<? extends IMutation> mutations, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        boolean mutateAtomic = this.type == Type.LOGGED && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic);
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(Collections.emptyList(), true, null, queryState.getTimestamp())) {
            iMutation.apply();
        }
        return null;
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    public static class Parsed
    extends CFStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void prepareKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.prepareKeyspace(state);
            }
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            ColumnSpecification[] boundNames = new ColumnSpecification[this.getBoundsTerms()];
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            for (ModificationStatement.Parsed parsed : this.parsedStatements) {
                ModificationStatement stmt = parsed.prepare(boundNames);
                if (stmt.hasConditions()) {
                    throw new InvalidRequestException("Conditional updates are not allowed in batches");
                }
                if (stmt.isCounter() && this.type != Type.COUNTER) {
                    throw new InvalidRequestException("Counter mutations are only allowed in COUNTER batches");
                }
                if (!stmt.isCounter() && this.type == Type.COUNTER) {
                    throw new InvalidRequestException("Only counter mutations are allowed in COUNTER batches");
                }
                statements.add(stmt);
            }
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(boundNames);
            return new ParsedStatement.Prepared(new BatchStatement(this.getBoundsTerms(), this.type, statements, prepAttrs), Arrays.asList(boundNames));
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

