/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutput out, int version) throws IOException {
        out.writeUTF(sliceCommand.keyspace);
        out.writeUTF(sliceCommand.columnFamily);
        if (version >= 7) {
            out.writeLong(sliceCommand.timestamp);
        }
        IDiskAtomFilter filter = sliceCommand.predicate;
        if (version < 7) {
            Buffer sc = null;
            CFMetaData metadata = Schema.instance.getCFMetaData(sliceCommand.getKeyspace(), sliceCommand.columnFamily);
            if (metadata.cfType == ColumnFamilyType.Super) {
                SuperColumns.SCFilter scFilter = SuperColumns.filterToSC((CompositeType)metadata.comparator, filter);
                sc = scFilter.scName;
                filter = scFilter.updatedFilter;
            }
            out.writeInt(sc == null ? 0 : sc.remaining());
            if (sc != null) {
                ByteBufferUtil.write((ByteBuffer)sc, out);
            }
        }
        IDiskAtomFilter.Serializer.instance.serialize(filter, out, version);
        if (sliceCommand.rowFilter == null) {
            out.writeInt(0);
        } else {
            out.writeInt(sliceCommand.rowFilter.size());
            for (IndexExpression expr : sliceCommand.rowFilter) {
                ByteBufferUtil.writeWithShortLength(expr.column_name, out);
                out.writeInt(expr.op.getValue());
                ByteBufferUtil.writeWithShortLength(expr.value, out);
            }
        }
        AbstractBounds.serializer.serialize(sliceCommand.keyRange, out, version);
        out.writeInt(sliceCommand.maxResults);
        out.writeBoolean(sliceCommand.countCQL3Rows);
        out.writeBoolean(sliceCommand.isPaging);
    }

    @Override
    public RangeSliceCommand deserialize(DataInput in, int version) throws IOException {
        IDiskAtomFilter predicate;
        String keyspace = in.readUTF();
        String columnFamily = in.readUTF();
        long timestamp = version < 7 ? System.currentTimeMillis() : in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily);
        if (version < 7) {
            AbstractType<?> comparator;
            int scLength = in.readInt();
            ByteBuffer superColumn = null;
            if (scLength > 0) {
                byte[] buf = new byte[scLength];
                in.readFully(buf);
                superColumn = ByteBuffer.wrap(buf);
            }
            if (metadata.cfType == ColumnFamilyType.Super) {
                CompositeType type = (CompositeType)metadata.comparator;
                comparator = superColumn == null ? type.types.get(0) : type.types.get(1);
            } else {
                comparator = metadata.comparator;
            }
            predicate = IDiskAtomFilter.Serializer.instance.deserialize(in, version, comparator);
            if (metadata.cfType == ColumnFamilyType.Super) {
                predicate = SuperColumns.fromSCFilter((CompositeType)metadata.comparator, superColumn, predicate);
            }
        } else {
            predicate = IDiskAtomFilter.Serializer.instance.deserialize(in, version, metadata.comparator);
        }
        int filterCount = in.readInt();
        ArrayList<IndexExpression> rowFilter = new ArrayList<IndexExpression>(filterCount);
        for (int i = 0; i < filterCount; ++i) {
            IndexExpression expr = new IndexExpression(ByteBufferUtil.readWithShortLength(in), IndexOperator.findByValue((int)in.readInt()), ByteBufferUtil.readWithShortLength(in));
            rowFilter.add(expr);
        }
        AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
        int maxResults = in.readInt();
        boolean countCQL3Rows = in.readBoolean();
        boolean isPaging = in.readBoolean();
        return new RangeSliceCommand(keyspace, columnFamily, timestamp, predicate, range, rowFilter, maxResults, countCQL3Rows, isPaging);
    }

    @Override
    public long serializedSize(RangeSliceCommand rsc, int version) {
        long size = TypeSizes.NATIVE.sizeof(rsc.keyspace);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.columnFamily);
        if (version >= 7) {
            size += (long)TypeSizes.NATIVE.sizeof(rsc.timestamp);
        }
        IDiskAtomFilter filter = rsc.predicate;
        if (version < 7) {
            Buffer sc = null;
            CFMetaData metadata = Schema.instance.getCFMetaData(rsc.keyspace, rsc.columnFamily);
            if (metadata.cfType == ColumnFamilyType.Super) {
                SuperColumns.SCFilter scFilter = SuperColumns.filterToSC((CompositeType)metadata.comparator, filter);
                sc = scFilter.scName;
                filter = scFilter.updatedFilter;
            }
            if (sc != null) {
                size += (long)TypeSizes.NATIVE.sizeof(sc.remaining());
                size += (long)sc.remaining();
            } else {
                size += (long)TypeSizes.NATIVE.sizeof(0);
            }
        }
        size += IDiskAtomFilter.Serializer.instance.serializedSize(filter, version);
        if (rsc.rowFilter == null) {
            size += (long)TypeSizes.NATIVE.sizeof(0);
        } else {
            size += (long)TypeSizes.NATIVE.sizeof(rsc.rowFilter.size());
            for (IndexExpression expr : rsc.rowFilter) {
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column_name);
                size += (long)TypeSizes.NATIVE.sizeof(expr.op.getValue());
                size += (long)TypeSizes.NATIVE.sizeofWithLength(expr.value);
            }
        }
        size += AbstractBounds.serializer.serializedSize(rsc.keyRange, version);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.maxResults);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.countCQL3Rows);
        return size += (long)TypeSizes.NATIVE.sizeof(rsc.isPaging);
    }
}

