/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceByNamesReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceByNamesReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand cmd, DataOutput out, int version) throws IOException {
        this.serialize(cmd, null, out, version);
    }

    public void serialize(ReadCommand cmd, ByteBuffer superColumn, DataOutput out, int version) throws IOException {
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        out.writeBoolean(command.isDigestQuery());
        out.writeUTF(command.ksName);
        ByteBufferUtil.writeWithShortLength(command.key, out);
        if (version < 7) {
            new QueryPath(command.cfName, superColumn).serialize(out);
        } else {
            out.writeUTF(command.cfName);
        }
        if (version >= 7) {
            out.writeLong(cmd.timestamp);
        }
        NamesQueryFilter.serializer.serialize(command.filter, out, version);
    }

    @Override
    public ReadCommand deserialize(DataInput in, int version) throws IOException {
        ReadCommand command;
        String cfName;
        boolean isDigest = in.readBoolean();
        String keyspaceName = in.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
        ByteBuffer sc = null;
        if (version < 7) {
            QueryPath path = QueryPath.deserialize(in);
            cfName = path.columnFamilyName;
            sc = path.superColumnName;
        } else {
            cfName = in.readUTF();
        }
        long timestamp = version < 7 ? System.currentTimeMillis() : in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
        if (version < 7) {
            AbstractType<?> comparator;
            if (metadata.cfType == ColumnFamilyType.Super) {
                CompositeType type = (CompositeType)metadata.comparator;
                comparator = sc == null ? type.types.get(0) : type.types.get(1);
            } else {
                comparator = metadata.comparator;
            }
            IDiskAtomFilter filter = NamesQueryFilter.serializer.deserialize(in, version, comparator);
            if (metadata.cfType == ColumnFamilyType.Super) {
                filter = SuperColumns.fromSCFilter((CompositeType)metadata.comparator, sc, filter);
            }
            command = filter instanceof NamesQueryFilter ? new SliceByNamesReadCommand(keyspaceName, key, cfName, timestamp, (NamesQueryFilter)filter) : new SliceFromReadCommand(keyspaceName, key, cfName, timestamp, (SliceQueryFilter)filter);
        } else {
            NamesQueryFilter filter = NamesQueryFilter.serializer.deserialize(in, version, metadata.comparator);
            command = new SliceByNamesReadCommand(keyspaceName, key, cfName, timestamp, filter);
        }
        command.setDigestQuery(isDigest);
        return command;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        return this.serializedSize(cmd, null, version);
    }

    public long serializedSize(ReadCommand cmd, ByteBuffer superColumn, int version) {
        TypeSizes sizes = TypeSizes.NATIVE;
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        int size = sizes.sizeof(command.isDigestQuery());
        int keySize = command.key.remaining();
        size += sizes.sizeof(command.ksName);
        size += sizes.sizeof((short)keySize) + keySize;
        size = version < 7 ? (size += new QueryPath(command.cfName, superColumn).serializedSize(sizes)) : (size += sizes.sizeof(command.cfName));
        if (version >= 7) {
            size += sizes.sizeof(cmd.timestamp);
        }
        size = (int)((long)size + NamesQueryFilter.serializer.serializedSize(command.filter, version));
        return size;
    }
}

