/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.utils.Allocator;

public class UnsortedColumns
extends AbstractThreadUnsafeSortedColumns {
    private final ArrayList<Column> columns;
    public static final ColumnFamily.Factory<UnsortedColumns> factory = new ColumnFamily.Factory<UnsortedColumns>(){

        @Override
        public UnsortedColumns create(CFMetaData metadata, boolean insertReversed) {
            assert (!insertReversed);
            return new UnsortedColumns(metadata);
        }
    };

    private UnsortedColumns(CFMetaData metadata) {
        this(metadata, new ArrayList<Column>());
    }

    private UnsortedColumns(CFMetaData metadata, ArrayList<Column> columns) {
        super(metadata);
        this.columns = columns;
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new UnsortedColumns(this.metadata, new ArrayList<Column>(this.columns));
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    @Override
    public void clear() {
        this.columns.clear();
    }

    @Override
    public void addColumn(Column column, Allocator allocator) {
        this.columns.add(column);
    }

    @Override
    public void addAll(ColumnFamily cm, Allocator allocator, Function<Column, Column> transformation) {
        for (Column column : cm) {
            this.addColumn(column);
        }
    }

    @Override
    public Iterator<Column> iterator() {
        return this.columns.iterator();
    }

    @Override
    public boolean replace(Column oldColumn, Column newColumn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Column getColumn(ByteBuffer name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<ByteBuffer> getColumnNames() {
        return Iterables.transform(this.columns, (Function)new Function<Column, ByteBuffer>(){

            public ByteBuffer apply(Column column) {
                return column.name;
            }
        });
    }

    @Override
    public Collection<Column> getSortedColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Column> getReverseSortedColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Iterator<Column> iterator(ColumnSlice[] slices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Column> reverseIterator(ColumnSlice[] slices) {
        throw new UnsupportedOperationException();
    }
}

