/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleSliceReader
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSliceReader.class);
    private final FileDataInput file;
    private final boolean needsClosing;
    private final ByteBuffer finishColumn;
    private final AbstractType<?> comparator;
    private final ColumnFamily emptyColumnFamily;
    private final Iterator<OnDiskAtom> atomIterator;

    public SimpleSliceReader(SSTableReader sstable, RowIndexEntry indexEntry, FileDataInput input, ByteBuffer finishColumn) {
        Tracing.trace("Seeking to partition beginning in data file");
        this.finishColumn = finishColumn;
        this.comparator = sstable.metadata.comparator;
        try {
            if (input == null) {
                this.file = sstable.getFileDataInput(indexEntry.position);
                this.needsClosing = true;
            } else {
                this.file = input;
                input.seek(indexEntry.position);
                this.needsClosing = false;
            }
            Descriptor.Version version = sstable.descriptor.version;
            ByteBufferUtil.skipShortLength(this.file);
            if (version.hasRowSizeAndColumnCount) {
                this.file.readLong();
            }
            this.emptyColumnFamily = EmptyColumns.factory.create(sstable.metadata);
            this.emptyColumnFamily.delete(DeletionTime.serializer.deserialize(this.file));
            int columnCount = version.hasRowSizeAndColumnCount ? this.file.readInt() : Integer.MAX_VALUE;
            this.atomIterator = this.emptyColumnFamily.metadata().getOnDiskIterator(this.file, columnCount, sstable.descriptor.version);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
    }

    protected OnDiskAtom computeNext() {
        if (!this.atomIterator.hasNext()) {
            return (OnDiskAtom)this.endOfData();
        }
        OnDiskAtom column = this.atomIterator.next();
        if (this.finishColumn.remaining() > 0 && this.comparator.compare(column.name(), this.finishColumn) > 0) {
            return (OnDiskAtom)this.endOfData();
        }
        return column;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.emptyColumnFamily;
    }

    @Override
    public void close() throws IOException {
        if (this.needsClosing) {
            this.file.close();
        }
    }

    @Override
    public DecoratedKey getKey() {
        throw new UnsupportedOperationException();
    }
}

