/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCompactionIterable
extends AbstractCompactionIterable {
    private static final Logger logger = LoggerFactory.getLogger(ParallelCompactionIterable.class);
    private final int maxInMemorySize;

    public ParallelCompactionIterable(OperationType type, List<ICompactionScanner> scanners, CompactionController controller) {
        this(type, scanners, controller, DatabaseDescriptor.getInMemoryCompactionLimit() / scanners.size());
    }

    public ParallelCompactionIterable(OperationType type, List<ICompactionScanner> scanners, CompactionController controller, int maxInMemorySize) {
        super(controller, type, scanners);
        this.maxInMemorySize = maxInMemorySize;
    }

    @Override
    public CloseableIterator<AbstractCompactedRow> iterator() {
        ArrayList<Deserializer> sources = new ArrayList<Deserializer>(this.scanners.size());
        for (ICompactionScanner scanner : this.scanners) {
            sources.add(new Deserializer(scanner, this.maxInMemorySize));
        }
        return new Unwrapper(MergeIterator.get(sources, RowContainer.comparator, new Reducer()));
    }

    private static class CompactedRowContainer {
        public final DecoratedKey key;
        public final Future<ColumnFamily> future;
        public final LazilyCompactedRow row;

        private CompactedRowContainer(DecoratedKey key, Future<ColumnFamily> future) {
            this.key = key;
            this.future = future;
            this.row = null;
        }

        private CompactedRowContainer(LazilyCompactedRow row) {
            this.row = row;
            this.future = null;
            this.key = null;
        }
    }

    private static class RowContainer {
        public final Row row;
        public final NotifyingSSTableIdentityIterator wrapper;
        public static final Comparator<RowContainer> comparator = new Comparator<RowContainer>(){

            @Override
            public int compare(RowContainer o1, RowContainer o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };

        private RowContainer(Row row) {
            this.row = row;
            this.wrapper = null;
        }

        public RowContainer(NotifyingSSTableIdentityIterator wrapper) {
            this.wrapper = wrapper;
            this.row = null;
        }

        public DecoratedKey getKey() {
            return this.row == null ? this.wrapper.getKey() : this.row.key;
        }
    }

    private static class NotifyingSSTableIdentityIterator
    implements OnDiskAtomIterator {
        private final SSTableIdentityIterator wrapped;
        private final SimpleCondition condition;

        public NotifyingSSTableIdentityIterator(SSTableIdentityIterator wrapped, SimpleCondition condition) {
            this.wrapped = wrapped;
            this.condition = condition;
        }

        @Override
        public ColumnFamily getColumnFamily() {
            return this.wrapped.getColumnFamily();
        }

        @Override
        public DecoratedKey getKey() {
            return this.wrapped.getKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.wrapped.close();
            }
            finally {
                this.condition.signalAll();
            }
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public OnDiskAtom next() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Deserializer
    extends AbstractIterator<RowContainer>
    implements CloseableIterator<RowContainer> {
        private final LinkedBlockingQueue<RowContainer> queue = new LinkedBlockingQueue(1);
        private static final RowContainer finished = new RowContainer(null);
        private final ICompactionScanner scanner;

        public Deserializer(ICompactionScanner ssts, final int maxInMemorySize) {
            this.scanner = ssts;
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws Exception {
                    SimpleCondition condition = null;
                    while (true) {
                        if (condition != null) {
                            condition.await();
                            condition = null;
                        }
                        if (!Deserializer.this.scanner.hasNext()) break;
                        SSTableIdentityIterator iter = (SSTableIdentityIterator)Deserializer.this.scanner.next();
                        if (iter.dataSize > (long)maxInMemorySize) {
                            logger.debug("parallel lazy deserialize from {}", (Object)iter.getPath());
                            condition = new SimpleCondition();
                            Deserializer.this.queue.put(new RowContainer(new NotifyingSSTableIdentityIterator(iter, condition)));
                            continue;
                        }
                        logger.debug("parallel eager deserialize from {}", (Object)iter.getPath());
                        Deserializer.this.queue.put(new RowContainer(new Row(iter.getKey(), iter.getColumnFamilyWithColumns(ArrayBackedSortedColumns.factory))));
                    }
                    Deserializer.this.queue.put(finished);
                }
            };
            new Thread((Runnable)runnable, "Deserialize " + this.scanner.getBackingFiles()).start();
        }

        protected RowContainer computeNext() {
            RowContainer container;
            try {
                container = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            return container == finished ? (RowContainer)this.endOfData() : container;
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }

    private class Reducer
    extends MergeIterator.Reducer<RowContainer, CompactedRowContainer> {
        private final List<RowContainer> rows = new ArrayList<RowContainer>();
        private final ThreadPoolExecutor executor = new DebuggableThreadPoolExecutor(FBUtilities.getAvailableProcessors(), Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("CompactionReducer"));

        private Reducer() {
        }

        @Override
        public void reduce(RowContainer current) {
            this.rows.add(current);
        }

        @Override
        protected CompactedRowContainer getReduced() {
            assert (this.rows.size() > 0);
            ParallelCompactionIterable.this.updateCounterFor(this.rows.size());
            CompactedRowContainer compacted = this.getCompactedRow(this.rows);
            this.rows.clear();
            long n = 0L;
            for (ICompactionScanner scanner : ParallelCompactionIterable.this.scanners) {
                n += scanner.getCurrentPosition();
            }
            ParallelCompactionIterable.this.bytesRead = n;
            return compacted;
        }

        public CompactedRowContainer getCompactedRow(List<RowContainer> rows) {
            boolean inMemory = true;
            for (RowContainer container : rows) {
                if (container.row != null) continue;
                inMemory = false;
                break;
            }
            if (inMemory) {
                ArrayList<Row> rawRows = new ArrayList<Row>(rows.size());
                for (RowContainer rowContainer : rows) {
                    rawRows.add(rowContainer.row);
                }
                return new CompactedRowContainer(rows.get(0).getKey(), this.executor.submit(new MergeTask(rawRows)));
            }
            ArrayList<NotifyingSSTableIdentityIterator> iterators = new ArrayList<NotifyingSSTableIdentityIterator>(rows.size());
            for (RowContainer container : rows) {
                iterators.add((NotifyingSSTableIdentityIterator)(container.row == null ? container.wrapper : new DeserializedColumnIterator(container.row)));
            }
            return new CompactedRowContainer(new LazilyCompactedRow(ParallelCompactionIterable.this.controller, iterators));
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }

        private class DeserializedColumnIterator
        implements OnDiskAtomIterator {
            private final Row row;
            private final Iterator<Column> iter;

            public DeserializedColumnIterator(Row row) {
                this.row = row;
                this.iter = row.cf.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return this.row.cf;
            }

            @Override
            public DecoratedKey getKey() {
                return this.row.key;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public OnDiskAtom next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class MergeTask
        implements Callable<ColumnFamily> {
            private final List<Row> rows;

            public MergeTask(List<Row> rows) {
                this.rows = rows;
            }

            @Override
            public ColumnFamily call() throws Exception {
                ArrayBackedSortedColumns returnCF = ArrayBackedSortedColumns.factory.create(ParallelCompactionIterable.this.controller.cfs.metadata);
                ArrayList<CloseableIterator<Column>> data = new ArrayList<CloseableIterator<Column>>(this.rows.size());
                for (Row row : this.rows) {
                    returnCF.delete(row.cf);
                    data.add(FBUtilities.closeableIterator(row.cf.iterator()));
                }
                PrecompactedRow.merge(returnCF, data, ParallelCompactionIterable.this.controller.cfs.indexManager.updaterFor(this.rows.get((int)0).key));
                return PrecompactedRow.removeDeletedAndOldShards(this.rows.get((int)0).key, ParallelCompactionIterable.this.controller, returnCF);
            }
        }
    }

    private static class Unwrapper
    extends AbstractIterator<AbstractCompactedRow>
    implements CloseableIterator<AbstractCompactedRow> {
        private final CloseableIterator<CompactedRowContainer> reducer;

        public Unwrapper(CloseableIterator<CompactedRowContainer> reducer) {
            this.reducer = reducer;
        }

        protected AbstractCompactedRow computeNext() {
            if (!this.reducer.hasNext()) {
                return (AbstractCompactedRow)this.endOfData();
            }
            CompactedRowContainer container = (CompactedRowContainer)this.reducer.next();
            AbstractCompactedRow compactedRow = container.future == null ? container.row : new PrecompactedRow(container.key, FBUtilities.waitOnFuture(container.future));
            return compactedRow;
        }

        @Override
        public void close() throws IOException {
            this.reducer.close();
        }
    }
}

