/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableWriter
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableWriter.class);
    public static final int END_OF_ROW = 0;
    private IndexWriter iwriter;
    private SegmentedFile.Builder dbuilder;
    private final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private FileMark dataMark;
    private final SSTableMetadata.Collector sstableMetadataCollector;

    public SSTableWriter(String filename, long keyCount) {
        this(filename, keyCount, Schema.instance.getCFMetaData(Descriptor.fromFilename(filename)), StorageService.getPartitioner(), SSTableMetadata.createCollector(Schema.instance.getCFMetaData((Descriptor)Descriptor.fromFilename((String)filename)).comparator));
    }

    private static Set<Component> components(CFMetaData metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC));
        if (metadata.getBloomFilterFpChance() < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.compressionParameters().sstableCompressor != null) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.DIGEST);
            components.add(Component.CRC);
        }
        return components;
    }

    public SSTableWriter(String filename, long keyCount, CFMetaData metadata, IPartitioner<?> partitioner, SSTableMetadata.Collector sstableMetadataCollector) {
        super(Descriptor.fromFilename(filename), SSTableWriter.components(metadata), metadata, partitioner);
        this.iwriter = new IndexWriter(keyCount);
        if (this.compression) {
            this.dbuilder = SegmentedFile.getCompressedBuilder();
            this.dataFile = CompressedSequentialWriter.open(this.getFilename(), this.descriptor.filenameFor(Component.COMPRESSION_INFO), !metadata.populateIoCacheOnFlush(), metadata.compressionParameters(), sstableMetadataCollector);
        } else {
            this.dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
            this.dataFile = SequentialWriter.open(new File(this.getFilename()), !metadata.populateIoCacheOnFlush());
            this.dataFile.setDataIntegrityWriter(DataIntegrityMetadata.checksumWriter(this.descriptor));
        }
        this.sstableMetadataCollector = sstableMetadataCollector;
    }

    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    private long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataPosition, RowIndexEntry index) {
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote " + decoratedKey + " at " + dataPosition);
        }
        this.iwriter.append(decoratedKey, index);
        this.dbuilder.addPotentialBoundary(dataPosition);
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        RowIndexEntry entry;
        long currentPosition = this.beforeAppend(row.key);
        try {
            entry = row.write(currentPosition, this.dataFile.stream);
            if (entry == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - currentPosition, row.columnStats());
        this.afterAppend(row.key, currentPosition, entry);
        return entry;
    }

    public void append(DecoratedKey decoratedKey, ColumnFamily cf) {
        long startPosition = this.beforeAppend(decoratedKey);
        try {
            RowIndexEntry entry = SSTableWriter.rawAppend(cf, startPosition, decoratedKey, this.dataFile.stream);
            this.afterAppend(decoratedKey, startPosition, entry);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - startPosition, cf.getColumnStats());
    }

    public static RowIndexEntry rawAppend(ColumnFamily cf, long startPosition, DecoratedKey key, DataOutput out) throws IOException {
        assert (cf.getColumnCount() > 0 || cf.isMarkedForDelete());
        ColumnIndex.Builder builder = new ColumnIndex.Builder(cf, key.key, out);
        ColumnIndex index = builder.build(cf);
        out.writeShort(0);
        return RowIndexEntry.create(startPosition, cf.deletionInfo().getTopLevelDeletion(), index);
    }

    public long appendFromStream(DecoratedKey key, CFMetaData metadata, DataInput in, Descriptor.Version version) throws IOException {
        long currentPosition = this.beforeAppend(key);
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        int maxLocalDeletionTime = Integer.MIN_VALUE;
        List<ByteBuffer> minColumnNames = Collections.emptyList();
        List<ByteBuffer> maxColumnNames = Collections.emptyList();
        StreamingHistogram tombstones = new StreamingHistogram(100);
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(metadata);
        ((ColumnFamily)cf).delete(DeletionTime.serializer.deserialize(in));
        ColumnIndex.Builder columnIndexer = new ColumnIndex.Builder(cf, key.key, this.dataFile.stream);
        int columnCount = Integer.MAX_VALUE;
        if (version.hasRowSizeAndColumnCount) {
            FileUtils.skipBytesFully(in, 8);
            columnCount = in.readInt();
        }
        Iterator<OnDiskAtom> iter = metadata.getOnDiskIterator(in, columnCount, ColumnSerializer.Flag.PRESERVE_SIZE, Integer.MIN_VALUE, version);
        try {
            OnDiskAtom atom;
            while (iter.hasNext() && (atom = iter.next()) != null) {
                int deletionTime;
                if (atom instanceof CounterColumn) {
                    atom = ((CounterColumn)atom).markDeltaToBeCleared();
                }
                if ((deletionTime = atom.getLocalDeletionTime()) < Integer.MAX_VALUE) {
                    tombstones.update(deletionTime);
                }
                minTimestamp = Math.min(minTimestamp, atom.minTimestamp());
                maxTimestamp = Math.max(maxTimestamp, atom.maxTimestamp());
                minColumnNames = ColumnNameHelper.minComponents(minColumnNames, atom.name(), metadata.comparator);
                maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, atom.name(), metadata.comparator);
                maxLocalDeletionTime = Math.max(maxLocalDeletionTime, atom.getLocalDeletionTime());
                columnIndexer.add(atom);
            }
            columnIndexer.finish();
            this.dataFile.stream.writeShort(0);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.updateMinTimestamp(minTimestamp);
        this.sstableMetadataCollector.updateMaxTimestamp(maxTimestamp);
        this.sstableMetadataCollector.updateMaxLocalDeletionTime(maxLocalDeletionTime);
        this.sstableMetadataCollector.addRowSize(this.dataFile.getFilePointer() - currentPosition);
        this.sstableMetadataCollector.addColumnCount(columnIndexer.writtenAtomCount());
        this.sstableMetadataCollector.mergeTombstoneHistogram(tombstones);
        this.sstableMetadataCollector.updateMinColumnNames(minColumnNames);
        this.sstableMetadataCollector.updateMaxColumnNames(maxColumnNames);
        this.afterAppend(key, currentPosition, RowIndexEntry.create(currentPosition, ((ColumnFamily)cf).deletionInfo().getTopLevelDeletion(), columnIndexer.build()));
        return currentPosition;
    }

    public void abort() {
        assert (this.descriptor.temporary);
        FileUtils.closeQuietly(this.iwriter);
        FileUtils.closeQuietly(this.dataFile);
        Set<Component> components = SSTable.componentsFor(this.descriptor);
        try {
            if (!components.isEmpty()) {
                SSTable.delete(this.descriptor, components);
            }
        }
        catch (FSWriteError e) {
            logger.error(String.format("Failed deleting temp components for %s", this.descriptor), (Throwable)e);
            throw e;
        }
    }

    public SSTableReader closeAndOpenReader() {
        return this.closeAndOpenReader(System.currentTimeMillis());
    }

    public SSTableReader closeAndOpenReader(long maxDataAge) {
        this.iwriter.close();
        this.dataFile.close();
        SSTableMetadata sstableMetadata = this.sstableMetadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName(), this.metadata.getBloomFilterFpChance());
        SSTableWriter.writeMetadata(this.descriptor, sstableMetadata, this.sstableMetadataCollector.ancestors);
        SSTable.appendTOC(this.descriptor, this.components);
        Descriptor newdesc = SSTableWriter.rename(this.descriptor, this.components);
        SegmentedFile ifile = this.iwriter.builder.complete(newdesc.filenameFor(SSTable.COMPONENT_INDEX));
        SegmentedFile dfile = this.dbuilder.complete(newdesc.filenameFor(SSTable.COMPONENT_DATA));
        SSTableReader sstable = SSTableReader.internalOpen(newdesc, this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner), this.iwriter.bf, maxDataAge, sstableMetadata);
        sstable.first = SSTableWriter.getMinimalKey(this.first);
        sstable.last = SSTableWriter.getMinimalKey(this.last);
        SSTableReader.saveSummary(sstable, this.iwriter.builder, this.dbuilder);
        this.iwriter = null;
        this.dbuilder = null;
        return sstable;
    }

    private static void writeMetadata(Descriptor desc, SSTableMetadata sstableMetadata, Set<Integer> ancestors) {
        SequentialWriter out = SequentialWriter.open(new File(desc.filenameFor(SSTable.COMPONENT_STATS)), true);
        try {
            SSTableMetadata.serializer.serialize(sstableMetadata, ancestors, out.stream);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, out.getPath());
        }
        out.close();
    }

    static Descriptor rename(Descriptor tmpdesc, Set<Component> components) {
        Descriptor newdesc = tmpdesc.asTemporary(false);
        SSTableWriter.rename(tmpdesc, newdesc, components);
        return newdesc;
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, (Set)Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.SUMMARY}))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    class IndexWriter
    implements Closeable {
        private final SequentialWriter indexFile;
        public final SegmentedFile.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private FileMark mark;

        IndexWriter(long keyCount) {
            this.indexFile = SequentialWriter.open(new File(SSTableWriter.this.descriptor.filenameFor(SSTable.COMPONENT_INDEX)), !SSTableWriter.this.metadata.populateIoCacheOnFlush());
            this.builder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
            this.summary = new IndexSummaryBuilder(keyCount, SSTableWriter.this.metadata.getIndexInterval());
            this.bf = FilterFactory.getFilter(keyCount, SSTableWriter.this.metadata.getBloomFilterFpChance(), true);
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry) {
            this.bf.add(key.key);
            long indexPosition = this.indexFile.getFilePointer();
            try {
                ByteBufferUtil.writeWithShortLength(key.key, this.indexFile.stream);
                RowIndexEntry.serializer.serialize(indexEntry, this.indexFile.stream);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: " + indexEntry + " at " + indexPosition);
            }
            this.summary.maybeAddEntry(key, indexPosition);
            this.builder.addPotentialBoundary(indexPosition);
        }

        @Override
        public void close() {
            if (SSTableWriter.this.components.contains(Component.FILTER)) {
                String path = SSTableWriter.this.descriptor.filenameFor(SSTable.COMPONENT_FILTER);
                try {
                    FileOutputStream fos = new FileOutputStream(path);
                    DataOutputStream stream = new DataOutputStream(fos);
                    FilterFactory.serialize(this.bf, stream);
                    stream.flush();
                    fos.getFD().sync();
                    stream.close();
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
            long position = this.indexFile.getFilePointer();
            this.indexFile.close();
            FileUtils.truncate(this.indexFile.getPath(), position);
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        public String toString() {
            return "IndexWriter(" + SSTableWriter.this.descriptor + ")";
        }
    }
}

