/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class BulkLoader {
    private static final String TOOL_NAME = "sstableloader";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String NOPROGRESS_OPTION = "no-progress";
    private static final String IGNORE_NODES_OPTION = "ignore";
    private static final String INITIAL_HOST_ADDRESS_OPTION = "nodes";
    private static final String RPC_PORT_OPTION = "port";
    private static final String USER_OPTION = "username";
    private static final String PASSWD_OPTION = "password";
    private static final String THROTTLE_MBITS = "throttle";

    public static void main(String[] args) {
        LoaderOptions options = LoaderOptions.parseArgs(args);
        OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
        SSTableLoader loader = new SSTableLoader(options.directory, new ExternalClient(options.hosts, options.rpcPort, options.user, options.passwd), handler);
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(options.throttle);
        StreamResultFuture future = loader.stream(options.ignores);
        future.addEventListener(new ProgressIndicator());
        try {
            future.get();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Streaming to the following hosts failed:");
            System.err.println(loader.getFailedHosts());
            System.err.println(e);
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    public static class CmdLineOptions
    extends Options {
        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }

    static class LoaderOptions {
        public final File directory;
        public boolean debug;
        public boolean verbose;
        public boolean noProgress;
        public int rpcPort = 9160;
        public String user;
        public String passwd;
        public int throttle = 0;
        public final Set<InetAddress> hosts = new HashSet<InetAddress>();
        public final Set<InetAddress> ignores = new HashSet<InetAddress>();

        LoaderOptions(File directory) {
            this.directory = directory;
        }

        public static LoaderOptions parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            CmdLineOptions options = LoaderOptions.getCmdLineOptions();
            try {
                String[] nodes;
                String dirname;
                File dir;
                String[] args;
                CommandLine cmd = parser.parse((Options)options, cmdArgs, false);
                if (cmd.hasOption(BulkLoader.HELP_OPTION)) {
                    LoaderOptions.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length == 0) {
                    System.err.println("Missing sstable directory argument");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (args.length > 1) {
                    System.err.println("Too many arguments");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (!(dir = new File(dirname = args[0])).exists()) {
                    LoaderOptions.errorMsg("Unknown directory: " + dirname, options);
                }
                if (!dir.isDirectory()) {
                    LoaderOptions.errorMsg(dirname + " is not a directory", options);
                }
                LoaderOptions opts = new LoaderOptions(dir);
                opts.debug = cmd.hasOption(BulkLoader.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(BulkLoader.VERBOSE_OPTION);
                opts.noProgress = cmd.hasOption(BulkLoader.NOPROGRESS_OPTION);
                if (cmd.hasOption(BulkLoader.THROTTLE_MBITS)) {
                    opts.throttle = Integer.parseInt(cmd.getOptionValue(BulkLoader.THROTTLE_MBITS));
                }
                if (cmd.hasOption(BulkLoader.RPC_PORT_OPTION)) {
                    opts.rpcPort = Integer.parseInt(cmd.getOptionValue(BulkLoader.RPC_PORT_OPTION));
                }
                if (cmd.hasOption(BulkLoader.USER_OPTION)) {
                    opts.user = cmd.getOptionValue(BulkLoader.USER_OPTION);
                }
                if (cmd.hasOption(BulkLoader.PASSWD_OPTION)) {
                    opts.passwd = cmd.getOptionValue(BulkLoader.PASSWD_OPTION);
                }
                if (cmd.hasOption(BulkLoader.INITIAL_HOST_ADDRESS_OPTION)) {
                    nodes = cmd.getOptionValue(BulkLoader.INITIAL_HOST_ADDRESS_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            opts.hosts.add(InetAddress.getByName(node.trim()));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                } else {
                    System.err.println("Initial hosts must be specified (-d)");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (cmd.hasOption(BulkLoader.IGNORE_NODES_OPTION)) {
                    nodes = cmd.getOptionValue(BulkLoader.IGNORE_NODES_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            opts.ignores.add(InetAddress.getByName(node.trim()));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                }
                return opts;
            }
            catch (ParseException e) {
                LoaderOptions.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, CmdLineOptions options) {
            System.err.println(msg);
            LoaderOptions.printUsage(options);
            System.exit(1);
        }

        private static CmdLineOptions getCmdLineOptions() {
            CmdLineOptions options = new CmdLineOptions();
            options.addOption(null, BulkLoader.DEBUG_OPTION, "display stack traces");
            options.addOption("v", BulkLoader.VERBOSE_OPTION, "verbose output");
            options.addOption("h", BulkLoader.HELP_OPTION, "display this help message");
            options.addOption(null, BulkLoader.NOPROGRESS_OPTION, "don't display progress");
            options.addOption("i", BulkLoader.IGNORE_NODES_OPTION, "NODES", "don't stream to this (comma separated) list of nodes");
            options.addOption("d", BulkLoader.INITIAL_HOST_ADDRESS_OPTION, "initial hosts", "try to connect to these hosts (comma separated) initially for ring information");
            options.addOption("p", BulkLoader.RPC_PORT_OPTION, "rpc port", "port used for rpc (default 9160)");
            options.addOption("t", BulkLoader.THROTTLE_MBITS, BulkLoader.THROTTLE_MBITS, "throttle speed in Mbits (default unlimited)");
            options.addOption("u", BulkLoader.USER_OPTION, BulkLoader.USER_OPTION, "username for cassandra authentication");
            options.addOption("pw", BulkLoader.PASSWD_OPTION, BulkLoader.PASSWD_OPTION, "password for cassandra authentication");
            return options;
        }

        public static void printUsage(Options options) {
            String usage = String.format("%s [options] <dir_path>", BulkLoader.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Bulk load the sstables found in the directory <dir_path> to the configured cluster.");
            header.append("The parent directory of <dir_path> is used as the keyspace name. ");
            header.append("So for instance, to load an sstable named Standard1-g-1-Data.db into keyspace Keyspace1, ");
            header.append("you will need to have the files Standard1-g-1-Data.db and Standard1-g-1-Index.db in a ");
            header.append("directory Keyspace1/Standard1/ in the directory and call: sstableloader Keyspace1/Standard1");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), options, "");
        }
    }

    static class ExternalClient
    extends SSTableLoader.Client {
        private final Map<String, CFMetaData> knownCfs = new HashMap<String, CFMetaData>();
        private final Set<InetAddress> hosts;
        private final int rpcPort;
        private final String user;
        private final String passwd;

        public ExternalClient(Set<InetAddress> hosts, int port, String user, String passwd) {
            this.hosts = hosts;
            this.rpcPort = port;
            this.user = user;
            this.passwd = passwd;
        }

        @Override
        public void init(String keyspace) {
            Iterator<InetAddress> hostiter = this.hosts.iterator();
            while (hostiter.hasNext()) {
                try {
                    InetAddress host = hostiter.next();
                    Cassandra.Client client = ExternalClient.createThriftClient(host.getHostAddress(), this.rpcPort, this.user, this.passwd);
                    this.setPartitioner(client.describe_partitioner());
                    Token.TokenFactory tkFactory = this.getPartitioner().getTokenFactory();
                    for (TokenRange tr : client.describe_ring(keyspace)) {
                        Range<Token> range = new Range<Token>(tkFactory.fromString(tr.start_token), tkFactory.fromString(tr.end_token));
                        for (String ep : tr.endpoints) {
                            this.addRangeForEndpoint(range, InetAddress.getByName(ep));
                        }
                    }
                    String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = '%s'", "system", "schema_columnfamilies", keyspace);
                    CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(query), Compression.NONE, ConsistencyLevel.ONE);
                    for (CqlRow row : result.rows) {
                        CFMetaData metadata = CFMetaData.fromThriftCqlRow(row);
                        this.knownCfs.put(metadata.cfName, metadata);
                    }
                    break;
                }
                catch (Exception e) {
                    if (hostiter.hasNext()) continue;
                    throw new RuntimeException("Could not retrieve endpoint ranges: ", e);
                }
            }
        }

        @Override
        public CFMetaData getCFMetaData(String keyspace, String cfName) {
            return this.knownCfs.get(cfName);
        }

        private static Cassandra.Client createThriftClient(String host, int port, String user, String passwd) throws Exception {
            TSocket socket = new TSocket(host, port);
            TFramedTransport trans = new TFramedTransport((TTransport)socket);
            trans.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)trans);
            Cassandra.Client client = new Cassandra.Client((TProtocol)protocol);
            if (user != null && passwd != null) {
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put(BulkLoader.USER_OPTION, user);
                credentials.put(BulkLoader.PASSWD_OPTION, passwd);
                AuthenticationRequest authenticationRequest = new AuthenticationRequest(credentials);
                client.login(authenticationRequest);
            }
            return client;
        }
    }

    static class ProgressIndicator
    implements StreamEventHandler {
        private final Map<InetAddress, SessionInfo> sessionsByHost = new HashMap<InetAddress, SessionInfo>();
        private final Map<InetAddress, Set<ProgressInfo>> progressByHost = new HashMap<InetAddress, Set<ProgressInfo>>();
        private long start = this.lastTime = System.nanoTime();
        private long lastProgress;
        private long lastTime;

        public void onSuccess(StreamState finalState) {
        }

        public void onFailure(Throwable t) {
        }

        @Override
        public void handleStreamEvent(StreamEvent event) {
            if (event.eventType == StreamEvent.Type.STREAM_PREPARED) {
                SessionInfo session = ((StreamEvent.SessionPreparedEvent)event).session;
                this.sessionsByHost.put(session.peer, session);
            } else if (event.eventType == StreamEvent.Type.FILE_PROGRESS) {
                ProgressInfo progressInfo = ((StreamEvent.ProgressEvent)event).progress;
                Set<ProgressInfo> progresses = this.progressByHost.get(progressInfo.peer);
                if (progresses == null) {
                    progresses = new HashSet<ProgressInfo>();
                    this.progressByHost.put(progressInfo.peer, progresses);
                }
                if (progresses.contains(progressInfo)) {
                    progresses.remove(progressInfo);
                }
                progresses.add(progressInfo);
                StringBuilder sb = new StringBuilder();
                sb.append("\rprogress: ");
                long totalProgress = 0L;
                long totalSize = 0L;
                for (Map.Entry<InetAddress, Set<ProgressInfo>> entry : this.progressByHost.entrySet()) {
                    SessionInfo session = this.sessionsByHost.get(entry.getKey());
                    long size = session.getTotalSizeToSend();
                    long current = 0L;
                    int completed = 0;
                    for (ProgressInfo progress : entry.getValue()) {
                        if (progress.currentBytes == progress.totalBytes) {
                            ++completed;
                        }
                        current += progress.currentBytes;
                    }
                    totalProgress += current;
                    totalSize += size;
                    sb.append("[").append(entry.getKey());
                    sb.append(" ").append(completed).append("/").append(session.getTotalFilesToSend());
                    sb.append(" (").append(size == 0L ? 100L : current * 100L / size).append("%)] ");
                }
                long time = System.nanoTime();
                long deltaTime = TimeUnit.NANOSECONDS.toMillis(time - this.lastTime);
                this.lastTime = time;
                long deltaProgress = totalProgress - this.lastProgress;
                this.lastProgress = totalProgress;
                sb.append("[total: ").append(totalSize == 0L ? 100L : totalProgress * 100L / totalSize).append("% - ");
                sb.append(this.mbPerSec(deltaProgress, deltaTime)).append("MB/s");
                sb.append(" (avg: ").append(this.mbPerSec(totalProgress, TimeUnit.NANOSECONDS.toMillis(time - this.start))).append("MB/s)]");
                System.out.print(sb.toString());
            }
        }

        private int mbPerSec(long bytes, long timeInMs) {
            double bytesPerMs = (double)bytes / (double)timeInMs;
            return (int)(bytesPerMs * 1000.0 / 2072576.0);
        }
    }
}

