/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledScheduledThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.metrics.ThreadPoolMetrics;

public class JMXEnabledScheduledThreadPoolExecutor
extends DebuggableScheduledThreadPoolExecutor
implements JMXEnabledScheduledThreadPoolExecutorMBean {
    private final String mbeanName;
    private final ThreadPoolMetrics metrics;

    public JMXEnabledScheduledThreadPoolExecutor(int corePoolSize, NamedThreadFactory threadFactory, String jmxPath) {
        super(corePoolSize, threadFactory);
        this.metrics = new ThreadPoolMetrics(this, jmxPath, threadFactory.id);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + threadFactory.id;
        try {
            mbs.registerMBean(this, new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unregisterMBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.metrics.release();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    @Override
    public long getCompletedTasks() {
        return this.getCompletedTaskCount();
    }

    @Override
    public long getPendingTasks() {
        return this.getTaskCount() - this.getCompletedTaskCount();
    }

    @Override
    public int getTotalBlockedTasks() {
        return (int)this.metrics.totalBlocked.count();
    }

    @Override
    public int getCurrentlyBlockedTasks() {
        return (int)this.metrics.currentBlocked.count();
    }

    @Override
    public int getCoreThreads() {
        return this.getCorePoolSize();
    }

    @Override
    public void setCoreThreads(int number) {
        this.setCorePoolSize(number);
    }

    @Override
    public int getMaximumThreads() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaximumThreads(int number) {
        this.setMaximumPoolSize(number);
    }
}

