/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.util.concurrent.RateLimiter;
import java.io.FileNotFoundException;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;

public class CompressedThrottledReader
extends CompressedRandomAccessReader {
    private final RateLimiter limiter;

    public CompressedThrottledReader(String file, CompressionMetadata metadata, RateLimiter limiter) throws FileNotFoundException {
        super(file, metadata, null);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.length);
        super.reBuffer();
    }

    public static CompressedThrottledReader open(String file, CompressionMetadata metadata, RateLimiter limiter) {
        try {
            return new CompressedThrottledReader(file, metadata, limiter);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

