/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;

public class QueryState {
    private final ClientState clientState;
    private volatile UUID preparedTracingSession;

    public QueryState(ClientState clientState) {
        this.clientState = clientState;
    }

    public static QueryState forInternalCalls() {
        return new QueryState(ClientState.forInternalCalls());
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public long getTimestamp() {
        return this.clientState.getTimestamp();
    }

    public boolean traceNextQuery() {
        if (this.preparedTracingSession != null) {
            return true;
        }
        double tracingProbability = StorageService.instance.getTracingProbability();
        return tracingProbability != 0.0 && ThreadLocalRandom.current().nextDouble() < tracingProbability;
    }

    public void prepareTracingSession(UUID sessionId) {
        this.preparedTracingSession = sessionId;
    }

    public void createTracingSession() {
        if (this.preparedTracingSession == null) {
            Tracing.instance.newSession();
        } else {
            UUID session = this.preparedTracingSession;
            this.preparedTracingSession = null;
            Tracing.instance.newSession(session);
        }
    }
}

